/*
 * JHPdf Free PDF Library : HPdfBinary.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import net.sf.jhpdf.HPdfConst;
import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.io.HPdfWriteStream;

/**
 * Class represents miscellenius binary data in PDF.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfBinary extends HPdfObject {
    
    /**
     * ctor. this is package-private.
     */
    HPdfBinary() {
        super();
        this.setValue(new byte[0], 0);
    }
    
    private byte[] value;

    public byte[] getValue() {
        return value;
    }

    void setValue(byte[] value, int len) {
        if (value.length > HPdfConst.HPDF_LIMIT_MAX_STRING_LEN) {
            throw new HPdfException(HPdfErrorCode.HPDF_BINARY_LENGTH_ERR, 0);
        }
        
        this.value = new byte[value.length];
        for (int i = 0; i < len; ++i) {
            this.value[i] = value[i];
        }
    }
    
    /**
     * get length of this content.
     * @return length
     */
    public int getLength() {
        return this.getValue().length;
    }
    
    @Override
    protected void writeValue(HPdfWriteStream stream, HPdfEncrypt e) {
        if (this.getLength() == 0) {
            stream.writeStr("<>");
            return ;
        }
        stream.writeChar('<');
        
        if (e != null) {
            e.reset();
        }
        
        stream.writeBinary(this.getValue(), this.getLength(), e);

        stream.writeChar('>');
    }
}
