/*
 * JHPdf Free PDF Library : HPdfStream.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.io;

/**
 * Stream interface.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public interface HPdfStream {
    
    /**
     * flags represents filters on I/O.
     */
    public enum HPdfFilterFlag {
        NONE,
        ASCIIHEX,
        ASCII85,
        FLATE_DECODE,
        DCT_DECODE,
        CCITT_DECODE,
    };
    
    /**
     * indicates stream is valid.
     * @return stream is / not valid.
     */
    public boolean validate();

    /**
     * close stream.
     * @throws HPdfIoException thrown when any error occurred.
     */
    public void close();
    
    /**
     * get size of stream.<br>
     * if stream represents an output stream, size may increase by write operation. 
     * @return current size of stream
     */
    public long getSize();
}
