/*
 * JHPdf Free PDF Library : HPdfFileWriteStream.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.io;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import net.sf.jhpdf.HPdfErrorCode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Stream class for writing to a file.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfFileWriteStream extends HPdfAbstractWriteStream {

    private static final Logger logger = LoggerFactory.getLogger(HPdfFileWriteStream.class);
    
    private BufferedOutputStream stream;
    
    private long currentSize;
    
    /**
     * constructor.
     * @param filePath path of a file to be written
     */
    public HPdfFileWriteStream(String filePath) {
        super();
        
        logger.trace("HPdfFileWriteStream#ctor");
        this.currentSize = 0;
        try {
            this.stream = new BufferedOutputStream(
                    new FileOutputStream(filePath));
        } catch (FileNotFoundException e) {
            throw new HPdfIoException(HPdfErrorCode.HPDF_FILE_OPEN_ERROR, 0, e);
        }
    }

    @Override
    public void write(byte[] buf, int bufOffset, int siz) {
        logger.trace("HPdfFileWriteStream#write");
        try {
                this.stream.write(buf, bufOffset, siz);
                this.currentSize += siz;
        } catch (IOException e) {
            throw new HPdfIoException(HPdfErrorCode.HPDF_FILE_IO_ERROR, 0, e);
        }
    }
    
    @Override
    public void close() {
        logger.trace("HPdfFileWriteStream#close");
        HPdfIOUtil.closeQuietly(this.stream);
        this.stream = null;
    }
    
    @Override
    public long getSize() {
        logger.trace("HPdfFileWriteStream#getSize");
        return this.currentSize;
    }

    @Override
    public boolean validate() {
        logger.trace("HPdfFileWriteStream#validate");
        return super.validate() && this.stream != null;
    }
}
