/*
 * JHPdf Free PDF Library : HPdfTransMatrix.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.graphics;

/**
 * Class represents PDF transform matrix.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfTransMatrix {
    
    public HPdfTransMatrix(float a, float b, float c, float d, float x, float y) {
        super();
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.x = x;
        this.y = y;
    }

    float a;

    public float getA() {
        return this.a;
    }

    float b;

    public float getB() {
        return this.b;
    }

    float c;

    public float getC() {
        return this.c;
    }

    float d;

    public float getD() {
        return this.d;
    }

    float x;
    
    public float getX() {
        return this.x;
    }
    
    float y;
    
    public float getY() {
        return this.y;
    }
}
