/*
 * JHPdf Free PDF Library : HPdfRGBColor.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.graphics;

/**
 * Class represents PDF RGB Color.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfRGBColor implements Cloneable {
    
    public HPdfRGBColor() {
        this(0, 0, 0);
    }
    
    public HPdfRGBColor(float r, float g, float b) {
        super();
        this.r = r;
        this.g = g;
        this.b = b;
    }
    
    private float r;
    
    public float getR() {
        return this.r;
    }
    
    public void setR(float r) {
        this.r = r;
    }
    
    private float g;
    
    public float getG() {
        return this.g;
    }
    
    public void setG(float g) {
        this.g = g;
    }

    private float b;
    
    /**
     * @return b
     */
    public float getB() {
        return this.b;
    }

    /**
     * @param b ݒ肷 Bl
     */
    public void setB(float b) {
        this.b = b;
    }
    
    private void copy(HPdfRGBColor org) {
        this.setR(org.getR());
        this.setG(org.getG());
        this.setB(org.getB());
    }

    @Override
    public HPdfRGBColor clone()  {
        HPdfRGBColor c;
        try {
            c = (HPdfRGBColor) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException("HPdfRGBColor cloning failed", e);
        }
        c.copy(this);
        return c;
    }
    
    
}
