/*
 * JHPdf Free PDF Library : PngDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.io.File;

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfDocument.HPdfCompressionMode;


public class PngDemo implements DemoEntry {
    public static void main(String[] args) {
        new PngDemo().demo(args);
    }
    
    private static final String F_NAME = "PngDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            pdf.setCompressionMode(HPdfCompressionMode.ALL);
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            page.setWidth(550);
            page.setHeight(650);
            
            HPdfDestination dst = page.createDestination();
            dst.setXYZ(0, page.getHeight(), 1);
            pdf.setOpenAction(dst);
            
            page.beginText();
            page.setFontAndSize(font, 20);
            page.moveTextPos(220, page.getHeight() - 70);
            page.showText("PngDemo");
            page.endText();
            
            page.setFontAndSize(font, 12);
            
            drawImage(pdf, "basn0g01.png", 100, page.getHeight() - 150,
                "1bit grayscale.");
            drawImage(pdf, "basn0g02.png", 200, page.getHeight() - 150,
                "2bit grayscale.");
            drawImage(pdf, "basn0g04.png", 300, page.getHeight() - 150,
                "4bit grayscale.");
            drawImage(pdf, "basn0g08.png", 400, page.getHeight() - 150,
                "8bit grayscale.");
            
            drawImage(pdf, "basn2c08.png", 100, page.getHeight() - 250,
                "8bit color.");
            drawImage(pdf, "basn2c16.png", 200, page.getHeight() - 250,
                "16bit color.");
            
            drawImage(pdf, "basn3p01.png", 100, page.getHeight() - 350,
                "1bit pallet.");
            drawImage(pdf, "basn3p02.png", 200, page.getHeight() - 350,
                "2bit pallet.");
            drawImage(pdf, "basn3p04.png", 300, page.getHeight() - 350,
                "4bit pallet.");
            drawImage(pdf, "basn3p08.png", 400, page.getHeight() - 350,
                "8bit pallet.");
            
            drawImage(pdf, "basn4a08.png", 100, page.getHeight() - 450,
                "8bit alpha.");
            drawImage(pdf, "basn4a16.png", 200, page.getHeight() - 450,
                "16bit alpha.");
            
            drawImage(pdf, "basn6a08.png", 100, page.getHeight() - 550,
                "8bit alpha.");
            drawImage(pdf, "basn6a16.png", 200, page.getHeight() - 550,
                "16bit alpha.");
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void drawImage(HPdfDocument pdf, String fileName, float x, float y, String text) {
        
        HPdfPage page = pdf.getCurrentPage();
        
        String filename1 = "pngsuite" + File.separator + fileName;
        
        HPdfImage image = pdf.loadPngImageFromFile(filename1);
        
        /* Draw image to the canvas. */
        page.drawImage(image, x, y, image.getWidth(), image.getHeight());
        
        /* Print the text. */
        page.beginText();
        page.setTextLeading(16);
        page.moveTextPos(x, y);
        page.showTextNextLine(fileName);
        page.showTextNextLine(text);
        page.endText();
    }
    
}
