/*
 * JHPdf Free PDF Library : LinkAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.annotation.HPdfLinkAnnotation;
import net.sf.jhpdf.pdfobject.annotation.HPdfLinkAnnotation.HPdfHighlightMode;
import net.sf.jhpdf.graphics.*;


public class LinkAnnotation implements DemoEntry {
    public static void main(String[] args) {
        new LinkAnnotation().demo(args);
    }
    
    private static final String F_NAME = "LinkAnnotation.pdf";
    
    @Override
    public void demo(String[] args) {
        
        final String uri = "http://jhpdf.sourceforge.jp/"; // MEMO: original uri is "http://libharu.org"
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* create index page */
            HPdfPage indexPage = pdf.addPage();
            indexPage.setWidth(300);
            indexPage.setHeight(220);
            
            /* Add 7 pages to the document. */
            HPdfPage[] page = new HPdfPage[9];
            for (int i = 0; i < 7; ++i) {
                page[i] = pdf.addPage();
                printPage(page[i], font, i + 1);
            }
            
            indexPage.beginText();
            indexPage.setFontAndSize(font, 10);
            indexPage.moveTextPos(15, 200);
            indexPage.showText("Link Annotation Demo");
            indexPage.endText();
            
            /*
             * Create Link-Annotation object on index page.
             */
            indexPage.beginText();
            indexPage.setFontAndSize(font, 8);
            indexPage.moveTextPos(20, 180);
            indexPage.setTextLeading(23);
            
            HPdfRect rect = new HPdfRect();
            HPdfPoint tp;
            HPdfDestination dst;
            HPdfLinkAnnotation annot;
            
            /* page1 (HPDF_ANNOT_NO_HIGHTLIGHT) */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("Jump to Page1 (HilightMode=HPDF_ANNOT_NO_HIGHTLIGHT)");
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.moveToNextLine();
            dst = page[0].createDestination();
            annot = indexPage.createLinkAnnot(rect, dst);
            annot.setHighlightMode(HPdfHighlightMode.NO_HIGHTLIGHT);
            
            /* page2 (HPDF_ANNOT_INVERT_BOX) */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("Jump to Page2 (HilightMode=HPDF_ANNOT_INVERT_BOX)");
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.moveToNextLine();
            dst = page[1].createDestination();
            annot = indexPage.createLinkAnnot(rect, dst);
            annot.setHighlightMode(HPdfHighlightMode.INVERT_BOX);
            
            /* page3 (HPDF_ANNOT_INVERT_BORDER) */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("Jump to Page3 (HilightMode=HPDF_ANNOT_INVERT_BORDER)");
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.moveToNextLine();
            dst = page[2].createDestination();
            annot = indexPage.createLinkAnnot(rect, dst);
            annot.setHighlightMode(HPdfHighlightMode.INVERT_BORDER);
            
            /* page4 (HPDF_ANNOT_DOWN_APPEARANCE) */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("Jump to Page4 (HilightMode=HPDF_ANNOT_DOWN_APPEARANCE)");
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.moveToNextLine();
            dst = page[3].createDestination();
            annot = indexPage.createLinkAnnot(rect, dst);
            annot.setHighlightMode(HPdfHighlightMode.DOWN_APPEARANCE);
            
            /* page5 (dash border) */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("Jump to Page5 (dash border)");
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.moveToNextLine();
            dst = page[4].createDestination();
            annot = indexPage.createLinkAnnot(rect, dst);
            annot.setBorderStyle(1, 3, 2);
            
            /* page6 (no border) */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("Jump to Page6 (no border)");
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.moveToNextLine();
            dst = page[5].createDestination();
            annot = indexPage.createLinkAnnot(rect, dst);
            annot.setBorderStyle(0, 0, 0);
            
            /* page7 (bold border) */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("Jump to Page7 (bold border)");
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.moveToNextLine();
            dst = page[6].createDestination();
            annot = indexPage.createLinkAnnot(rect, dst);
            annot.setBorderStyle(2, 0, 0);
            
            /* URI link */
            tp = indexPage.getCurrentTextPos();
            
            indexPage.showText("URI (");
            indexPage.showText(uri);
            indexPage.showText(")");
            
            rect.setLeft(tp.getX() - 4);
            rect.setBottom(tp.getY() - 4);
            rect.setRight(indexPage.getCurrentTextPos().getX() + 4);
            rect.setTop(tp.getY() + 10);
            
            indexPage.createURILinkAnnot(rect, uri);
            
            indexPage.endText();
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void printPage(HPdfPage page, HPdfFont font, int pageNum) {
        
        page.setWidth(200);
        page.setHeight(200);
        
        page.setFontAndSize(font, 20);
        
        page.beginText();
        page.moveTextPos(50, 150);
        page.showText(String.format("Page:%d", pageNum));
        page.endText();
    }
    
}
