/*
 * JHPdf Free PDF Library : ExtGStateDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/arc_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.graphics.*;


public class ExtGStateDemo implements DemoEntry {
    public static void main(String[] args) {
        new ExtGStateDemo().demo(args);
    }
    
    private static final String F_NAME = "ExtGStateDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        final float PAGE_WIDTH = 600;
        final float PAGE_HEIGHT = 900;
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            HPdfFont font = pdf.getFont("Helvetica-Bold", null);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            page.setFontAndSize(font, 10);
            
            page.setHeight(PAGE_HEIGHT);
            page.setWidth(PAGE_WIDTH);
            
            /* normal */
            page.gSave();
            drawCircles(page, "normal", 40.0F, PAGE_HEIGHT - 170);
            page.gRestore();
            
            /* transparency (0.8) */
            page.gSave();
            HPdfExtGState gstate = pdf.createExtGState();
            gstate.setAlphaFill(0.8F);
            gstate.setAlphaStroke(0.8F);
            page.setExtGState(gstate);
            drawCircles(page, "alpha fill = 0.8", 230.0F, PAGE_HEIGHT - 170);
            page.gRestore();
            
            /* transparency (0.4) */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setAlphaFill(0.4F);
            page.setExtGState(gstate);
            drawCircles(page, "alpha fill = 0.4", 420.0F, PAGE_HEIGHT - 170);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_MULTIPLY */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.MULTIPLY);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_MULTIPLY", 40.0F, PAGE_HEIGHT - 340);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_SCREEN */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.SCREEN);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_SCREEN", 230.0F, PAGE_HEIGHT - 340);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_OVERLAY */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.OVERLAY);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_OVERLAY", 420.0F, PAGE_HEIGHT - 340);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_DARKEN */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.DARKEN);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_DARKEN", 40.0F, PAGE_HEIGHT - 510);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_LIGHTEN */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.LIGHTEN);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_LIGHTEN", 230.0F, PAGE_HEIGHT - 510);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_COLOR_DODGE */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.COLOR_DODGE);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_COLOR_DODGE", 420.0F, PAGE_HEIGHT - 510);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_COLOR_BUM */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.COLOR_BUM);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_COLOR_BUM", 40.0F, PAGE_HEIGHT - 680);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_HARD_LIGHT */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.HARD_LIGHT);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_HARD_LIGHT", 230.0F, PAGE_HEIGHT - 680);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_SOFT_LIGHT */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.SOFT_LIGHT);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_SOFT_LIGHT", 420.0F, PAGE_HEIGHT - 680);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_DIFFERENCE */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.DIFFERENCE);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_DIFFERENCE", 40.0F, PAGE_HEIGHT - 850);
            page.gRestore();
            
            /* blend-mode=HPDF_BM_EXCLUSHON */
            page.gSave();
            gstate = pdf.createExtGState();
            gstate.setBlendMode(HPdfBlendMode.EXCLUSHON);
            page.setExtGState(gstate);
            drawCircles(page, "HPDF_BM_EXCLUSHON", 230.0F, PAGE_HEIGHT - 850);
            page.gRestore();
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void drawCircles(HPdfPage page, String description, float x, float y) {
        page.setLineWidth(1.0F);
        page.setRGBStroke(0.0F, 0.0F, 0.0F);
        page.setRGBFill(1.0F, 0.0F, 0.0F);
        page.circle(x + 40, y + 40, 40);
        page.closePathFillStroke();
        page.setRGBFill(0.0F, 1.0F, 0.0F);
        page.circle(x + 100, y + 40, 40);
        page.closePathFillStroke();
        page.setRGBFill(0.0F, 0.0F, 1.0F);
        page.circle(x + 70, y + 74.64F, 40);
        page.closePathFillStroke();
        
        page.setRGBFill(0.0F, 0.0F, 0.0F);
        page.beginText();
        page.textOut(x + 0.0F, y + 130.0F, description);
        page.endText();
    }
    
}
