/*
 * JHPdf Free PDF Library : ChfontDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/arc_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.io.*;

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfDocument.HPdfCompressionMode;


public class ChfontDemo implements DemoEntry {
    public static void main(String[] args) {
        new ChfontDemo().demo(args);
    }
    
    private static final String F_NAME = "ChfontDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        if (args.length < 4) {
            System.out.println("chfont_demo <cp936-ttc-font-file-name> " +
                "<cp936-index> <cp932-ttc-font-file-name> <cp932-index>");
            return;
        }
        
        BufferedReader r932 = null;
        BufferedReader r936 = null;
        
        HPdfDocument pdf = null;
        try {
            try {
                r932 = createReader("mbtext" + File.separator + "cp932.txt", "ms932"); // Java don't recognize 'cp932'.
            } catch (IOException e932) {
                System.out.println("error: cannot open cp932.txt");
                throw e932;
            }
            try {
                r936 = createReader("mbtext" + File.separator + "cp936.txt", "cp936");
            } catch (IOException e936) {
                System.out.println("error: cannot open cp936.txt");
                throw e936;
            }
            
            GridSheet grid = new GridSheet();
            
            pdf = JHPdf.createDocument();
            
            pdf.setCompressionMode(HPdfCompressionMode.ALL);
            pdf.useJPEncodings();
            pdf.useCNSEncodings();
            
            String fcp936Name = pdf.loadTTFontFromFile2(args[0], Integer.parseInt(args[1]), true);
            String fcp932Name = pdf.loadTTFontFromFile2(args[2], Integer.parseInt(args[3]), true);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            page.setHeight(300);
            page.setWidth(550);
            
            HPdfFont fcp936 = pdf.getFont(fcp936Name, "GBK-EUC-H");
            HPdfFont fcp932 = pdf.getFont(fcp932Name, "90ms-RKSJ-H");
            
            grid.printGrid(pdf, page);
            
            page.setTextLeading(20);
            
            page.beginText();
            page.moveTextPos(50, 250);
            page.setTextLeading(25);
            
            String buf;
            while ((buf = r936.readLine()) != null) {
                page.setFontAndSize(fcp936, 18);
                page.showText(buf);
                
                if ((buf = r932.readLine()) != null) {
                    page.setFontAndSize(fcp932, 18);
                    page.showText(buf);
                }
                page.moveToNextLine();
            }
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
            try {
                if (r932 != null) {
                    r932.close();
                    r932 = null;
                }
                if (r936 != null) {
                    r936.close();
                    r936 = null;
                }
            } catch (IOException ee) {
                // NOP
            }
        }
    }
    
    private BufferedReader createReader(String filePath, String charsetName) throws IOException {
        return new BufferedReader(
            new InputStreamReader(new FileInputStream(filePath), charsetName));
    }
}
