﻿#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <float.h>

#define N 10000	//試行回数

//どれか一つ選択
#define SITUATION1	//終日平均的
//#define SITUATION2	//間1時間ピーク時間
//#define SITUATION3	//終日ピーク・医師2人

//待ち行列用連結リスト
typedef struct _SortedList
{
	double val;
	struct _SortedList* next;
} SortedList;

//新要素領域確保
void newNext(double v, SortedList* list, SortedList* list_next);

//待ち行列に要素を追加
void insert(double v, SortedList** list);

//先頭要素を解放する操作
void popFront(SortedList** list);

//リストの長さを求める
unsigned int length(SortedList* list);

//逆関数法による指数分布乱数生成
double expDist(double lambda);

int main(int argc, char** argv)
{
	double avg_waitTime_sum = 0.;
	//int max_waiter_sum = 0;
	unsigned int max_waiters[N];	    
	unsigned int maxw = 0;
	double meanw = 0.0;
	double varw = 0.0;
	int i;

	//シミュレーション
	srand((unsigned int)time(NULL));
	puts("Simulation Start. ---------------------------------------");
	for(i=0; i<N; ++i){
		double arrival_time = 0.0;			//到着時刻
		double start_time[2] = {0.0, 0.0};	//処置開始時刻 (医師2人分)
		double finish_time[2];				//処置終了時刻 (医師2人分)

		double wait_sum = 0.0;
		unsigned int max_waiter = 0;
		SortedList* wait_queue = NULL;
		unsigned int len = 0;

		double patient_interval = 0.0;		//到着間隔
		double treatment_interval = 0.0;	//処置間隔
		double lambda = 1.0 / 7.5;			//到着間隔平均7.5分(指数分布パラメータ)

		int n = 0;							//患者数

		printf("simulation: %d\n", i);
		finish_time[0] = 0.0;
#ifdef SITUATION3
		lambda = 1.0 / 5.0;					//到着間隔平均5.0分(指数分布パラメータ)
		finish_time[1] = 0.0;				
#else
		finish_time[1] = DBL_MAX;			//無効化するためには最大値で初期化
#endif
	
		do{	//8時間の営業//////////////////////////////////////////////////////////////////////////////////////////////
			double wait = 0.;

			patient_interval = expDist(lambda);			//到着間隔
			treatment_interval = expDist(1.0 / 6.0);	//処置間隔(平均6分)

			arrival_time += patient_interval;			//到達時刻（= 現在時刻）
			while(wait_queue != NULL){
				//待ちの解消
				if (arrival_time > wait_queue->val){ popFront(&wait_queue); }
				else{ break; }
			}

			if(arrival_time < 480.0){
				int ID = (finish_time[0] < finish_time[1]) ? 0 : 1;	//処置終了の早い方に処置してもらう
				wait = (finish_time[ID] > arrival_time) ? finish_time[ID] - arrival_time : 0.;
				//wait_sec[i] = wait;
				wait_sum += wait;
				start_time[ID] = wait > 0. ? finish_time[ID] : arrival_time;

				finish_time[ID] = start_time[ID] + treatment_interval;

				//待ちの追加
				insert(finish_time[ID],&wait_queue);
				len = length(wait_queue);
				max_waiter = (max_waiter > len -1) ? max_waiter : len -1;

				++n;
			}
#ifdef SITUATION2
			lambda = (300.0 <= arrival_time && arrival_time < 360.0 )? 1.0/5.0 : 1.0/7.5; //ピーク時切り替え(平均5分（ピーク）or 平均7.5分)
#endif
		}while((arrival_time < 480.0) || wait_queue != NULL);//////////////////////////////////////////////////////////

		//printf("avg. p_interval:\t%f[m]\n", (double)(arrival_time) / n);
		printf("avg. wait time :\t%f[m]\n", wait_sum / n);
		printf("max waiter:\t\t%u[人]\n", max_waiter);

		avg_waitTime_sum += (wait_sum/n);
		//max_waiter_sum += max_waiter;
		max_waiters[i] = max_waiter;
	}

	puts("Simulation Finish. --------------------------------------");
	printf("avg. wait time :\t%f[m]\n", avg_waitTime_sum / N);
	for(i=0;i<N;++i){//平均待ち時間の計算
		maxw = (max_waiters[i] > maxw ? max_waiters[i] : maxw);
		meanw += max_waiters[i];
	}
	meanw /= N;
	for(i=0;i<N;++i){//待ち時間の分散の計算
		varw += (max_waiters[i] - meanw)*(max_waiters[i] - meanw);
	}
	varw /= N-1;
	printf("avg. waiter :\t\t%f[人]\n", meanw);
	printf("sdev. waiter :\t\t%f[人]\n", sqrt(varw));
	printf("max. waiter :\t\t%u[人]\n", maxw);
}

void newNext(double v, SortedList* list, SortedList* list_next)
/*-------------------------------------------------------------
新要素領域確保
listとnextの間に値vの要素を追加
--------------------------------------------------------------*/
{
	list->next = (SortedList*)malloc(sizeof(SortedList));
	list->next->val = v;
	list->next->next = list_next;
}

void insert(double v, SortedList** list)
/*-------------------------------------------------------------
待ち行列に値vの要素を挿入
--------------------------------------------------------------*/
{
	//例外条件：NULLポインタの初期化
	SortedList *tmp, *tmp_next;
	if((*list) == NULL){
		*list = (SortedList*)malloc(sizeof(SortedList));
		(*list)->val = v;
		(*list)->next = NULL;
		return;
	}
	tmp = (*list);
	if(tmp->val > v){
		(*list) = (SortedList*)malloc(sizeof(SortedList));
		(*list)->val = v;
		(*list)->next = tmp;
		return;
	}

	tmp_next = tmp->next;
	while(tmp_next != NULL){
		//挿入箇所を見つけたら新たに接続
		if((tmp_next->val) > v){
			newNext(v,tmp,tmp_next);
			return;
		}
		tmp = tmp_next;
		tmp_next = tmp_next->next;
	}
	//末尾に追加
	newNext(v,tmp,NULL);
}

void popFront(SortedList** list)
/*-------------------------------------------------------------
listの先頭要素を解放する操作
--------------------------------------------------------------*/
{
	SortedList* tmp = *list;
	*list = tmp->next;
	free(tmp);
}

unsigned int length(SortedList* list)
/*-------------------------------------------------------------
返り値：listの長さ
--------------------------------------------------------------*/
{
	unsigned int len = 0;
	SortedList* tmp = list;
	while(tmp != NULL){
		++len;
		tmp = tmp->next;
	}
	return len;
}

double expDist(double lambda)
/*-------------------------------------------------------------
逆関数法による指数分布乱数生成
lambda：指数分布のパラメータ
返り値：指数分布に従う乱数
--------------------------------------------------------------*/
{
	return -log(1. - (rand()/(double)(RAND_MAX+1))) / lambda;
}
