﻿//#include <random>
#include <iostream>
//#include <iomanip>
//#include <valarray>
//#include <deque>
#include <stdlib.h>
#include <time.h>

struct SortedList
{
	double val;
	SortedList* next;
};

void newNext(double v, SortedList* list, SortedList* list_next){
	list->next = (SortedList*)malloc(sizeof(SortedList));
	list->next->val = v;
	list->next->next = list_next;
}

void insert(double v, SortedList** list){
	//例外条件：NULLポインタの初期化
	SortedList *tmp, *tmp_next;
	if((*list) == NULL){
		*list = (SortedList*)malloc(sizeof(SortedList));
		(*list)->val = v;
		(*list)->next = NULL;
		return;
	}
	tmp = (*list);
	if(tmp->val > v){
		(*list) = (SortedList*)malloc(sizeof(SortedList));
		(*list)->val = v;
		(*list)->next = tmp;
		return;
	}

	tmp_next = tmp->next;
	while(tmp_next != NULL){
		//挿入箇所を見つけたら新たな接続
		if((tmp_next->val) > v){
			newNext(v,tmp,tmp_next);
			return;
		}
		tmp = tmp_next;
		tmp_next = tmp_next->next;
	}
	//末尾に追加
	newNext(v,tmp,NULL);
}

//先頭要素を解放する操作
void popFront(SortedList** list){
	SortedList* tmp = *list;
	*list = tmp->next;
	free(tmp);
}

//リストの長さを求める
unsigned int length(SortedList* list){
	unsigned int len = 0;
	SortedList* tmp = list;
	while(tmp != NULL){
		++len;
		tmp = tmp->next;
	}
	return len;
}

double expDist(double lambda){
	//逆関数法による指数分布乱数生成
	return -log(1. - (rand()/double(RAND_MAX+1))) / lambda;
}

int main(int, char**)
{
	using std::cout;
	using std::endl;

	//分布設定
	//std::random_device seed_gen;//予測不可能乱数（シード）
	//std::mt19937 eng(seed_gen());//メルセンヌ・ツイスタによる乱数生成器
	//std::exponential_distribution<> p_interval_dist(1. / 7.5);		//到着間隔平均7.5分
	//std::exponential_distribution<> p_interval_dist_peak(1. / 5.0);	//到着間隔平均5分（ピーク）
	//std::exponential_distribution<> t_interval_dist(1. / 6.0);		//処置間隔平均6分
	srand((unsigned int)time(NULL));

	//シミュレーション
	const int N = 2000;//試行回数
	double avg_waitTime_sum = 0.;
	int max_waiter_sum = 0;
	cout <<"Simulation Start. -----------------------------------------------------------------------"<<endl;
	for(int i=0; i<N; ++i){
		cout <<"simulation: "<<i<<endl;

		double arrival_time = 0.;		//到着時刻
		double start_time[2] = {0., 0.};//処置開始時刻
		double finish_time[2];			//処置終了時刻
		finish_time[0] = 0.;
		finish_time[1] = 0.;		//無効化するためには最大値で初期化
		//std::valarray<double> wait_sec(N);
		double wait_sum = 0.;
		unsigned int max_waiter = 0;
		//std::deque<double> wait_queue;//待ち行列
		SortedList* wait_queue = NULL;
		unsigned int len = 0;

		double patient_interval = 0.;//到着間隔
		double treatment_interval = 0.;//処置間隔
		double lambda = 1. / 7.5;//到着間隔平均7.5分(指数分布パラメータ)
	
		//cout << "ID\t" << "到着" << "\t" << "間隔" << "\t" << "待ち" << "\t" << "開始" << "\t" << "処置" << "\t" << "終了" << "\t" <<"待機［人]"<< endl << std::setprecision(4);//時間の桁数設定
		//for (int i = 0; i < N; ++i){
		int n = 0;//患者数
		do{	//8時間の営業//////////////////////////////////////////////////////////////////////////////////////////////
			patient_interval = expDist(lambda);//到着間隔
			treatment_interval = expDist(1. / 6.0);//処置間隔

			arrival_time += patient_interval;//到達時刻（= 現在時刻）
			while(wait_queue != NULL){
				//待ちの解消
				if (arrival_time > wait_queue->val){ popFront(&wait_queue); }
				else{ break; }
			}

			double wait = 0.;
			if(arrival_time < 480.){
				int ID = (finish_time[0] < finish_time[1]) ? 0 : 1;	//処置終了の早い方に処置してもらう
				wait = (finish_time[ID] > arrival_time) ? finish_time[ID] - arrival_time : 0.;
				//wait_sec[i] = wait;
				wait_sum += wait;
				start_time[ID] = wait > 0. ? finish_time[ID] : arrival_time;

				finish_time[ID] = start_time[ID] + treatment_interval;
				//

				//wait_queue.push_back(finish_time[ID]); //待ちの追加
				insert(finish_time[ID],&wait_queue);
				len = length(wait_queue);
				max_waiter = (max_waiter > len -1) ? max_waiter : len -1;

				++n;
			}

			lambda = (0 < arrival_time && arrival_time < 50000 )? 1./5.0 : 1./7.5; //ピーク時切り替え

			//cout << "[" << n << "]:\t" << arrival_time << "\t" << patient_interval << "\t" << wait << "\t" << start_time[0] << "\t" << treatment_interval << "\t" << finish_time[0] << "\t" <<len-1<< endl;
		}while((arrival_time < 480.) || wait_queue != NULL);//////////////////////////////////////////////////////////

		cout << "avg. p_interval:\t" << double(arrival_time) / n <<"[m]"<< endl;
		cout << "avg. wait time :\t" << /*wait_sec.sum()*/ wait_sum / n << "[m]" << endl;
		cout << "max waiter:\t\t" << max_waiter <<"[人]"<<endl;

		avg_waitTime_sum += (wait_sum/n);
		max_waiter_sum += max_waiter;
	}

	cout <<"Simulation Finish. -----------------------------------------------------------------------"<<endl;
	cout <<"avg. wait time :\t" << avg_waitTime_sum / N << "[m]" << endl;
	cout <<"avg. waiter :\t\t" << double(max_waiter_sum) / N << "[人]" << endl;
}