﻿#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define CASE1	//手動でプレイ
//#define CASE2	//最少手数を計算

//初期配置
int startBoard[9] ={
	1,4,3,
	7,2,6,
	8,5,0
};

//終了状態
int goalBoard[9] = {
	1,2,3,
	4,5,6,
	7,8,0
};

#define HASH_SIZE 262144

//4方向
typedef enum{ LEFT, RIGHT, UP, DOWN} Direction;

//ハッシュテーブル用構造体
typedef struct hash {
	int board[9];			//盤面
	int step;				//手数
	struct hash *next;		//次の番面
	struct hash *prev;		//前の盤面
} hash_t;

hash_t *hashTab[HASH_SIZE];

int pos(int x, int y){
	return 3*y + x;
}

//盤面をランダムに初期化
void shuffle(int board[9]);

//盤面の表示
void print(int board[9]);

//終了状態かどうか調べる
int check(int board[9]);

//指定した番号のコマを動かす
int movePiece(int board[9], int v);

//一手進めた盤面を作る
int moveBoard(Direction dir, int orgBoard[9], int newBoard[9]);

//手順をさかのぼって、初手から盤面を表示していく
void showAnswer(hash_t *hash);
void subShow(hash_t *hash);

//ハッシュテーブルの初期化
void initHash();

//ハッシュインデックスを計算する
int getHashIndex(int *board);

//board を step手目としてハッシュテーブルへ登録
hash_t *registBoard(int *board, int step, hash_t *prev);

//ハッシュテーブルからboardを探す
hash_t *findBoardFromTable(int *board);

//幅優先探索で解を探す
void search(int board[9]);

int main(int argc,char **argv)
{
#ifdef CASE1
	char buf[16];
	int puzzle[9];
	int val=0;
	unsigned int trynum=0;

	srand((unsigned int)time(NULL));
	shuffle(puzzle);						//パズルの初期の配置の作成

	printf("初期の配置：\n");

	do {
		print(puzzle);
		do{
			printf("> ");
			fgets(buf,15,stdin);
		}while(sscanf(buf,"%d",&val) != 1);	//動かすコマの番号を入力
		if(!movePiece(puzzle, val)){		//コマ入れ替え
			puts("移動不可．");
			continue;
		}
		++trynum;
	} while(!check(puzzle));				//終了条件の判定

	print(puzzle);
	puts("完了.");
	printf("手数：%d\n",trynum);			//手数
#else
	initHash();								//ハッシュテーブル初期化
	search(startBoard);						//解の探索
#endif
}

void shuffle(int board[9])
/*-------------------------------------------------------------
盤面をランダムに初期化
--------------------------------------------------------------*/
{
	int i;
	int tmp;

	// パズルの初期の配置の作成
	for (i=0;i<9;++i)
		board[i]=i;

	// パズルのシャッフル
	for (i=0;i<100;)
	{
		tmp = rand()%8 + 1;
		i += movePiece(board,tmp);
	}
}

void print(int board[9])
/*-------------------------------------------------------------
盤面の表示
--------------------------------------------------------------*/
{
	int i, j;
	for (j=0;j<3;++j){
		for (i=0;i<3;++i){
			if (board[pos(i,j)]==0){ printf("[ ]");}
			else{ printf("[%d]", board[pos(i,j)]);}
		}
		printf("\n");
	}
	printf("\n");
}

int check(int board[9])
/*-------------------------------------------------------------
終了状態かどうか調べる
返り値：終了状態なら1　さもなくば0
--------------------------------------------------------------*/
{
	int i;
	for (i=0;i<9;++i){
		if (board[i] != goalBoard[i]){ return 0;}
	}
	return 1;
}

int movePiece(int board[9], int v)
/*-------------------------------------------------------------
番号vのコマを動かす
返り値：移動可能なら1　さもなくば0
--------------------------------------------------------------*/
{
	int x, y, t, i;
	t = -1;
	for(i=0;i<9;++i){
		if(board[i] == v){ 
			t = i;
			break;
		}
	}
	if(t == -1 || v == 0){
		puts("1 - 8 の値を指定してください．");
		return 0;
	}

	x = t % 3;
	y = t / 3;

	if(x > 0){
		if(board[pos(x-1,y)] == 0){
			board[pos(x-1,y)] = v;
			board[t] = 0;
			return 1;
		}
	}
	if(x < 2){
		if(board[pos(x+1,y)] == 0){
			board[pos(x+1,y)] = v;
			board[t] = 0;
			return 1;
		}
	}
	if(y > 0){
		if(board[pos(x,y-1)] == 0){
			board[pos(x,y-1)] = v;
			board[t] = 0;
			return 1;
		}
	}
	if(y < 2){
		if(board[pos(x,y+1)] == 0){
			board[pos(x,y+1)] = v;
			board[t] = 0;
			return 1;
		}
	}
	return 0;
}

int moveBoard(Direction dir, int orgBoard[9], int newBoard[9])
/*-------------------------------------------------------------
一手進めた盤面を作る
dir：空きコマをどの方向に動かすか
orgorgBoard：元の盤面
neworgBoard：移動後の盤面
返り値：移動可能なら1　さもなくば0
--------------------------------------------------------------*/
{
	int i, found, zx, zy, t;
//puts("moveBoad start");
	found = 0;
	for(i=0; i<9; ++i){
		newBoard[i] = orgBoard[i];
		if( orgBoard[i]==0 ){
			found = 1;
			t = i; 
		}
	}
	if (found == 0){
		printf("error. 0 is NOT found");
		exit(1);
	}
	zx = t % 3;
	zy = t / 3;

	switch(dir){
	case LEFT:
		if(zx > 0){
			newBoard[pos(zx,zy)]=newBoard[pos(zx-1,zy)];
			newBoard[pos(zx-1,zy)] = 0;
//puts("moveBoad end");
			return 1;
		}
		break;

	case RIGHT:
		if(zx < 2){
			newBoard[pos(zx,zy)]=newBoard[pos(zx+1,zy)];
			newBoard[pos(zx+1,zy)] = 0;
//puts("moveBoad end");
			return 1;
		}
		break;

	case UP:
		if(zy > 0){
			newBoard[pos(zx,zy)]=newBoard[pos(zx,zy-1)];
			newBoard[pos(zx,zy-1)] = 0;
//puts("moveBoad end");
			return 1;
		}
		break;

	case DOWN:
	default:
		if(zy < 2){
			newBoard[pos(zx,zy)]=newBoard[pos(zx,zy+1)];
			newBoard[pos(zx,zy+1)] = 0;
//puts("moveBoad end");
			return 1;
		}
		break;
	}
//puts("moveBoad end");
	return 0;
}

void showAnswer(hash_t *hash)
/*-------------------------------------------------------------
//手順をさかのぼって、初手から盤面を表示していく
--------------------------------------------------------------*/
{
	subShow(hash);
	print(hash->board);
}

void subShow(hash_t *hash){
	hash_t *prev = hash->prev;
	if (prev == NULL)
		return;
	subShow(prev);
	print(prev->board);
}

void initHash()
/*-------------------------------------------------------------
ハッシュテーブルの初期化
--------------------------------------------------------------*/
{
	int i;
	for(i=0; i< HASH_SIZE; ++i){
		hashTab[i] = NULL;
	}
}

int getHashIndex(int *board)
/*-------------------------------------------------------------
boardのハッシュインデックスを計算する
返り値：ハッシュインデックス
--------------------------------------------------------------*/
{
	int i, val;
	int offset[]={40320,5040,720,120,24,6,2,1};	  //8! 7! 6! 5! 4! 3! 2! 1!
	val = 0;
	for (i=0; i<9; ++i){
		val += (board[i] * offset[i]);
	}
	val &=(HASH_SIZE -1);
	return val;
}

hash_t *registBoard(int *board, int step, hash_t *prev)
/*-------------------------------------------------------------
//board を step手目としてハッシュテーブルへ登録
prev:一つ前の盤面
返り値：新たに登録されたハッシュ
--------------------------------------------------------------*/
{
	int i, key;
	hash_t *ptr;
//puts("registBoad start");
	ptr = (hash_t*)malloc(sizeof(hash_t));
	if (ptr == NULL){ exit(1);}
	for (i=0; i<9; ++i){
		ptr->board[i] = board[i];
	}

	ptr->next = NULL;
	ptr->prev = prev;
	ptr->step = step;

	key = getHashIndex(board);
	ptr->next = hashTab[key];
	hashTab[key] = ptr;
//puts("registBoad end");
	return ptr;
}

hash_t *findBoardFromTable(int *board)
/*-------------------------------------------------------------
ハッシュテーブルからboardを探す
返り値：発見したハッシュ　見つからなければNULL
--------------------------------------------------------------*/
{
	int key, i;
	hash_t *ptr;
//puts("findBoad start");
	key = getHashIndex(board);
	for (ptr = hashTab[key]; ptr != NULL ; ptr = ptr->next){
		for(i=0; i <9 ; ++i){
			if(board[i] != ptr->board[i]){ break;}
		}
		if (i == 9){
//puts("findBoad end"); 
			return ptr;
		}
	}
//puts("findBoad end");
	return NULL;
}

void search(int board[9])
/*-------------------------------------------------------------
幅優先探索で解を探す
--------------------------------------------------------------*/
{
	int i, j, step;
	int newBoard[9];
	hash_t *ptr, *newHash;

	registBoard(board, 0, NULL);	//開始盤面を0手目として登録

	//1手目から探索
	for(step = 1; step < 100; ++step){
		printf("step:%d\r",step);
		for(i = 0; i < HASH_SIZE; ++i){
			for(ptr = hashTab[i]; ptr != NULL; ptr = ptr->next){
				if(ptr->step != step -1){ continue;}
				for(j=0; j < 4; ++j){
					//空白コマを動かしてみる
					if(moveBoard((Direction)j, ptr->board, newBoard)){	//移動成功
						if(findBoardFromTable(newBoard)== NULL){		//新しい盤面
							newHash = registBoard(newBoard, step, ptr);
							//print(newBoard);
							if(check(newBoard)){
								printf("解：%d手\n", step);
								showAnswer(newHash);
								return;
							}
						}
					}
				}
			}
		}
	}
}