﻿#include<stdio.h>
#include<stdlib.h>
#include<time.h>

#define N 10000 //シミュレーション回数

#define P1 //課題1
//#define P2 //課題2

//BOOL型定義
typedef enum{FALSE,TRUE} BOOL;

//硬貨枚数の組み
typedef struct{
	int c100;
	int c50;
	int c10;
} CoinSet;

//投入硬貨の組み合わせ
const CoinSet in500 = {0,0,0};
const CoinSet in200 = {2,0,0};
const CoinSet in150 = {1,1,0};
const CoinSet in120 = {1,0,2};
const CoinSet in110 = {1,0,1};

//購入されるジュースの比率
const double selectDist[] = {0.4, 0.3, 0.3};	

//投入される硬貨の確率
const double payDist[][5] = {
	{0.1, 0.3, 0.2, 0.0, 0.4},	// (110円のジュース)
	{0.1, 0.3, 0.3, 0.3, 0.0},	// (120円のジュース)
	{0.2, 0.3, 0.5, 0.0, 0.0}	// (150円のジュース)
};

// 返却されるお釣り金額
const int change[][5] = {
	{390, 90, 40, 10, 0},		// (110円のジュース)　
	{380, 80, 30,  0, 0},		// (120円のジュース)
    {350, 50,  0,  0, 0}		// (150円のジュース)
};

//自販機の状態
typedef struct{
	CoinSet store;		//残り硬貨枚数
	int count[3];		//残り商品本数
} Vender;

//硬貨の組同士の和 (v1 + v2)
CoinSet CSadd(CoinSet v1, CoinSet v2);

//商品type(0～2)に対してどのように支払うか
int pay(CoinSet *store,int type);

//お釣り金額cについて、硬貨の選び方を決める
BOOL returnCoin(CoinSet *store, int c);

//ひとりの客についての試行
BOOL simulate(Vender *ven);

int main(int argc,char **argv)
{
	int sumOfCustomer = 0;
	CoinSet sumOfCoins = {0, 0, 0};
	CoinSet minOfCoins = {INT_MAX,INT_MAX,INT_MAX};
	int i;
#ifdef P1
	Vender initVender = {{30,30,30},{INT_MAX,INT_MAX,INT_MAX}};	//硬貨枚数30枚ずつ　商品無限
#else//P2
	Vender initVender = {{1000,1000,1000}, {40, 30, 30}};		//硬貨枚数多め　商品40,30,30
#endif

	puts("入力：");
	printf("初期硬貨 = 100円:%d枚、50円:%d枚、10円:%d枚\n", initVender.store.c100, initVender.store.c50, initVender.store.c10);
	printf("初期商品数 = A(110):%d本、B(120):%d本、C(150):%d本\n", initVender.count[0], initVender.count[1], initVender.count[2]);

	srand((unsigned)time(NULL));
	for(i=0;i<N;++i){
		Vender vender;
		int customer;

		//状態初期化
		vender.store = initVender.store;
		vender.count[0] = initVender.count[0];
		vender.count[1] = initVender.count[1];
		vender.count[2] = initVender.count[2];

		//simulator
		for(customer=0; simulate(&vender) == TRUE; ++customer){
			//最少残り硬貨を更新
			minOfCoins.c100 = (vender.store.c100 < minOfCoins.c100 ? vender.store.c100 : minOfCoins.c100);
			minOfCoins.c50 = (vender.store.c50 < minOfCoins.c50 ? vender.store.c50 : minOfCoins.c50);
			minOfCoins.c10 = (vender.store.c10 < minOfCoins.c10 ? vender.store.c10 : minOfCoins.c10);
		}

		sumOfCustomer += customer;
//printf("%05d : result{(%d,%d,%d),(%d,%d,%d)}\n",i,vender.store.c100,vender.store.c50,vender.store.c10,vender.count[0],vender.count[1],vender.count[2]);
		sumOfCoins = CSadd(sumOfCoins, vender.store);
	}

	puts("\n出力：");
	printf("シミュレート回数：%d\n",N);
	printf("平均サービス人数：%1.2f[人]\n",(double)sumOfCustomer/N);		//平均サービス人数
	printf("平均残り硬貨 = 100円:%1.2f枚、50円:%1.2f枚、10円:%1.2f枚\n", sumOfCoins.c100/(double)N, sumOfCoins.c50/(double)N, sumOfCoins.c10/(double)N);
	printf("最少残り硬貨 = 100円:%d枚、50円:%d枚、10円:%d枚\n",minOfCoins.c100, minOfCoins.c50, minOfCoins.c10);

	return 0;
}

CoinSet CSadd(CoinSet v1, CoinSet v2)
/*-------------------------------------------------------------
商品type(0～2)に対してどのように支払うか
返り値：お釣り金額
--------------------------------------------------------------*/
{
	int t1,t2,t3;
	CoinSet tmp;
	
	t1 = v1.c100 + v2.c100;
	t2 = v1.c50 + v2.c50;
	t3 = v1.c10 + v2.c10;
	tmp.c100 = t1;
	tmp.c50 = t2;
	tmp.c10 = t3;
	
	return tmp;
}

int pay(CoinSet *store,int type)
/*-------------------------------------------------------------
商品type(0～2)に対してどのように支払うか
返り値：お釣り金額
--------------------------------------------------------------*/
{
	double p = (double)rand()/RAND_MAX;

	//払う金額
	if(p < payDist[type][0]){
		*store = CSadd(*store, in500);
		return change[type][0];
	}
	else if(p < payDist[type][1] + payDist[type][0]){
		*store = CSadd(*store, in200);
		return change[type][1];
	}
	else if(p < payDist[type][2] + payDist[type][1] + payDist[type][0]){
		*store = CSadd(*store, in150);
		return change[type][2];
	}
	else if(p < payDist[type][3] + payDist[type][2] + payDist[type][1] + payDist[type][0]){
		*store = CSadd(*store, in120);
		return change[type][3];
	}
	else{
		*store = CSadd(*store, in110);
		return change[type][4];
	}	
}

BOOL returnCoin(CoinSet *store, int c)
/*-------------------------------------------------------------
お釣り金額cについて、硬貨の選び方を決める
・支払い可能ならTRUEを返す．storeも更新される
・不可能ならFALSEを返す．storeは更新されない
--------------------------------------------------------------*/
{
	int tmp_c = c;
	CoinSet tmp_store = *store;

	while(tmp_c > 0){
		if(tmp_c >= 100 && tmp_store.c100 > 0){tmp_c -= 100; --(tmp_store.c100);}
		else if(tmp_c >= 50 && tmp_store.c50 > 0){tmp_c -= 50; --(tmp_store.c50);}
		else if(tmp_c >= 10 && tmp_store.c10 > 0){tmp_c -= 10; --(tmp_store.c10);}
		else{ return FALSE;}
	}
	*store = tmp_store;
	return TRUE;
}

BOOL simulate(Vender *ven)
/*-------------------------------------------------------------
ひとりの客についての試行
返り値：サービス可能ならTRUE
--------------------------------------------------------------*/
{ 
	int c;
	double p = (double)rand()/RAND_MAX;

	if(!((ven->count[0]) * (ven->count[1]) * (ven->count[2]))){ return FALSE;}	//どれかひとつ売り切れでサービス不可

	//どれを購入するか
	if( p < selectDist[0]){ 
		c = pay(&(ven->store),0);	//110
		--(ven->count[0]);
	}
	else if( p < selectDist[1]+selectDist[0]){
		c = pay(&(ven->store),1);	//120
		--(ven->count[1]);
	}
	else{
		c = pay(&(ven->store),2);	//150
		--(ven->count[2]);
	}
	return returnCoin(&(ven->store), c);	//支払い可能かどうか
	
}