﻿#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

typedef struct
{
	char name[64];	//名前
	int score[4];	//点数（英 国 数 合計）
} Dframe;

//集計結果用構造体
typedef struct
{
	int min[4];		//最小値（英 国 数 合計）
	int max[4];		//最大値（英 国 数 合計）
	int sum[4];		//合計値（英 国 数 合計）
	float mean[4];	//平均値（英 国 数 合計）
	float err[4];	//標準偏差（英 国 数 合計）
	int order[50];	//ソート表示用ID列
} Result;

enum subject{ENG, JAP, MAT};//（英 国 数）

int str2score(char *sc);//入力数値の変換（エラーチェック付き）
int inputData(int sc[3], Dframe student[], int s_num, Result *data);//
void calErr(Dframe student[], int s_num, Result *data);//各科目ごとの標準偏差を求める
void cSort(Dframe student[], int s_num, Result *data, int s);//指定した科目の成績順にソートした index list を作成
void outData(FILE *fp, Dframe student[], int s_num, Result *data, int op, char *key);//成績表示
void viewHelp();//ヘルプ表示
void viewHelpInput();
void viewHelpOutput();

int main()
{
	char buf[256];
	char *com, *op,  *tmp, *var[10];
	int sc;
	int t_sc[3];
	char t_name[64];
	int i;
	FILE *fp;
	int i_flag, f_flag, o_flag;
	
	Dframe student[50];
	int s_num =0;
	Result data = {
		{100,100,100,300},
		{0,0,0,0},
		{0,0,0,0}
	};
		
	while(1){
		com = op = tmp = NULL;
		printf(">> ");
		fgets(buf,256,stdin);
		if(buf[0] == 'q')break;
		tmp = strtok(buf, " \n");
		if(tmp != NULL){
			com = tmp;
			for(i=0;i<10;++i){
				var[i]  = strtok(NULL, " \n");
				if(var[i]  == NULL){ break;}
			}
		}
		switch(*com){
		case 'i':														//成績入力コマンド
			i_flag = 1;
			if(var[0] == NULL){		// >> i
				printf("%d人目の名前を入力してください\n", s_num+1);
				while(1){
					printf("：");
					fgets(buf, 64, stdin);
					if(buf[0] == '\n')puts("名前を入力してください");
					else{
						strcpy(student[s_num].name, buf);
						student[s_num].name[strlen(student[s_num].name) - 1] = '\0';
						break;
					}
				}
				for(i=0;i<3;++i){
					while(1){
						switch(i){
						  case 0:
							printf("英語：");
							break;
						  case 1:
							printf("国語：");
							break;
						  case 2:
							printf("数学：");
						}
						fgets(buf, 5, stdin);
						sc = str2score(buf);
						if(sc < 0){
							puts("0 - 100の整数を入力してください");
							continue;
						}else{
							t_sc[i] = sc;
							break;
						}
					}
				}
				s_num = inputData(t_sc, student, s_num, &data);
			}
			else if (strcmp(var[0], "-f") == 0){	//-fオプション
				if(var[1] == NULL){ puts("command error"); break;}
				if(*var[1] == '-'){ puts("command error"); break;}
				fp = fopen(var[1], "r+");
				if (fp == NULL){ puts("file open error");break;}
				while (1){
					t_sc[ENG] = t_sc[JAP] = t_sc[MAT] = -1;
					buf[0] = '\0';
					i_flag = 1;

					fgets(buf, 256, fp);	//一行取得
					if(sscanf(buf, "%s %d %d %d", t_name, &t_sc[ENG], &t_sc[JAP], &t_sc[MAT]) != 4){	//不正な行
						if(!feof(fp)){ continue;}	//ファイル途中なら読み飛ばし
						else { break;}				//末尾なら読み込み終了
					}
					for(i=0;i<3;++i){				//数値範囲チェック
						if (0 > t_sc[i] || t_sc[i] > 100){
							puts("0 - 100の整数を入力してください");
							i_flag = 0;
							break;
						}
					}
					if(!i_flag){ break;}
					strcpy(student[s_num].name, t_name);
					s_num = inputData(t_sc, student, s_num, &data);

					if(feof(fp)){ break;}			//末尾なら読み込み終了
				}
			}
			else{	// >> i (name) (score) (score) (score)
				for(i=1; var[i] != NULL; ++i){
					t_sc[i-1] = str2score(var[i]);
					if(t_sc[i-1] < 0){ i-=100; break;}
				}
				if(i != 4){
					puts("command error");
					break;
				}
				else{
					strcpy(student[s_num].name, var[0]);
					s_num = inputData(t_sc, student, s_num, &data);
				}
			}
			break;
			
		  case 'o':	//集計結果出力コマンド
			if(s_num == 0){
				puts("成績が登録されていません");
				break;
			}
			fp = stdout;
			f_flag = 0;
			o_flag = 0;
			for(i=0; var[i] != NULL; ++i){
				if(strcmp(var[i],"-f") == 0){
					if(f_flag){ puts("command error");goto OUT;}
					if(var[i+1] == NULL){ puts("command error"); goto OUT;}
					if(*var[i+1] == '-'){ puts("command error"); goto OUT;}
					fp = fopen(var[i+1], "w+");
					if(fp == NULL){ puts("file open error"); goto OUT;}
					f_flag = 1;
					++i;
				}
				else {
					if(o_flag){ puts("command error"); goto OUT;}
					if(strcmp(var[i],"-u") == 0){
						o_flag |= 1;
					}
					else if(strcmp(var[i],"-n") == 0){
						if(var[i+1] == NULL){ puts("command error"); goto OUT;}
						if(*var[i+1] == '-'){ puts("command error"); goto OUT;}
						tmp = var[i+1];
						o_flag |= 2;
						++i;
					}
					else if(strcmp(var[i],"-e") == 0){
						o_flag |= 4;
					}
					else if(strcmp(var[i],"-l") == 0){
						o_flag |= 8;
					}
					else if(strcmp(var[i],"-m") == 0){
						o_flag |= 16;
					}
					else{ puts("command error"); goto OUT;}
				}	
			}
			
			outData(fp, student, s_num, &data, o_flag, tmp);
			
		  OUT:
			if(f_flag){ fclose(fp);}
			break;
			
		  case 'h':			//ヘルプ表示コマンド
			viewHelp();
			break;
			
		  default:
			puts("unknown command.");
			viewHelp();
			break;
		}
	}

	return 0;
}

int str2score(char *sc)
/*-------------------------------------------------------------
入力数値の変換（エラーチェック付き）
sc：数値を表す文字列
返り値：変換された数値
		エラーなら-1
--------------------------------------------------------------*/
{
	int i;
	int num;
	for(i=0;i<3;++i){ if((sc[i] < '0' || '9' < sc[i]) && sc[i] != '\n' &&sc[i] != '\0')return -1;}
	num = atoi(sc);
	if(0 <= num && num <= 100)return num;
	else return -1;
}

int inputData(int sc[3], Dframe student[], int s_num, Result *data)
/*-------------------------------------------------------------
英・国・数の得点をまとめて登録する
返り値：1加算した登録人数
--------------------------------------------------------------*/
{
	int gen = 0;
	int i;
	for(i=0; i<3; ++i){	//各科目
		gen += sc[i];
		//最大・最小の更新
		if (data->min[i] > sc[i])data->min[i] = sc[i];
		if (data->max[i] < sc[i])data->max[i] = sc[i];
		//合計値の更新
		data->sum[i] += sc[i];
		//得点の入力
		student[s_num].score[i] = sc[i];
	}
	
	if (data->min[3] > gen)data->min[3] = gen;
	if (data->max[3] < gen)data->max[3] = gen;
	data->sum[3] += gen;
	student[s_num].score[3] = gen;	//合計点の入力

	printf("%d人目の成績を登録しました。\n", s_num+1);
	return s_num + 1;
}
void calErr(Dframe student[], int s_num, Result *data)
/*-------------------------------------------------------------
各科目ごとの標準偏差を求める
data->mean[]は計算済みである前提
data->err[]：標準偏差（x3科目）を格納
--------------------------------------------------------------*/
{
	int i, j;
	float ssq;
	for(j=0; j<4; ++j){
		ssq = 0.;
		for(i=0; i<s_num; ++i){
			ssq += (student[i].score[j] - data->mean[j]) * (student[i].score[j] - data->mean[j]);
		}
		data->err[j] = sqrt(ssq / s_num - 1);
	}
	return;
}

void cSort(Dframe student[], int s_num, Result *data, int s)
/*-------------------------------------------------------------
指定した科目の成績順にソートした id列 を作成
s：科目
data：data->order[]にid列を格納する
--------------------------------------------------------------*/
{
	int i;
	int cnt[101] = {0};
	int sco;
	for(i=0; i<s_num; ++i){
		++cnt[student[i].score[s]];
	}
	for(i=99; i>=0; --i)cnt[i] += cnt[i+1];
		
	for(i=0; i<s_num; ++i){
		sco = student[i].score[s];
		data->order[cnt[sco] - 1] = i;
		--cnt[sco];
	}	
}

void outData(FILE *fp, Dframe student[], int s_num, Result *data, int op, char *key)
/*-------------------------------------------------------------
成績表示
op：表示オプション
key：検索する名前（-n で使用）
--------------------------------------------------------------*/
{
	int i;
	int cnt = 0;
	switch (op){
	case 0:
		data->mean[ENG] = data->sum[ENG] / (float)s_num;
		data->mean[JAP] = data->sum[JAP] / (float)s_num;
		data->mean[MAT] = data->sum[MAT] / (float)s_num;
		data->mean[3] = data->sum[3] / (float)s_num;
		calErr(student, s_num, data);
		fprintf(fp,"集計結果\t登録者数：%d人\n",s_num);
		fprintf(fp, "\t\t英語\t国語\t数学\t合計\n平均点\t\t%.1f\t%.1f\t%.1f\t%.1f\n最高点\t\t%d\t%d\t%d\t%d\n最低点\t\t%d\t%d\t%d\t%d\n標準偏差\t%.2f\t%.2f\t%.2f\t%.2f\n",
			data->mean[ENG], data->mean[JAP], data->mean[MAT], data->mean[3],
			data->max[ENG], data->max[JAP], data->max[MAT], data->max[3],
			data->min[ENG], data->min[JAP], data->min[MAT], data->min[3],
			data->err[ENG], data->err[JAP], data->err[MAT], data->err[3]);
		break;

	case 1:		//-uオプション
		fprintf(fp, "登録者一覧\n");
		for (i = 0; i < s_num; ++i){
			fprintf(fp, "%s\n", student[i].name);
		}
		break;

	case 2:		//-nオプション
		for (i = 0; i < s_num; ++i){
			if (strcmp(student[i].name, key) == 0){
				if(cnt == 0){fprintf(fp, "名前\t\t英\t国\t数\n");}
				fprintf(fp, "%s\t\t%d\t%d\t%d\n", student[i].name, student[i].score[ENG], student[i].score[JAP], student[i].score[MAT]);
				++cnt;
			}
		}
		if (!cnt){ puts("みつかりませんでした．"); }
		break;

	case 4:		//-eオプション
		cSort(student, s_num, data, ENG);
		fprintf(fp, "名前\t英\n");
		for (i = 0; i < s_num; ++i){
			fprintf(fp, "%s\t%d\n", student[data->order[i]].name, student[data->order[i]].score[ENG]);
		}
		break;
	case 8:		//-lオプション
		cSort(student, s_num, data, JAP);
		fprintf(fp, "名前\t国\n");
		for (i = 0; i < s_num; ++i){
			fprintf(fp, "%s\t%d\n", student[data->order[i]].name, student[data->order[i]].score[JAP]);
		}
		break;
	case 16:	//-mオプション
		cSort(student, s_num, data, MAT);
		fprintf(fp, "名前\t数\n");
		for (i = 0; i < s_num; ++i){
			fprintf(fp, "%s\t%d\n", student[data->order[i]].name, student[data->order[i]].score[MAT]);
		}
		break;
	}
		
}

/*
コマンド
i　：成績入力
	-f <filename>				ファイルから読み込み
i <name> <eng> <lang> <math>	一行入力
	
o　：集計結果表示	
	-f <filename>				ファイル出力
	-u　　　　　				登録者一覧
	-n <name>					指定した人の成績表示
	-e　　　　　				英語の成績（高い順）
	-l　　　　　				国語の成績（高い順）
	-m　　　　　				算数の成績（高い順）

q　：プログラム終了

h　：コマンドヘルプ表示

*/
void viewHelp(){
/*-------------------------------------------------------------
ヘルプ表示
--------------------------------------------------------------*/
	puts("　コマンド一覧");
	viewHelpInput();

	viewHelpOutput();

	puts("q\nプログラム終了\n");

	puts("h\nこのヘルプを表示\n");
}

void viewHelpInput()
{
	puts("i");
	puts("成績入力．名前，英語点，国語点，数学点 の順に入力する．\n");

	puts("i [name] [eng] [lang] [math]");
	puts("一行入力．\n");

	puts("i -f [filename]");
	puts("ファイルから読み込み．ファイルフォーマットはテキスト形式で，各行に[name] [eng] [lang] [math]を記述．\n");
}
void viewHelpOutput()
{
	puts("o [-f [filename]] [-u | -n [name] | -e | -l | -m]");
	puts("集計結果表示．\n");

	puts("-f [filename]");
	puts("ファイル出力．出力先を標準出力からfilenameで指定したファイルへ変更する．\n");

	puts("以下のオプションを指定しない場合，英語・国語・数学・合計点それぞれの集計結果を表示する．");
	puts("いずれかを指定した場合，集計結果の代わりにオプションごとの内容を表示する．");
	puts("-u\t\t登録者一覧");
	puts("-n [name]\t指定した人の成績表示（同名がいる場合，その全て）");
	puts("-e\t\t英語の成績（高い順）");
	puts("-l\t\t国語の成績（高い順）");
	puts("-m\t\t算数の成績（高い順）\n");
}

