future.table.ss <-
function(res,bsres,SSBperR=46.9,nonadjust.SSB20=11.5,
                            bloss=16225,target.year="2026.75"){

  tmpfunc <- function(res){
#    browser()
    years <- as.numeric(colnames(res$SSB))
    ssb.tmp <- res$SSB[,colnames(res$SSB)==target.year]
    catch.tmp <- rowtapply(t(res$Totcatch))
    catch.tmp <- catch.tmp[tmp <- rownames(catch.tmp)==target.year,]
    
    part.catch <- matrix(0,10,length(catch.tmp))
    for(i in 1:10){
      pcatch.tmp <- rowtapply(t(res$Partialcatch[,,i]))
      part.catch[i,]  <- pcatch.tmp[tmp,]
    }
    a <- apply(part.catch,1,mean)

    # Pers lower than B_loss
    per.bloss10 <- sum(apply(res$SSB[,years>=(min(years)+2)&years<=(min(years)+12)]<bloss,1,sum)>0)/nrow(res$SSB)*100
    per.bloss20 <- sum(apply(res$SSB[,years>=(min(years)+2)&years<=(min(years)+22)]<bloss,1,sum)>0)/nrow(res$SSB)*100    
    per.bloss30 <- sum(apply(res$SSB[,years>=(min(years)+2)&years<=(min(years)+32)]<bloss,1,sum)>0)/nrow(res$SSB)*100

    # Pers upper than target SPR level
    mean.rec <- mean(res$Recruit[res$Recruit>0])
    adjusted.SPR20 <- mean.rec*SSBperR*0.2/1000
    res <- data.frame(median.ssb=median(ssb.tmp), # SSB median
                    mean.ssb=mean(ssb.tmp), # SSB mean
                    mean.rec=mean.rec,
                    adjusted.SPR20=adjusted.SPR20,
                    pers.upper20.adjusted=sum(ssb.tmp>adjusted.SPR20)/length(ssb.tmp)*100,
                    pers.upper20.nonadjusted=sum(ssb.tmp>nonadjust.SSB20*10000)/length(ssb.tmp)*100,
                    pers.lower10SSB=cal.percent.lowerboot(list(res),bsres=bootres)[[1]][1,1],
                      per.bloss10=per.bloss10,per.bloss20=per.bloss20,per.bloss30=per.bloss30,
                    median.totcatch=median(catch.tmp),                    
                    mean.totcatch=mean(catch.tmp),
                    catch1=a[1],catch2=a[2],catch3=a[3],catch4=a[4],catch5=a[5],
                    catch6=a[6],catch7=a[7],catch8=a[8],catch9=a[9],catch10=a[10])
    return(res)
  }

  for(i in 1:length(res)){
    if(!is.null(res[[i]]$SSB)){    
      a <- tmpfunc(res[[i]])
    }
    else{
      a <- rep(NA,ncol(x))
    }

    if(i==1){
      x <- a
    }
    else{
        x <- rbind(x,a)
      }
  }

  rownames(x) <- names(res)
  return(x)
}

