ci.plot <-
function(mat,ci=c(0.1,0.5,0.9),tuika=FALSE,mptype="l",errorb=FALSE,...){
  x.year <- as.numeric(colnames(mat))

  if(tuika==FALSE){
    grayplot(c(x.year,x.year[1]),c(apply(mat,2,quantile,probs=ci[length(ci)],na.rm=T),0),type="n",...)
  }

  if(errorb==FALSE){
    matpoints(t(matrix(x.year,length(ci),length(x.year),byrow=TRUE)),
            t(apply(mat,2,quantile,probs=ci,na.rm=T)),type=mptype,...)
  }
  else{
    points(x.year,
            tmp0 <- t(apply(mat,2,median)),type="p")
    for(i in c(1:ncol(mat))){
      tmp1 <- apply(mat,2,quantile,probs=0.1,na.rm=FALSE)
      tmp2 <- apply(mat,2,quantile,probs=0.9,na.rm=FALSE)
      arrows(x.year[i],tmp0[i],x.year[i],tmp2[i],angle=90,length=0.1)
      arrows(x.year[i],tmp0[i],x.year[i],tmp1[i],angle=90,length=0.1)      
    }
     } 
}

