bluefin.predictN <-
function(configN)
{
  #---------------- $B0z?t$NBeF~(B ----------------------------------
#  cat("1 ")
  outdata <- configN$outdata
  N <- configN$N
  pred.year <- ifelse(is.null(configN$pred.year),20,configN$pred.year)
  initial.year <- ifelse(is.null(configN$initial.year),2010,configN$initial.year)
  qt <- ifelse(is.null(configN$qt),4,configN$qt) # $B8=:_!"(Bqt=4$B0J30$N@_Dj$GF0$/$+ITL@(B

  #MP$B$N@_Dj$H!"$=$N$H$-$N>\:Y@_Dj(B
  MP <- configN$MP
  args.mp <- configN$args.mp #list(CHS0=10000,CHS.plus=0,select.year=c(1998,2000))

  #$B2CF~$N@_Dj$H!"$=$N$H$-$N>\:Y@_Dj(B
  Rec.fun <- configN$Rec.fun
  args.R <- configN$args.R #list(number.year=c(1980,2000),R.var=0.36)

  #------------- $B=EMW$@$,!"%G%U%)%k%H@_Dj$+$iJQ$($kI,MW$J$$$b$N(B
  ex.ssb <- ifelse(is.null(configN$ex.ssb),150,configN$ex.ssb)

  #------------- $B>-MhM=B,$N%*%W%7%g%s(B
  # $B>-Mh$N(Bpartial catch$B$r7W;;$9$k!#(B(current F$B$K$*$1$k(Bpartial catch)
  # $B$3$N>l9g!"0z?t$K$O(B make.partcatcharg(faa.res=faa.tmp)$B$NJV$jCM$rF~$l$k(B
  partial.catch <- configN$partial.catch
  # Hockey-stick$B$N2CF~(B(1.5$B$GF3F~(B)$B$9$k>l9g!"$3$3$KogCM$H$J$k?F5{;q8;NL$rF~$l$k!#%^%$%J%9$N>l9g!";H$o$J$$(B
  HSlimit <- ifelse(is.null(configN$HSlimit),-1,configN$HSlimit)
  HSlimit0<- ifelse(is.null(configN$HSlimit0),0,configN$HSlimit0)  ## HSlimit$B$,M-8z$GL5$$$H;H$o$l$J$$(B 2013/06/03 Yukio Takeuchi
  # F$B$K8m:9$rF~$l$k>l9g(B(IUCN$BMQ(B)$B!"$3$3$K(B F*exp(rnorm(F.sigma))$B$H$J$k(Bsigma$B$rF~$l$k!#(B
  # $B$3$N%*%W%7%g%s$r;H$o$J$$>l9g$O!"%<%m!#(B
  F.sigma <- ifelse(is.null(configN$F.sigma),0,configN$F.sigma)
  record.NAA <- configN$record.NAA
  #---------------------------------------------------------------------

  # $B%G!<%?$N%*%V%8%'%/%H2=(B
  naat <- outdata$"Numbers at age table"  # VPA$B$+$i?dDj$5$l$?G/NpJL;q8;Hx?t(B
  faat <- outdata$"F at age table"  # $B?dDj$5$l$?5y3M;`K478?t(B
  nmaa <- as.numeric(outdata$"Natural mortality at age")/qt  # $BG/NpJL<+A3;`K4N((B
  waa <- as.numeric(outdata$"Weight at age (kg)")  # $BG/NpJLBN=E(B
  maa <- as.numeric(outdata$"Maturity at age")  # $BG/NpJL@.=ON((B
  tc <- outdata$"Total catch" # $B3FG/$NAm5y3M(B

  n.age <- ncol(naat)
  age.name <- colnames(naat)
  age0 <- which(age.name=="0")
  measured.year <- as.numeric(outdata$"Age and year"[2,])

#------------ $B?dDj%Q%i%a!<%?$N=i4|2=(B --------------------------
  year.name <- as.numeric(rownames(naat))
#  pyear.name <- seq(from=initial.year,to=initial.year+pred.year-1,by=1/qt)
  pyear.name <- seq(from=initial.year,to=initial.year+pred.year,by=1/qt)   # $B#1G/J,B?$/?dDj$9$k(B
  NY <- length(pyear.name) # $B?dDj$9$kG/$ND9$5(B

# N $B2s%7%_%e%l!<%7%g%sMQ$N?dDj%Q%i%a!<%?(B
  ssb.N <- biomass.N <- recruit.N <- tc.pred.N <- meanage.N <- f.y.N <- number.spawning <-
    matrix(NA,N,NY,dimnames=list(NULL,pyear.name))
  naat.age <- tc.age <- faat.age <- array(0,c(NY,n.age,N),
                    dimnames=list(pyear.name,age.name,1:N))
  break.year.N <- rep(0,N)

#  if(!is.null(partial.catch)){
  nfleet <- dim(partial.catch$ratio)[2]
  ptc.pred.N <- array(NA,dim=#c(N,NY,nfleet),
                      c(NY,nfleet,N),
                      dimnames=list(pyear.name,paste2("f",1:nfleet),NULL))
  ages <- unique(floor(as.numeric(age.name)))
  ages <- ages[ages>=0]
  ptc.pred.NA <- array(NA,dim=#c(N,NY,nfleet,n.age/qt),
                       c(NY,nfleet,n.age/qt,N),
                       dimnames=list(pyear.name,paste2("f",1:nfleet),ages,NULL))
#}
#  else{
#    ptc.pred.N <- NULL
#  }

  # $B?F;R4X78$r2>Dj$7$J$$$+!"2>Dj$9$k$+!#(B("simple"$B$H!"(B"highlow"$B$N>l9g(B)
  assume.SSB.R <- is.element(Rec.fun,c("REC.Beverton","REC.linear","REC.beverton.ss","REC.twophase"))

###############################
# $B%7%_%e%l!<%7%g%s$N%k!<%W$N3+;O(B

  for(h in c(1:N)){
    # args.mp$B$O$b$H$b$H$N$b$N$K(B
    args.mp <- configN$args.mp

    tc.pred <- rep(0,NY)
    ptc.pred <- matrix(0,NY,nfleet)
    break.year <- 0
#    if(h%%100==0) cat(" ",h," ")
    # naat.rped $B$N=i4|CM(B ($B0l9TL\!"0lNsL\(B) $B$NBeF~(B
    naat.age[1,,h] <- as.numeric(naat[year.name==initial.year,])
#    tmp.init <- naat.age[1,1,h]

    # $B?F;R4X78$r2>Dj$7$J$$>l9g(B
    if(assume.SSB.R==FALSE){
      con.list <- list(outdata=outdata,pred.year=pred.year,naat.pred=naat.age[,,h],
                       initial.year=initial.year)
      tmp <- make.REC(con.list,Rec.fun,args.R)
      args.R <- tmp$args.R

      # $B2CF~%?%$%_%s%0$O(B age.name==0$B$N%+%i%`$H$9$k(B
      naat.age[,age0,h] <-  tmp$res

      # HS$B$N>l9g!#0lG/L\$N2CF~NL$N%9%1!<%j%s%0(B
      if(HSlimit>0){
        cur.ssb <- sum(as.numeric(naat[which(year.name==initial.year)-1,])*waa*maa)/1000
        if(cur.ssb<HSlimit){
 #         naat.age[,age0,h] <- naat.age[,age0,h]  * cur.ssb / HSlimit
          naat.age[,age0,h] <- HSlimit0+(naat.age[,age0,h]-HSlimit0)  * cur.ssb / HSlimit ## SSB$B$,(B0$B$N$H$-$K2CF~$,(BHSlimit0$B$N>l9g$r9MN8(B
                                                                                          ## $BogCM$r3d$C$F$b5^7c$K2CF~$,8:>/$7$J$$>l9g$rA[Dj(B
                                                                                          ## 2013/06/03 Yukio Takeuchi
        }
      }
    }

    ## SS2$B$G:F@8;:4X78$r2>Dj$9$k>l9g!#:G=i$NG/$N2CF~NL$rCV$-49$($k(B
    ## $B8=9T$N>-MhM=B,$G$O$3$N2>Dj$O;H$C$F$$$J$$!#(B
    # REC.ss2$B$O(Bassume.SSB.R==TRUE$B$J$N$G!"$3$3$OI,MW$J$$$N$G$O!)!)(B

    if(Rec.fun=="REC.beverton.ss"){  # $B!*!*(B $B$3$3$N>r7o$,Hs>o$KHyL/!*!*!*(B($B$h$/$o$+$i$s!K(B
      con.list <- list(outdata=outdata,pred.year=pred.year,
                       naat.pred=as.numeric(naat[which(year.name==initial.year)-1,] ),
                       initial.year=initial.year,waa=waa,maa=maa,gm=configN$gm,
                       timing=c(0,rownames(naat.age)[1]))
      tmp <- make.REC(con.list,Rec.fun,args.R)
      args.R <- tmp$args.R
      naat.age[1,age0,h] <- tmp$res
    }

# 2$B%+%i%`L\$+$i!"(Bmeasured year + 1 $BG/$^$G$N!"?dDj(B
    cc <- 2
    while(cc < (NY+1)){
#      cat("Estimated SSB is",round(sum(naat.pred[cc-1,]*waa*maa/1000))," at "
#          ,cc,"th iteration.\n",sep="")
#      cat("HERE132\n")
#      cat("cc=",cc,",h=",h,"\nsum(naat.age[cc-1,,h]*waa*maa/1000)=",sum(naat.age[cc-1,,h]*waa*maa/1000),"\n")
#      cat("waa=",waa,"\n")
#      cat("maa=",maa,"\n")
#      cat("ex.ssb=",ex.ssb,"\n")
#      cat("naat.age[cc-1,,h]=",naat.age[cc-1,,h],"n")
#      browser()
###### Revised to prevent NA when recruit is determined year by year when using S-R relationship
###### 2013/05/30 Yukio Takeuchi
      tmp<-naat.age[cc-1,,h]
      tmp[is.na(tmp)]<-0
 #     if(round(sum(naat.age[cc-1,,h]*waa*maa/1000))>=ex.ssb){
 #     cat("HERE142\n")
 #     browser()
      if(round(sum(tmp*waa*maa/1000))>=ex.ssb){
########################################################################
        con.list <- list(faat=faat,naat.pred=naat.age[cc-1,,h],
                         timing=rownames(naat.age)[(cc-1):cc],# $BA0G/$HK\G/$N%?%$%_%s%0(B
                         nfleet=nfleet,gm=configN$gm,
                         tc=tc,nmaa=nmaa,waa=waa,initial.year=initial.year,
                         partial.catch=partial.catch,
                         maa=maa,n.age=n.age,outdata=outdata)  # $BA0G/$N>uBV%j%9%H$r:n@.(B
        tmp <- make.MP(con.list,MP,args.mp=args.mp)
        args.mp <- tmp$args.mp
        faat.age[cc-1,,h] <- tmp$res
        #    }

        #--------- F$B$r%i%s%@%`$K?6$i$;$k>l9g(B faat.para$B$rCV$-49$((B -> $B%P%$%"%9Jd@5$9$k$3$H(B
        faat.age[cc-1,,h] <- faat.age[cc-1,,h] * exp(rnorm(n=length(faat.age[cc-1,,h]),sd=F.sigma,
                                                         mean=-(F.sigma)^2/2))
        #---------

        # partial catch$B$r7W;;$9$k>l9g(B
#        if(!is.null(partial.catch)){
        ctmp <- 0
        #           for(nf in 1:nfleet){
        # $BG/NpJL5y3MNL$N7W;;(B
        # args.mp$new.partial.ratio $B$,$J$$(B => partial catch$B$N%*%W%7%g%s$r$=$b$=$b;H$C$F$$$J$$(B
        if(is.null(args.mp$new.partial.ratio)){
          # new.partial.ratio$B$,$"$k>l9g(B
          #           if(sum(names(args.mp)=="new.partial.ratio")==0){
          tmp <- get.partialcatch(cl=con.list,part.F=sweep(partial.catch$ratio,1,faat.age[cc-1,,h],FUN="*"))
        }
        else{ # partial catch$B$rD4@0$7$?>l9g(B
          tmp <- get.partialcatch(cl=con.list,part.F=args.mp$new.partial.ratio)
        }
        ptc.pred[cc-1,] <-  tmp[[1]]
        tc.pred[cc-1] <- sum(ptc.pred[cc-1,])  ## $BAm5y3MNL(B
        tc.age[cc-1,,h] <- ctmp
        ptc.pred.NA[cc-1,,,h] <- tmp$caa.mat
#      }
#        else{
#          # $B5y3MNL7W;;(B
#          tmp <- branov.eq.pre2(1,n.age,naat.age[cc-1,,h],faat.age[cc-1,,h],waa,nmaa)# $BG/NpJL5y3MNL(B
#          tc.pred[cc-1] <- sum(tmp)  ## $BAm5y3MNL(B
#          tc.age[cc-1,,h] <- tmp  ## $BG/NpJL5y3MNL(B
#        }

        #--------- $B2CF~NL$r?F5{;q8;NL$GD4@0$9$k>l9g$N@_Dj(B
        # $B?F$N(BSSB$B$+$i;R$N2CF~NL$r7hDj$9$k2>Dj$N>l9g(B
        if(assume.SSB.R==TRUE){
          tmp <- make.REC(con.list,Rec.fun,args.R)
          args.R <- tmp$args.R
          naat.age[cc,age0,h] <- tmp$res
        }

        # Hockey-stick$BE*$J?F;R4X78$N>l9g(B
        if(HSlimit>0){
          cur.ssb <- sum(naat.age[cc-1,,h]*waa*maa/1000)
          if(cur.ssb < HSlimit){
            naat.age[cc,age0,h] <- naat.age[cc,age0,h] * cur.ssb/HSlimit
          }
        }

        naat.age[cc,,h] <- update.number2(naat.age[cc,,h],naat.age[cc-1,,h],
                                          n.age,nmaa,faat.age[cc-1,,h],age.name)
        cc <- cc+1
      }
      else{
        cat("Estimated SSB is lower than ",ex.ssb," at ",cc,"th year.\n",sep="")
        naat.age[cc:NY,1,h] <- NA
        break.year <- pyear.name[cc]
        cc <- NY+1
      }
    }

    # $B:G8e$N0lG/(B :$B#1G/B?$/7W;;$7$F:G8e$NG/$r>C$9(B
    # $B%P%$%*%^%9(B, SSB, $BJ?6QG/Np(B $B$N7W;;(B    # waa $B$O(B kg $B$J$N$G!"(B1000$B$G3d$C$FC10L$r(Bt$B$KD>$9(B
#    number.spawning[h,] <-  apply(sweep(naat.age[,,h],2,maa,FUN="*")/1000,1,sum) # $B?F5{$NHx?t(B(*1000$BHx(B)
    number.spawning[h,] <-  rowSums(sweep(naat.age[,,h],2,maa,FUN="*")/1000) # $B?F5{$NHx?t(B(*1000$BHx(B)
    BIOMASS <- sweep(naat.age[,,h],2,waa,FUN="*")/1000
#    biomass.N[h,] <- apply(BIOMASS,1,sum)
    biomass.N[h,] <- rowSums(BIOMASS)
    SSB <- sweep(BIOMASS,2,maa,FUN="*")
#    ssb.N[h,] <- apply(SSB,1,sum)
    ssb.N[h,] <- rowSums(SSB)
    recruit.N[h,] <- naat.age[,age0,h]
    tc.pred.N[h,] <- tc.pred
    MEAN.AGE <- sweep(BIOMASS,2,c(1:n.age)-1,FUN="*")
#    MEAN.AGE <- apply(MEAN.AGE,1,sum)/apply(BIOMASS,1,sum)
    MEAN.AGE <- rowSums(MEAN.AGE)/rowSums(BIOMASS)
    meanage.N[h,] <- MEAN.AGE
    break.year.N[h] <- break.year
#    f.y.N[h,] <- apply(faat.age[,,h],1,mean)
    f.y.N[h,] <- rowMeans(faat.age[,,h])

    ptc.pred.N[,,h] <- ptc.pred
  }

# $B%Q%i%a!<%?%j%9%H$N:n@.(B
  para.list <- list(N=N,qt=qt,
                     pred.year=pred.year,init.year=initial.year,args.R=args.R,
                     args.mp=args.mp)
  tmp <- as.numeric(pyear.name)<= initial.year+pred.year-1
  if(record.NAA==TRUE){
    a <- list(tc.age=tc.age,naat.age=naat.age[tmp,,],faat.age=faat.age[tmp,,],
              Biomass=biomass.N[,tmp],SSB=ssb.N[,tmp],outdata=outdata,
              Recruitment = recruit.N[,tmp],
              "Total catch"=tc.pred.N[,tmp],"Break Year"=break.year.N,
              "Mean age"=meanage.N[,tmp],
              "AverageF"=f.y.N[,tmp],
              "Parameter list"=para.list,
              "Partial catch"=ptc.pred.N[tmp,,],
              number.spawning=number.spawning[,tmp],
              pcaa=ptc.pred.NA[tmp,,,])
  }
  else{
    a <- list(Biomass=biomass.N[,tmp],SSB=ssb.N[,tmp],outdata=outdata,
              Recruitment = recruit.N[,tmp],
              "Total catch"=tc.pred.N[,tmp],"Break Year"=break.year.N,
              "Mean age"=meanage.N[,tmp],
              "AverageF"=f.y.N[,tmp],
              "Parameter list"=para.list,
              "Partial catch"=ptc.pred.N[tmp,,],
              number.spawning=number.spawning[,tmp])
  }
  invisible(a)
}

