capping1yr<-"/work/yukiot/projections/capping_rule_1yr.csv"
capping1yr09113yr<-"/work/yukiot/projections/capping_rule_1yr0911.csv"
capping1yr0911FULL<-"/work/yukiot/projections/capping_rule_1yr0911FULL.csv"
capping1yr0911FULLY90<-"/work/yukiot/projections/capping_rule_1yr0911FULLY90.csv"

config.tmp <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=15,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2010,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                              #      fleet.multi2=c(1,5,5,5,1, 1,1,1,1,1, 1,5, 1,1),
                   catch.capping=list(reg.fleet=c(2,3,4,12), #regulationをする漁業
                                    upper.catch=c(5500,200,500,5000),# 漁獲量の上限
                                    reset.timing=c(2,3,3,3))), # 漁獲量の上限をリセットするタイミング),
                   Rec.fun="REC.resample", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )


config.1980s <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2010,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample", # Function for future recruitment
                   args.R=list(year.lim=c(1980,1989), # Options for future recruitment
                               qt=4,recruit.qt=1),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )



config.BH <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=200,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2010,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv(capping1yr))),

                   Rec.fun="REC.beverton.ss", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               resampled=FALSE,steepness=0.95,sigmaR=0.8,R0=1.2e7),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
# config.list[[1]]$args.mp$catch.capping$advance <-read.csv("capping_rule_BQ.csv")

config.res3_2yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                  catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2012,c(2010,2013:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.res3_3yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2013,c(2010,2014:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.res3_4yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2014,c(2010,2013:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.res3_5yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                              catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2015,c(2010,2013:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.Fmult.noTake3yrs <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list=list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    fleet.multi.list=list(rep(1,15),rep(1,15),rep(0,15),rep(1,15)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,3),rep(1,18)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.Fmult.noTake3yrs.aver <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list=list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    fleet.multi.list=list(rep(1,15),rep(1,15),rep(0,15),rep(1,15)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

#####################################################################################################################

#config.scenarioA.Y90.Y90.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
#                   pred.year=31,      # Projection year
#                   N=20,              # N of simulations
#                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
#                   initial.year=2010, # initial year of projection
#                   ex.ssb=0,          # Below this number, the population is considered to extinct
#                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
#                   qt=4,              # Number of season per year
#                   MP="MP.CESqt5",    # Function for future harvesting
#                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
#                                    start.regulation.capping=2011,
#                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
#
#                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
#                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
#                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.8,15),   rep(0.8,15)),
#
#                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
#                                    catch.capping=list(advance=read.csv(capping1yrFULL))),
#                   Rec.fun="REC.resample3", # Function for future recruitment
#                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
#                               qt=4,recruit.qt=1,
#                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
#                               pyear.range =list(1952:2009,1952:2009),
#                               # fyear.range <- list(2010:2012,2013:2013))
#                               fyear.range=list(2011:2041,c(2010))),
#                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
#                   )
#########################################################################################################################
##############################################################################
#
# ScenarioA
#
config.scenarioA.Y90.Y90.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(1,15),   rep(1,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(1,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr0911FULLY90))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioA.Y90.Y90.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(1,15),   rep(1,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(1,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr0911FULLY90))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioA.Y90.Y90.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(1,15),   rep(1,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(1,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

#####################################################################################################################################

config.scenarioA.F80.F80.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.8,15),   rep(0.8,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioA.F80.F80.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.8,15),   rep(0.8,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioA.F80.F80.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.8,15),   rep(0.8,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

#################################################################################################################################################

config.scenarioA.F70.F70.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.7,15),   rep(0.7,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioA.F70.F70.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.7,15),   rep(0.7,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioA.F70.F70.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.7,15),   rep(0.7,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

####################################################################################################################

config.scenarioA.F60.F60.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.6,15),   rep(0.6,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioA.F60.F60.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.6,15),   rep(0.6,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioA.F60.F60.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.6,15),   rep(0.6,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
###########################################################################################################

config.scenarioA.F50.F50.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.5,15),   rep(0.5,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioA.F50.F50.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.5,15),   rep(0.5,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioA.F50.F50.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0.5,15),   rep(0.5,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

#for(scenario in c("scenarioB2","scenarioB3","scenarioC2","scenarioC3")){
#  for(F201517 in c("F50","F60","F70","F80","F90","F100","C091190PERC","C091180PERC","C091170PERC","C091160PERC","C091150PERC")){
#
#  }
#}



###########################################################################################################
############################################################################################################
##
## ScenarioC1
##


config.scenarioC1.F0.F100.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(1,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioC1.F0.F100.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(1,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioC1.F0.F100.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(1,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

###############################################################################


config.scenarioC1.F0.F90.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.9,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioC1.F0.F90.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.9,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioC1.F0.F90.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.9,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

#####################################################################################################################################

config.scenarioC1.F0.F80.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.8,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioC1.F0.F80.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.8,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioC1.F0.F80.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.8,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

#################################################################################################################################################

config.scenarioC1.F0.F70.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.7,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioC1.F0.F70.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.7,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioC1.F0.F70.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.7,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

####################################################################################################################

config.scenarioC1.F0.F60.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.6,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioC1.F0.F60.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.6,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioC1.F0.F60.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.6,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
###########################################################################################################

config.scenarioC1.F0.F50.aveR <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.5,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1952:2009,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )

config.scenarioC1.F0.F50.R80s <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.5,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
#config.scenarioA.F90.F90.R80s,config.scenarioA.F90.F90.R80sHS
config.scenarioC1.F0.F50.R80sHS <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list      =list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    fleet.multi.list=list(rep(1,15),   rep(1,15),   rep(0,15),   rep(0.5,15)),

                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,4),rep(1,17)),rep(1,21)),
                                    catch.capping=list(advance=read.csv(capping1yr))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               #pyear.range =list(1952:2009,1952:2009),
                               pyear.range =list(1980:1989,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2041,c(2010))),
                   HSlimit.tmp=rep(30000,302)  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )



#############################################################################################################

config.Fmult.0.8 <- list(boot=c(1,302),     # specification of bootstrap from and to
                   pred.year=31,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),

                                    Fyear.list=list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    fleet.multi.list=list(rep(1,14),rep(1,14),rep(0.9,14),rep(1,14)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2041)),
                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,3),rep(1,18)),rep(1,21)),
                    catch.capping=list(reg.fleet=c(2,3,4,12), #regulationをする漁業
                                    upper.catch=c(5500,200,500,5000),# 漁獲量の上限
                                    reset.timing=c(2,3,3,3))), # 漁獲量の上限をリセットするタイミング),
                   Rec.fun="REC.resample", # Function for future recruitment
                   args.R=list(year.lim=c(1980,1989), # Options for future recruitment
                               qt=4,recruit.qt=1),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )



# res<-do.projection.ss(mcore=1,bootfiles=c("report.sso","report.sso"),config.list=config.Fmult)

config.list<-list(config.1980s,config.res3_2yrs,config.res3_3yrs,config.res3_4yrs,config.res3_5yrs)


bootfiledir<-"/work/yukiot/Data3Proj4FRA/"



bootfiles<-paste(bootfiledir,"/Report_b",formatC(1:302,width=log10(302)+1,flag=0),".sso",sep="")
faafiles<-paste(bootfiledir,"/faab",formatC(1:302,width=log10(302)+1,flag=0),".R",sep="")

config.lists90<-list(config.scenarioA.Y90.Y90.aveR,config.scenarioA.Y90.Y90.R80s,config.scenarioA.Y90.Y90.R80sHS)
config.lists80<-list(config.scenarioA.Y80.Y80.aveR,config.scenarioA.Y80.Y80.R80s,config.scenarioA.Y80.Y80.R80sHS)
config.lists70<-list(config.scenarioA.Y70.Y70.aveR,config.scenarioA.Y70.Y70.R80s,config.scenarioA.F70.Y70.R80sHS)
config.lists60<-list(config.scenarioA.Y60.Y60.aveR,config.scenarioA.Y60.Y60.R80s,config.scenarioA.60.Y60.R80sHS)
config.lists50<-list(config.scenarioA.Y50.Y50.aveR,config.scenarioA.Y50.Y50.R80s,config.scenarioA.Y50.Y50.R80sHS)

config.C1.100<-list(config.scenarioC1.F0.F100.aveR,config.scenarioC1.F0.F100.R80s,config.scenarioC1.F0.F100.R80sHS)
config.C1.90<-list(config.scenarioC1.F0.F90.aveR,config.scenarioC1.F0.F90.R80s,config.scenarioC1.F0.F90.R80sHS)
config.C1.80<-list(config.scenarioC1.F0.F80.aveR,config.scenarioC1.F0.F80.R80s,config.scenarioC1.F0.F80.R80sHS)
config.C1.70<-list(config.scenarioC1.F0.F70.aveR,config.scenarioC1.F0.F70.R80s,config.scenarioC1.F0.F70.R80sHS)
config.C1.60<-list(config.scenarioC1.F0.F60.aveR,config.scenarioC1.F0.F60.R80s,config.scenarioC1.F0.F60.R80sHS)
config.C1.50<-list(config.scenarioC1.F0.F50.aveR,config.scenarioC1.F0.F50.R80s,config.scenarioC1.F0.F50.R80sHS)


do.proj1<-function(configs=config.lists,mcore=95,bootfiles=NA,faafiles=NA,
    nsim=20,smtp="mail.affrc.go.jp",HSlimit=NULL,reduce.cap=NA,record.NAA=TRUE){
  if(is.null(bootfiles))stop("bootfiles is necessary!")
 library(sendmailR)
# library(foreach)
# library(sstools)
 library(ssfuture)

  to<-c("yukiot@fra.affrc.go.jp","yukio_takeuchi@icloud.com")
  from<-"yukiot@fra.affrc.go.jp"

  subject <- paste("Finished in ",Sys.info()[4])
#  clusterSetRNGStream(cl, 123)

#      if(!is.na(nsim))configs$N<-nsim
#      if(!is.na(reduce.cap))configs$args.mp$capping$advance<-reduce.cap*configs$args.mp$capping$advance
#      if(!is.null(HSlimit))configs$HSlimit.tmp<-HSlimit
#      configs$record.NAA<-record.NAA
#  }
  library(foreach)
  cat("length(configs)=",length(configs),"\n")
  bsres_mix_recs<-foreach(i=1:length(configs))%do%{
      cat(i,";")
      if(!is.na(nsim)){configs[[i]]$N<-nsim}
       configs[[i]]$record.NAA<-record.NAA
       if(!is.null(HSlimit))configs[[i]]$HSlimit.tmp<-HSlimit
      do.projection.mpi.ss.test(mcore=mcore,bootfiles=bootfiles,faafiles=faafiles,config.list=configs[[i]],MPI=FALSE)
  }
  wd<-getwd()
  msg <- paste(" calculation(s) on ",Sys.info()[4]," in ",wd, " finished at ",format(Sys.time(), "%Y-%m-%d  %H:%M:%OS3"))

  sapply(to,function(x){sendmail(from=from, to=x, subject=subject, msg=msg,control=list(smtpServer=smtp))})
  return(bsres_mix_recs)
}

