calindex <-
function(res,qts=c(0.5,0.05,0.95)){
  n.year <- dim(res$Biomass)[[2]]
  if(!is.null(res$naat.age)){
    n.age  <- dim(res$naat.age)[[2]]
  }
  N <- dim(res$Biomass)[[1]]
  nq <- length(qts)

  # naa$B$K$D$$$F!#$"$k>l9g$N$_7W;;(B
  if(!is.null(res$naat.age)){  
    #  naat.expected <-
    naat.geomean <- array(0,dim=c(n.year,n.age,nq))
    #  dimnames(naat.expected)
    dimnames(naat.geomean) <-
                list(dimnames(res$naat.age)[[1]],1:n.age,qts)

    tmp <- apply(res$naat.age,c(1,2),quantile,probs=qts)
    for(i in 1:nq){
      naat.geomean[,,i] <- #naat.expected[,,i]
                   tmp[i,,]
    }
  # naa$B$N(Bsimple mean
    naat.mean <- apply(res$naat.age,c(1,2),mean)
    dimnames(naat.mean) <- list(dimnames(res$naat.age)[[1]],1:n.age)
  }

  
  
  biom.geomean <- #biom.expected <-
    ssb.geomean <- #ssb.expected <-
      matrix(0,n.year,nq,dimnames=list(dimnames(res$Biomass)[[2]],qts))
  nma <- res$outdata$"Natural mortality at age"/res$"Parameter list"$qt
#  tmp2 <- apply(res$naat.age==0,c(1,2),sum)

  biom.mean <- matrix(apply(res$Biomass,2,mean),n.year,1,
                                          dimnames=list(dimnames(res$Biomass)[[2]],"index"))
  ssb.mean <- matrix(apply(res$SSB,2,mean),n.year,1,
                                          dimnames=list(dimnames(res$Biomass)[[2]],"index"))
  recruit.mean <- matrix(apply(res$Recruit,2,mean),n.year,1,
                                          dimnames=list(dimnames(res$Biomass)[[2]],"index"))    
 
  # naat.expected ($B%W%i%9%0%k!<%W$N%P%$%"%9$r=|$$$?G/NpJL5y3MHx?t(B)$B7W;;(B --> $B$b$&7W;;$7$J$$(B
#    for(i in 1:n.year){
#      if(i==1){
#       naat.expected[i,n.age,] <- quantile(res$naat.age[i,n.age,],probs=qts) # $B=iG/EY$O$=$N$^$^$N%W%i%9%0%k!<%W$N?tCM$rF~$l$k(B
#      }
#      else{  # $B$=$l0J30$NG/$N%W%i%9%0%k!<%W$N8DBN?t(B
#        f.19 <- quantile(res$faat.age[i,n.age-1,],probs=qts)
#        f.20 <- quantile(res$faat.age[i,n.age,],probs=qts)
#        naat.expected[i,n.age,] <- naat.expected[i-1,n.age-1,]*exp(-f.19-nma[n.age-1]) +
#          naat.expected[i-1,n.age,]*exp(-f.20-nma[n.age]) 
#      }
#    }
  # naat.expected$B$r;H$C$F!"(Bbias adjusted biomass$B$r7W;;$9$k(B
#  for(i in 1:nq){
#    biom.tmp <- sweep(naat.expected[,,i],2,
#                               as.numeric(res$outdata$"Weight at age (kg)"),FUN="*")/1000
#    biom.expected[,i] <- apply(biom.tmp,1,sum)
#    ssb.expected[,i] <- apply(sweep(biom.tmp,2,
#                               as.numeric(res$outdata$"Maturity at age"),FUN="*"),1,sum)
#  }

  # biomass,SSB$B$N(Bun-bias corrected version
  biomass <- ifelse(is.na(res$"Biomass"),0,res$"Biomass")
  ssb <- ifelse(is.na(res$"SSB"),0,res$"SSB")
  recruit <- ifelse(is.na(res$Recruit),0,res$"Recruit")  
  biom.geomean <- t(apply(biomass,2,quantile,probs=qts))
  ssb.geomean <- t(apply(ssb,2,quantile,probs=qts))
  recruit.geomean <- t(apply(recruit,2,quantile,probs=qts))  

  colnames(biom.geomean) <- colnames(ssb.geomean) <- colnames(recruit.geomean) <- qts
#  for(i in 1:n.year)
#    for(j in 1:n.age){
#      if(tmp2[i,j]==0){
#        naat.geomean[i,j,] <- quantile(res$naat.age,probs=qts)
#      }
#    }

  if(!is.null(res$naat.age)){
    invisible(list(#naat.expected=naat.expected,
                   naat.geomean=naat.geomean,
                   naat.mean=naat.mean,
                   #biom.expected=biom.expected[biom.expected[,1]!=0,],
                   #ssb.expected=ssb.expected[ssb.expected[,1]!=0,],
                   ssb.mean=ssb.mean,
                   biom.geomean=biom.geomean,
                   ssb.geomean=ssb.geomean,
                   biom.mean=biom.mean,
                   recruit.mean=recruit.mean,
                   recruit.geomean=recruit.geomean))
  }
  else{
    invisible(list(ssb.mean=ssb.mean,
                   biom.geomean=biom.geomean,
                   ssb.geomean=ssb.geomean,
                   biom.mean=biom.mean,
                   recruit.mean=recruit.mean,
                   recruit.geomean=recruit.geomean))    
  }
}

