/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * !! Do not reference this file directly !!
 *
 * It is logically a part of camera_metadata.c.  It is broken out for ease of
 * maintaining the tag info.
 *
 * Array assignments are done using specified-index syntax to keep things in
 * sync with camera_metadata_tags.h
 */

/**
 * ! Do not edit this file directly !
 *
 * Generated automatically from camera_metadata_tag_info.mako
 */

const char *camera_metadata_section_names[ANDROID_SECTION_COUNT] = {
    [ANDROID_COLOR_CORRECTION]     = "android.colorCorrection",
    [ANDROID_CONTROL]              = "android.control",
    [ANDROID_DEMOSAIC]             = "android.demosaic",
    [ANDROID_EDGE]                 = "android.edge",
    [ANDROID_FLASH]                = "android.flash",
    [ANDROID_FLASH_INFO]           = "android.flash.info",
    [ANDROID_HOT_PIXEL]            = "android.hotPixel",
    [ANDROID_JPEG]                 = "android.jpeg",
    [ANDROID_LENS]                 = "android.lens",
    [ANDROID_LENS_INFO]            = "android.lens.info",
    [ANDROID_NOISE_REDUCTION]      = "android.noiseReduction",
    [ANDROID_QUIRKS]               = "android.quirks",
    [ANDROID_REQUEST]              = "android.request",
    [ANDROID_SCALER]               = "android.scaler",
    [ANDROID_SENSOR]               = "android.sensor",
    [ANDROID_SENSOR_INFO]          = "android.sensor.info",
    [ANDROID_SHADING]              = "android.shading",
    [ANDROID_STATISTICS]           = "android.statistics",
    [ANDROID_STATISTICS_INFO]      = "android.statistics.info",
    [ANDROID_TONEMAP]              = "android.tonemap",
    [ANDROID_LED]                  = "android.led",
    [ANDROID_INFO]                 = "android.info",
    [ANDROID_BLACK_LEVEL]          = "android.blackLevel",
    [ANDROID_SYNC]                 = "android.sync",
};

unsigned int camera_metadata_section_bounds[ANDROID_SECTION_COUNT][2] = {
    [ANDROID_COLOR_CORRECTION]     = { ANDROID_COLOR_CORRECTION_START,
                                       ANDROID_COLOR_CORRECTION_END },
    [ANDROID_CONTROL]              = { ANDROID_CONTROL_START,
                                       ANDROID_CONTROL_END },
    [ANDROID_DEMOSAIC]             = { ANDROID_DEMOSAIC_START,
                                       ANDROID_DEMOSAIC_END },
    [ANDROID_EDGE]                 = { ANDROID_EDGE_START,
                                       ANDROID_EDGE_END },
    [ANDROID_FLASH]                = { ANDROID_FLASH_START,
                                       ANDROID_FLASH_END },
    [ANDROID_FLASH_INFO]           = { ANDROID_FLASH_INFO_START,
                                       ANDROID_FLASH_INFO_END },
    [ANDROID_HOT_PIXEL]            = { ANDROID_HOT_PIXEL_START,
                                       ANDROID_HOT_PIXEL_END },
    [ANDROID_JPEG]                 = { ANDROID_JPEG_START,
                                       ANDROID_JPEG_END },
    [ANDROID_LENS]                 = { ANDROID_LENS_START,
                                       ANDROID_LENS_END },
    [ANDROID_LENS_INFO]            = { ANDROID_LENS_INFO_START,
                                       ANDROID_LENS_INFO_END },
    [ANDROID_NOISE_REDUCTION]      = { ANDROID_NOISE_REDUCTION_START,
                                       ANDROID_NOISE_REDUCTION_END },
    [ANDROID_QUIRKS]               = { ANDROID_QUIRKS_START,
                                       ANDROID_QUIRKS_END },
    [ANDROID_REQUEST]              = { ANDROID_REQUEST_START,
                                       ANDROID_REQUEST_END },
    [ANDROID_SCALER]               = { ANDROID_SCALER_START,
                                       ANDROID_SCALER_END },
    [ANDROID_SENSOR]               = { ANDROID_SENSOR_START,
                                       ANDROID_SENSOR_END },
    [ANDROID_SENSOR_INFO]          = { ANDROID_SENSOR_INFO_START,
                                       ANDROID_SENSOR_INFO_END },
    [ANDROID_SHADING]              = { ANDROID_SHADING_START,
                                       ANDROID_SHADING_END },
    [ANDROID_STATISTICS]           = { ANDROID_STATISTICS_START,
                                       ANDROID_STATISTICS_END },
    [ANDROID_STATISTICS_INFO]      = { ANDROID_STATISTICS_INFO_START,
                                       ANDROID_STATISTICS_INFO_END },
    [ANDROID_TONEMAP]              = { ANDROID_TONEMAP_START,
                                       ANDROID_TONEMAP_END },
    [ANDROID_LED]                  = { ANDROID_LED_START,
                                       ANDROID_LED_END },
    [ANDROID_INFO]                 = { ANDROID_INFO_START,
                                       ANDROID_INFO_END },
    [ANDROID_BLACK_LEVEL]          = { ANDROID_BLACK_LEVEL_START,
                                       ANDROID_BLACK_LEVEL_END },
    [ANDROID_SYNC]                 = { ANDROID_SYNC_START,
                                       ANDROID_SYNC_END },
};

static tag_info_t android_color_correction[ANDROID_COLOR_CORRECTION_END -
        ANDROID_COLOR_CORRECTION_START] = {
    [ ANDROID_COLOR_CORRECTION_MODE - ANDROID_COLOR_CORRECTION_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_COLOR_CORRECTION_TRANSFORM - ANDROID_COLOR_CORRECTION_START ] =
    { "transform",                     TYPE_RATIONAL
                },
    [ ANDROID_COLOR_CORRECTION_GAINS - ANDROID_COLOR_CORRECTION_START ] =
    { "gains",                         TYPE_FLOAT  },
};

static tag_info_t android_control[ANDROID_CONTROL_END -
        ANDROID_CONTROL_START] = {
    [ ANDROID_CONTROL_AE_ANTIBANDING_MODE - ANDROID_CONTROL_START ] =
    { "aeAntibandingMode",             TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_EXPOSURE_COMPENSATION - ANDROID_CONTROL_START ] =
    { "aeExposureCompensation",        TYPE_INT32  },
    [ ANDROID_CONTROL_AE_LOCK - ANDROID_CONTROL_START ] =
    { "aeLock",                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_MODE - ANDROID_CONTROL_START ] =
    { "aeMode",                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_REGIONS - ANDROID_CONTROL_START ] =
    { "aeRegions",                     TYPE_INT32  },
    [ ANDROID_CONTROL_AE_TARGET_FPS_RANGE - ANDROID_CONTROL_START ] =
    { "aeTargetFpsRange",              TYPE_INT32  },
    [ ANDROID_CONTROL_AE_PRECAPTURE_TRIGGER - ANDROID_CONTROL_START ] =
    { "aePrecaptureTrigger",           TYPE_BYTE   },
    [ ANDROID_CONTROL_AF_MODE - ANDROID_CONTROL_START ] =
    { "afMode",                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AF_REGIONS - ANDROID_CONTROL_START ] =
    { "afRegions",                     TYPE_INT32  },
    [ ANDROID_CONTROL_AF_TRIGGER - ANDROID_CONTROL_START ] =
    { "afTrigger",                     TYPE_BYTE   },
    [ ANDROID_CONTROL_AWB_LOCK - ANDROID_CONTROL_START ] =
    { "awbLock",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AWB_MODE - ANDROID_CONTROL_START ] =
    { "awbMode",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AWB_REGIONS - ANDROID_CONTROL_START ] =
    { "awbRegions",                    TYPE_INT32  },
    [ ANDROID_CONTROL_CAPTURE_INTENT - ANDROID_CONTROL_START ] =
    { "captureIntent",                 TYPE_BYTE   },
    [ ANDROID_CONTROL_EFFECT_MODE - ANDROID_CONTROL_START ] =
    { "effectMode",                    TYPE_BYTE   },
    [ ANDROID_CONTROL_MODE - ANDROID_CONTROL_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_CONTROL_SCENE_MODE - ANDROID_CONTROL_START ] =
    { "sceneMode",                     TYPE_BYTE   },
    [ ANDROID_CONTROL_VIDEO_STABILIZATION_MODE - ANDROID_CONTROL_START ] =
    { "videoStabilizationMode",        TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_AVAILABLE_ANTIBANDING_MODES - ANDROID_CONTROL_START ] =
    { "aeAvailableAntibandingModes",   TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_AVAILABLE_MODES - ANDROID_CONTROL_START ] =
    { "aeAvailableModes",              TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES - ANDROID_CONTROL_START ] =
    { "aeAvailableTargetFpsRanges",    TYPE_INT32  },
    [ ANDROID_CONTROL_AE_COMPENSATION_RANGE - ANDROID_CONTROL_START ] =
    { "aeCompensationRange",           TYPE_INT32  },
    [ ANDROID_CONTROL_AE_COMPENSATION_STEP - ANDROID_CONTROL_START ] =
    { "aeCompensationStep",            TYPE_RATIONAL
                },
    [ ANDROID_CONTROL_AF_AVAILABLE_MODES - ANDROID_CONTROL_START ] =
    { "afAvailableModes",              TYPE_BYTE   },
    [ ANDROID_CONTROL_AVAILABLE_EFFECTS - ANDROID_CONTROL_START ] =
    { "availableEffects",              TYPE_BYTE   },
    [ ANDROID_CONTROL_AVAILABLE_SCENE_MODES - ANDROID_CONTROL_START ] =
    { "availableSceneModes",           TYPE_BYTE   },
    [ ANDROID_CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES - ANDROID_CONTROL_START ] =
    { "availableVideoStabilizationModes",
                                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AWB_AVAILABLE_MODES - ANDROID_CONTROL_START ] =
    { "awbAvailableModes",             TYPE_BYTE   },
    [ ANDROID_CONTROL_MAX_REGIONS - ANDROID_CONTROL_START ] =
    { "maxRegions",                    TYPE_INT32  },
    [ ANDROID_CONTROL_SCENE_MODE_OVERRIDES - ANDROID_CONTROL_START ] =
    { "sceneModeOverrides",            TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_PRECAPTURE_ID - ANDROID_CONTROL_START ] =
    { "aePrecaptureId",                TYPE_INT32  },
    [ ANDROID_CONTROL_AE_STATE - ANDROID_CONTROL_START ] =
    { "aeState",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AF_STATE - ANDROID_CONTROL_START ] =
    { "afState",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AF_TRIGGER_ID - ANDROID_CONTROL_START ] =
    { "afTriggerId",                   TYPE_INT32  },
    [ ANDROID_CONTROL_AWB_STATE - ANDROID_CONTROL_START ] =
    { "awbState",                      TYPE_BYTE   },
};

static tag_info_t android_demosaic[ANDROID_DEMOSAIC_END -
        ANDROID_DEMOSAIC_START] = {
    [ ANDROID_DEMOSAIC_MODE - ANDROID_DEMOSAIC_START ] =
    { "mode",                          TYPE_BYTE   },
};

static tag_info_t android_edge[ANDROID_EDGE_END -
        ANDROID_EDGE_START] = {
    [ ANDROID_EDGE_MODE - ANDROID_EDGE_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_EDGE_STRENGTH - ANDROID_EDGE_START ] =
    { "strength",                      TYPE_BYTE   },
};

static tag_info_t android_flash[ANDROID_FLASH_END -
        ANDROID_FLASH_START] = {
    [ ANDROID_FLASH_FIRING_POWER - ANDROID_FLASH_START ] =
    { "firingPower",                   TYPE_BYTE   },
    [ ANDROID_FLASH_FIRING_TIME - ANDROID_FLASH_START ] =
    { "firingTime",                    TYPE_INT64  },
    [ ANDROID_FLASH_MODE - ANDROID_FLASH_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_FLASH_COLOR_TEMPERATURE - ANDROID_FLASH_START ] =
    { "colorTemperature",              TYPE_BYTE   },
    [ ANDROID_FLASH_MAX_ENERGY - ANDROID_FLASH_START ] =
    { "maxEnergy",                     TYPE_BYTE   },
    [ ANDROID_FLASH_STATE - ANDROID_FLASH_START ] =
    { "state",                         TYPE_BYTE   },
};

static tag_info_t android_flash_info[ANDROID_FLASH_INFO_END -
        ANDROID_FLASH_INFO_START] = {
    [ ANDROID_FLASH_INFO_AVAILABLE - ANDROID_FLASH_INFO_START ] =
    { "available",                     TYPE_BYTE   },
    [ ANDROID_FLASH_INFO_CHARGE_DURATION - ANDROID_FLASH_INFO_START ] =
    { "chargeDuration",                TYPE_INT64  },
};

static tag_info_t android_hot_pixel[ANDROID_HOT_PIXEL_END -
        ANDROID_HOT_PIXEL_START] = {
    [ ANDROID_HOT_PIXEL_MODE - ANDROID_HOT_PIXEL_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES - ANDROID_HOT_PIXEL_START ] =
    { "availableHotPixelModes",        TYPE_BYTE   },
};

static tag_info_t android_jpeg[ANDROID_JPEG_END -
        ANDROID_JPEG_START] = {
    [ ANDROID_JPEG_GPS_COORDINATES - ANDROID_JPEG_START ] =
    { "gpsCoordinates",                TYPE_DOUBLE },
    [ ANDROID_JPEG_GPS_PROCESSING_METHOD - ANDROID_JPEG_START ] =
    { "gpsProcessingMethod",           TYPE_BYTE   },
    [ ANDROID_JPEG_GPS_TIMESTAMP - ANDROID_JPEG_START ] =
    { "gpsTimestamp",                  TYPE_INT64  },
    [ ANDROID_JPEG_ORIENTATION - ANDROID_JPEG_START ] =
    { "orientation",                   TYPE_INT32  },
    [ ANDROID_JPEG_QUALITY - ANDROID_JPEG_START ] =
    { "quality",                       TYPE_BYTE   },
    [ ANDROID_JPEG_THUMBNAIL_QUALITY - ANDROID_JPEG_START ] =
    { "thumbnailQuality",              TYPE_BYTE   },
    [ ANDROID_JPEG_THUMBNAIL_SIZE - ANDROID_JPEG_START ] =
    { "thumbnailSize",                 TYPE_INT32  },
    [ ANDROID_JPEG_AVAILABLE_THUMBNAIL_SIZES - ANDROID_JPEG_START ] =
    { "availableThumbnailSizes",       TYPE_INT32  },
    [ ANDROID_JPEG_MAX_SIZE - ANDROID_JPEG_START ] =
    { "maxSize",                       TYPE_INT32  },
    [ ANDROID_JPEG_SIZE - ANDROID_JPEG_START ] =
    { "size",                          TYPE_INT32  },
};

static tag_info_t android_lens[ANDROID_LENS_END -
        ANDROID_LENS_START] = {
    [ ANDROID_LENS_APERTURE - ANDROID_LENS_START ] =
    { "aperture",                      TYPE_FLOAT  },
    [ ANDROID_LENS_FILTER_DENSITY - ANDROID_LENS_START ] =
    { "filterDensity",                 TYPE_FLOAT  },
    [ ANDROID_LENS_FOCAL_LENGTH - ANDROID_LENS_START ] =
    { "focalLength",                   TYPE_FLOAT  },
    [ ANDROID_LENS_FOCUS_DISTANCE - ANDROID_LENS_START ] =
    { "focusDistance",                 TYPE_FLOAT  },
    [ ANDROID_LENS_OPTICAL_STABILIZATION_MODE - ANDROID_LENS_START ] =
    { "opticalStabilizationMode",      TYPE_BYTE   },
    [ ANDROID_LENS_FACING - ANDROID_LENS_START ] =
    { "facing",                        TYPE_BYTE   },
    [ ANDROID_LENS_OPTICAL_AXIS_ANGLE - ANDROID_LENS_START ] =
    { "opticalAxisAngle",              TYPE_FLOAT  },
    [ ANDROID_LENS_POSITION - ANDROID_LENS_START ] =
    { "position",                      TYPE_FLOAT  },
    [ ANDROID_LENS_FOCUS_RANGE - ANDROID_LENS_START ] =
    { "focusRange",                    TYPE_FLOAT  },
    [ ANDROID_LENS_STATE - ANDROID_LENS_START ] =
    { "state",                         TYPE_BYTE   },
};

static tag_info_t android_lens_info[ANDROID_LENS_INFO_END -
        ANDROID_LENS_INFO_START] = {
    [ ANDROID_LENS_INFO_AVAILABLE_APERTURES - ANDROID_LENS_INFO_START ] =
    { "availableApertures",            TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_AVAILABLE_FILTER_DENSITIES - ANDROID_LENS_INFO_START ] =
    { "availableFilterDensities",      TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_AVAILABLE_FOCAL_LENGTHS - ANDROID_LENS_INFO_START ] =
    { "availableFocalLengths",         TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION - ANDROID_LENS_INFO_START ] =
    { "availableOpticalStabilization", TYPE_BYTE   },
    [ ANDROID_LENS_INFO_HYPERFOCAL_DISTANCE - ANDROID_LENS_INFO_START ] =
    { "hyperfocalDistance",            TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_MINIMUM_FOCUS_DISTANCE - ANDROID_LENS_INFO_START ] =
    { "minimumFocusDistance",          TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_SHADING_MAP_SIZE - ANDROID_LENS_INFO_START ] =
    { "shadingMapSize",                TYPE_INT32  },
    [ ANDROID_LENS_INFO_FOCUS_DISTANCE_CALIBRATION - ANDROID_LENS_INFO_START ] =
    { "focusDistanceCalibration",      TYPE_BYTE   },
};

static tag_info_t android_noise_reduction[ANDROID_NOISE_REDUCTION_END -
        ANDROID_NOISE_REDUCTION_START] = {
    [ ANDROID_NOISE_REDUCTION_MODE - ANDROID_NOISE_REDUCTION_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_NOISE_REDUCTION_STRENGTH - ANDROID_NOISE_REDUCTION_START ] =
    { "strength",                      TYPE_BYTE   },
};

static tag_info_t android_quirks[ANDROID_QUIRKS_END -
        ANDROID_QUIRKS_START] = {
    [ ANDROID_QUIRKS_METERING_CROP_REGION - ANDROID_QUIRKS_START ] =
    { "meteringCropRegion",            TYPE_BYTE   },
    [ ANDROID_QUIRKS_TRIGGER_AF_WITH_AUTO - ANDROID_QUIRKS_START ] =
    { "triggerAfWithAuto",             TYPE_BYTE   },
    [ ANDROID_QUIRKS_USE_ZSL_FORMAT - ANDROID_QUIRKS_START ] =
    { "useZslFormat",                  TYPE_BYTE   },
    [ ANDROID_QUIRKS_USE_PARTIAL_RESULT - ANDROID_QUIRKS_START ] =
    { "usePartialResult",              TYPE_BYTE   },
    [ ANDROID_QUIRKS_PARTIAL_RESULT - ANDROID_QUIRKS_START ] =
    { "partialResult",                 TYPE_BYTE   },
};

static tag_info_t android_request[ANDROID_REQUEST_END -
        ANDROID_REQUEST_START] = {
    [ ANDROID_REQUEST_FRAME_COUNT - ANDROID_REQUEST_START ] =
    { "frameCount",                    TYPE_INT32  },
    [ ANDROID_REQUEST_ID - ANDROID_REQUEST_START ] =
    { "id",                            TYPE_INT32  },
    [ ANDROID_REQUEST_INPUT_STREAMS - ANDROID_REQUEST_START ] =
    { "inputStreams",                  TYPE_INT32  },
    [ ANDROID_REQUEST_METADATA_MODE - ANDROID_REQUEST_START ] =
    { "metadataMode",                  TYPE_BYTE   },
    [ ANDROID_REQUEST_OUTPUT_STREAMS - ANDROID_REQUEST_START ] =
    { "outputStreams",                 TYPE_INT32  },
    [ ANDROID_REQUEST_TYPE - ANDROID_REQUEST_START ] =
    { "type",                          TYPE_BYTE   },
    [ ANDROID_REQUEST_MAX_NUM_OUTPUT_STREAMS - ANDROID_REQUEST_START ] =
    { "maxNumOutputStreams",           TYPE_INT32  },
    [ ANDROID_REQUEST_MAX_NUM_REPROCESS_STREAMS - ANDROID_REQUEST_START ] =
    { "maxNumReprocessStreams",        TYPE_INT32  },
    [ ANDROID_REQUEST_MAX_NUM_INPUT_STREAMS - ANDROID_REQUEST_START ] =
    { "maxNumInputStreams",            TYPE_INT32  },
    [ ANDROID_REQUEST_PIPELINE_DEPTH - ANDROID_REQUEST_START ] =
    { "pipelineDepth",                 TYPE_BYTE   },
    [ ANDROID_REQUEST_PIPELINE_MAX_DEPTH - ANDROID_REQUEST_START ] =
    { "pipelineMaxDepth",              TYPE_BYTE   },
    [ ANDROID_REQUEST_PARTIAL_RESULT_COUNT - ANDROID_REQUEST_START ] =
    { "partialResultCount",            TYPE_INT32  },
    [ ANDROID_REQUEST_AVAILABLE_CAPABILITIES - ANDROID_REQUEST_START ] =
    { "availableCapabilities",         TYPE_BYTE   },
    [ ANDROID_REQUEST_AVAILABLE_REQUEST_KEYS - ANDROID_REQUEST_START ] =
    { "availableRequestKeys",          TYPE_INT32  },
    [ ANDROID_REQUEST_AVAILABLE_RESULT_KEYS - ANDROID_REQUEST_START ] =
    { "availableResultKeys",           TYPE_INT32  },
    [ ANDROID_REQUEST_AVAILABLE_CHARACTERISTICS_KEYS - ANDROID_REQUEST_START ] =
    { "availableCharacteristicsKeys",  TYPE_INT32  },
};

static tag_info_t android_scaler[ANDROID_SCALER_END -
        ANDROID_SCALER_START] = {
    [ ANDROID_SCALER_CROP_REGION - ANDROID_SCALER_START ] =
    { "cropRegion",                    TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_FORMATS - ANDROID_SCALER_START ] =
    { "availableFormats",              TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_JPEG_MIN_DURATIONS - ANDROID_SCALER_START ] =
    { "availableJpegMinDurations",     TYPE_INT64  },
    [ ANDROID_SCALER_AVAILABLE_JPEG_SIZES - ANDROID_SCALER_START ] =
    { "availableJpegSizes",            TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_MAX_DIGITAL_ZOOM - ANDROID_SCALER_START ] =
    { "availableMaxDigitalZoom",       TYPE_FLOAT  },
    [ ANDROID_SCALER_AVAILABLE_PROCESSED_MIN_DURATIONS - ANDROID_SCALER_START ] =
    { "availableProcessedMinDurations",
                                        TYPE_INT64  },
    [ ANDROID_SCALER_AVAILABLE_PROCESSED_SIZES - ANDROID_SCALER_START ] =
    { "availableProcessedSizes",       TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_RAW_MIN_DURATIONS - ANDROID_SCALER_START ] =
    { "availableRawMinDurations",      TYPE_INT64  },
    [ ANDROID_SCALER_AVAILABLE_RAW_SIZES - ANDROID_SCALER_START ] =
    { "availableRawSizes",             TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP - ANDROID_SCALER_START ] =
    { "availableInputOutputFormatsMap",
                                        TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_STREAM_CONFIGURATIONS - ANDROID_SCALER_START ] =
    { "availableStreamConfigurations", TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_MIN_FRAME_DURATIONS - ANDROID_SCALER_START ] =
    { "availableMinFrameDurations",    TYPE_INT64  },
    [ ANDROID_SCALER_AVAILABLE_STALL_DURATIONS - ANDROID_SCALER_START ] =
    { "availableStallDurations",       TYPE_INT64  },
};

static tag_info_t android_sensor[ANDROID_SENSOR_END -
        ANDROID_SENSOR_START] = {
    [ ANDROID_SENSOR_EXPOSURE_TIME - ANDROID_SENSOR_START ] =
    { "exposureTime",                  TYPE_INT64  },
    [ ANDROID_SENSOR_FRAME_DURATION - ANDROID_SENSOR_START ] =
    { "frameDuration",                 TYPE_INT64  },
    [ ANDROID_SENSOR_SENSITIVITY - ANDROID_SENSOR_START ] =
    { "sensitivity",                   TYPE_INT32  },
    [ ANDROID_SENSOR_BASE_GAIN_FACTOR - ANDROID_SENSOR_START ] =
    { "baseGainFactor",                TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_BLACK_LEVEL_PATTERN - ANDROID_SENSOR_START ] =
    { "blackLevelPattern",             TYPE_INT32  },
    [ ANDROID_SENSOR_MAX_ANALOG_SENSITIVITY - ANDROID_SENSOR_START ] =
    { "maxAnalogSensitivity",          TYPE_INT32  },
    [ ANDROID_SENSOR_ORIENTATION - ANDROID_SENSOR_START ] =
    { "orientation",                   TYPE_INT32  },
    [ ANDROID_SENSOR_PROFILE_HUE_SAT_MAP_DIMENSIONS - ANDROID_SENSOR_START ] =
    { "profileHueSatMapDimensions",    TYPE_INT32  },
    [ ANDROID_SENSOR_TIMESTAMP - ANDROID_SENSOR_START ] =
    { "timestamp",                     TYPE_INT64  },
    [ ANDROID_SENSOR_TEMPERATURE - ANDROID_SENSOR_START ] =
    { "temperature",                   TYPE_FLOAT  },
    [ ANDROID_SENSOR_REFERENCE_ILLUMINANT - ANDROID_SENSOR_START ] =
    { "referenceIlluminant",           TYPE_BYTE   },
    [ ANDROID_SENSOR_CALIBRATION_TRANSFORM - ANDROID_SENSOR_START ] =
    { "calibrationTransform",          TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_COLOR_TRANSFORM - ANDROID_SENSOR_START ] =
    { "colorTransform",                TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_FORWARD_MATRIX - ANDROID_SENSOR_START ] =
    { "forwardMatrix",                 TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_NEUTRAL_COLOR_POINT - ANDROID_SENSOR_START ] =
    { "neutralColorPoint",             TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_PROFILE_HUE_SAT_MAP - ANDROID_SENSOR_START ] =
    { "profileHueSatMap",              TYPE_FLOAT  },
    [ ANDROID_SENSOR_PROFILE_TONE_CURVE - ANDROID_SENSOR_START ] =
    { "profileToneCurve",              TYPE_FLOAT  },
    [ ANDROID_SENSOR_GREEN_SPLIT - ANDROID_SENSOR_START ] =
    { "greenSplit",                    TYPE_FLOAT  },
    [ ANDROID_SENSOR_TEST_PATTERN_DATA - ANDROID_SENSOR_START ] =
    { "testPatternData",               TYPE_INT32  },
    [ ANDROID_SENSOR_TEST_PATTERN_MODE - ANDROID_SENSOR_START ] =
    { "testPatternMode",               TYPE_INT32  },
    [ ANDROID_SENSOR_AVAILABLE_TEST_PATTERN_MODES - ANDROID_SENSOR_START ] =
    { "availableTestPatternModes",     TYPE_BYTE   },
};

static tag_info_t android_sensor_info[ANDROID_SENSOR_INFO_END -
        ANDROID_SENSOR_INFO_START] = {
    [ ANDROID_SENSOR_INFO_ACTIVE_ARRAY_SIZE - ANDROID_SENSOR_INFO_START ] =
    { "activeArraySize",               TYPE_INT32  },
    [ ANDROID_SENSOR_INFO_SENSITIVITY_RANGE - ANDROID_SENSOR_INFO_START ] =
    { "sensitivityRange",              TYPE_INT32  },
    [ ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT - ANDROID_SENSOR_INFO_START ] =
    { "colorFilterArrangement",        TYPE_BYTE   },
    [ ANDROID_SENSOR_INFO_EXPOSURE_TIME_RANGE - ANDROID_SENSOR_INFO_START ] =
    { "exposureTimeRange",             TYPE_INT64  },
    [ ANDROID_SENSOR_INFO_MAX_FRAME_DURATION - ANDROID_SENSOR_INFO_START ] =
    { "maxFrameDuration",              TYPE_INT64  },
    [ ANDROID_SENSOR_INFO_PHYSICAL_SIZE - ANDROID_SENSOR_INFO_START ] =
    { "physicalSize",                  TYPE_FLOAT  },
    [ ANDROID_SENSOR_INFO_PIXEL_ARRAY_SIZE - ANDROID_SENSOR_INFO_START ] =
    { "pixelArraySize",                TYPE_INT32  },
    [ ANDROID_SENSOR_INFO_WHITE_LEVEL - ANDROID_SENSOR_INFO_START ] =
    { "whiteLevel",                    TYPE_INT32  },
};

static tag_info_t android_shading[ANDROID_SHADING_END -
        ANDROID_SHADING_START] = {
    [ ANDROID_SHADING_MODE - ANDROID_SHADING_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_SHADING_STRENGTH - ANDROID_SHADING_START ] =
    { "strength",                      TYPE_BYTE   },
};

static tag_info_t android_statistics[ANDROID_STATISTICS_END -
        ANDROID_STATISTICS_START] = {
    [ ANDROID_STATISTICS_FACE_DETECT_MODE - ANDROID_STATISTICS_START ] =
    { "faceDetectMode",                TYPE_BYTE   },
    [ ANDROID_STATISTICS_HISTOGRAM_MODE - ANDROID_STATISTICS_START ] =
    { "histogramMode",                 TYPE_BYTE   },
    [ ANDROID_STATISTICS_SHARPNESS_MAP_MODE - ANDROID_STATISTICS_START ] =
    { "sharpnessMapMode",              TYPE_BYTE   },
    [ ANDROID_STATISTICS_HOT_PIXEL_MAP_MODE - ANDROID_STATISTICS_START ] =
    { "hotPixelMapMode",               TYPE_BYTE   },
    [ ANDROID_STATISTICS_FACE_IDS - ANDROID_STATISTICS_START ] =
    { "faceIds",                       TYPE_INT32  },
    [ ANDROID_STATISTICS_FACE_LANDMARKS - ANDROID_STATISTICS_START ] =
    { "faceLandmarks",                 TYPE_INT32  },
    [ ANDROID_STATISTICS_FACE_RECTANGLES - ANDROID_STATISTICS_START ] =
    { "faceRectangles",                TYPE_INT32  },
    [ ANDROID_STATISTICS_FACE_SCORES - ANDROID_STATISTICS_START ] =
    { "faceScores",                    TYPE_BYTE   },
    [ ANDROID_STATISTICS_HISTOGRAM - ANDROID_STATISTICS_START ] =
    { "histogram",                     TYPE_INT32  },
    [ ANDROID_STATISTICS_SHARPNESS_MAP - ANDROID_STATISTICS_START ] =
    { "sharpnessMap",                  TYPE_INT32  },
    [ ANDROID_STATISTICS_LENS_SHADING_MAP - ANDROID_STATISTICS_START ] =
    { "lensShadingMap",                TYPE_FLOAT  },
    [ ANDROID_STATISTICS_PREDICTED_COLOR_GAINS - ANDROID_STATISTICS_START ] =
    { "predictedColorGains",           TYPE_FLOAT  },
    [ ANDROID_STATISTICS_PREDICTED_COLOR_TRANSFORM - ANDROID_STATISTICS_START ] =
    { "predictedColorTransform",       TYPE_RATIONAL
                },
    [ ANDROID_STATISTICS_SCENE_FLICKER - ANDROID_STATISTICS_START ] =
    { "sceneFlicker",                  TYPE_BYTE   },
    [ ANDROID_STATISTICS_HOT_PIXEL_MAP - ANDROID_STATISTICS_START ] =
    { "hotPixelMap",                   TYPE_INT32  },
    [ ANDROID_STATISTICS_LENS_SHADING_MAP_MODE - ANDROID_STATISTICS_START ] =
    { "lensShadingMapMode",            TYPE_BYTE   },
};

static tag_info_t android_statistics_info[ANDROID_STATISTICS_INFO_END -
        ANDROID_STATISTICS_INFO_START] = {
    [ ANDROID_STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES - ANDROID_STATISTICS_INFO_START ] =
    { "availableFaceDetectModes",      TYPE_BYTE   },
    [ ANDROID_STATISTICS_INFO_HISTOGRAM_BUCKET_COUNT - ANDROID_STATISTICS_INFO_START ] =
    { "histogramBucketCount",          TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_MAX_FACE_COUNT - ANDROID_STATISTICS_INFO_START ] =
    { "maxFaceCount",                  TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_MAX_HISTOGRAM_COUNT - ANDROID_STATISTICS_INFO_START ] =
    { "maxHistogramCount",             TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_MAX_SHARPNESS_MAP_VALUE - ANDROID_STATISTICS_INFO_START ] =
    { "maxSharpnessMapValue",          TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_SHARPNESS_MAP_SIZE - ANDROID_STATISTICS_INFO_START ] =
    { "sharpnessMapSize",              TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES - ANDROID_STATISTICS_INFO_START ] =
    { "availableHotPixelMapModes",     TYPE_BYTE   },
};

static tag_info_t android_tonemap[ANDROID_TONEMAP_END -
        ANDROID_TONEMAP_START] = {
    [ ANDROID_TONEMAP_CURVE_BLUE - ANDROID_TONEMAP_START ] =
    { "curveBlue",                     TYPE_FLOAT  },
    [ ANDROID_TONEMAP_CURVE_GREEN - ANDROID_TONEMAP_START ] =
    { "curveGreen",                    TYPE_FLOAT  },
    [ ANDROID_TONEMAP_CURVE_RED - ANDROID_TONEMAP_START ] =
    { "curveRed",                      TYPE_FLOAT  },
    [ ANDROID_TONEMAP_MODE - ANDROID_TONEMAP_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_TONEMAP_MAX_CURVE_POINTS - ANDROID_TONEMAP_START ] =
    { "maxCurvePoints",                TYPE_INT32  },
};

static tag_info_t android_led[ANDROID_LED_END -
        ANDROID_LED_START] = {
    [ ANDROID_LED_TRANSMIT - ANDROID_LED_START ] =
    { "transmit",                      TYPE_BYTE   },
    [ ANDROID_LED_AVAILABLE_LEDS - ANDROID_LED_START ] =
    { "availableLeds",                 TYPE_BYTE   },
};

static tag_info_t android_info[ANDROID_INFO_END -
        ANDROID_INFO_START] = {
    [ ANDROID_INFO_SUPPORTED_HARDWARE_LEVEL - ANDROID_INFO_START ] =
    { "supportedHardwareLevel",        TYPE_BYTE   },
};

static tag_info_t android_black_level[ANDROID_BLACK_LEVEL_END -
        ANDROID_BLACK_LEVEL_START] = {
    [ ANDROID_BLACK_LEVEL_LOCK - ANDROID_BLACK_LEVEL_START ] =
    { "lock",                          TYPE_BYTE   },
};

static tag_info_t android_sync[ANDROID_SYNC_END -
        ANDROID_SYNC_START] = {
    [ ANDROID_SYNC_FRAME_NUMBER - ANDROID_SYNC_START ] =
    { "frameNumber",                   TYPE_INT64  },
    [ ANDROID_SYNC_MAX_LATENCY - ANDROID_SYNC_START ] =
    { "maxLatency",                    TYPE_INT32  },
};


tag_info_t *tag_info[ANDROID_SECTION_COUNT] = {
    android_color_correction,
    android_control,
    android_demosaic,
    android_edge,
    android_flash,
    android_flash_info,
    android_hot_pixel,
    android_jpeg,
    android_lens,
    android_lens_info,
    android_noise_reduction,
    android_quirks,
    android_request,
    android_scaler,
    android_sensor,
    android_sensor_info,
    android_shading,
    android_statistics,
    android_statistics_info,
    android_tonemap,
    android_led,
    android_info,
    android_black_level,
    android_sync,
};

int camera_metadata_enum_snprint(uint32_t tag,
                                 uint32_t value,
                                 char *dst,
                                 size_t size) {
    const char *msg = "error: not an enum";
    int ret = -1;

    switch(tag) {
        case ANDROID_COLOR_CORRECTION_MODE: {
            switch (value) {
                case ANDROID_COLOR_CORRECTION_MODE_TRANSFORM_MATRIX:
                    msg = "TRANSFORM_MATRIX";
                    ret = 0;
                    break;
                case ANDROID_COLOR_CORRECTION_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_COLOR_CORRECTION_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_COLOR_CORRECTION_TRANSFORM: {
            break;
        }
        case ANDROID_COLOR_CORRECTION_GAINS: {
            break;
        }

        case ANDROID_CONTROL_AE_ANTIBANDING_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_50HZ:
                    msg = "50HZ";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_60HZ:
                    msg = "60HZ";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_EXPOSURE_COMPENSATION: {
            break;
        }
        case ANDROID_CONTROL_AE_LOCK: {
            switch (value) {
                case ANDROID_CONTROL_AE_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AE_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON_AUTO_FLASH:
                    msg = "ON_AUTO_FLASH";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON_ALWAYS_FLASH:
                    msg = "ON_ALWAYS_FLASH";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON_AUTO_FLASH_REDEYE:
                    msg = "ON_AUTO_FLASH_REDEYE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_AE_TARGET_FPS_RANGE: {
            break;
        }
        case ANDROID_CONTROL_AE_PRECAPTURE_TRIGGER: {
            switch (value) {
                case ANDROID_CONTROL_AE_PRECAPTURE_TRIGGER_IDLE:
                    msg = "IDLE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_PRECAPTURE_TRIGGER_START:
                    msg = "START";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AF_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AF_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_MACRO:
                    msg = "MACRO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_CONTINUOUS_VIDEO:
                    msg = "CONTINUOUS_VIDEO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_CONTINUOUS_PICTURE:
                    msg = "CONTINUOUS_PICTURE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_EDOF:
                    msg = "EDOF";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AF_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_AF_TRIGGER: {
            switch (value) {
                case ANDROID_CONTROL_AF_TRIGGER_IDLE:
                    msg = "IDLE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_TRIGGER_START:
                    msg = "START";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_TRIGGER_CANCEL:
                    msg = "CANCEL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AWB_LOCK: {
            switch (value) {
                case ANDROID_CONTROL_AWB_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AWB_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AWB_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_INCANDESCENT:
                    msg = "INCANDESCENT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_FLUORESCENT:
                    msg = "FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_WARM_FLUORESCENT:
                    msg = "WARM_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_DAYLIGHT:
                    msg = "DAYLIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_CLOUDY_DAYLIGHT:
                    msg = "CLOUDY_DAYLIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_TWILIGHT:
                    msg = "TWILIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_SHADE:
                    msg = "SHADE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AWB_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_CAPTURE_INTENT: {
            switch (value) {
                case ANDROID_CONTROL_CAPTURE_INTENT_CUSTOM:
                    msg = "CUSTOM";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_PREVIEW:
                    msg = "PREVIEW";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_STILL_CAPTURE:
                    msg = "STILL_CAPTURE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_VIDEO_RECORD:
                    msg = "VIDEO_RECORD";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_VIDEO_SNAPSHOT:
                    msg = "VIDEO_SNAPSHOT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_ZERO_SHUTTER_LAG:
                    msg = "ZERO_SHUTTER_LAG";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_EFFECT_MODE: {
            switch (value) {
                case ANDROID_CONTROL_EFFECT_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_MONO:
                    msg = "MONO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_NEGATIVE:
                    msg = "NEGATIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_SOLARIZE:
                    msg = "SOLARIZE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_SEPIA:
                    msg = "SEPIA";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_POSTERIZE:
                    msg = "POSTERIZE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_WHITEBOARD:
                    msg = "WHITEBOARD";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_BLACKBOARD:
                    msg = "BLACKBOARD";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_AQUA:
                    msg = "AQUA";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_MODE: {
            switch (value) {
                case ANDROID_CONTROL_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_MODE_USE_SCENE_MODE:
                    msg = "USE_SCENE_MODE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_MODE_OFF_KEEP_STATE:
                    msg = "OFF_KEEP_STATE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_SCENE_MODE: {
            switch (value) {
                case ANDROID_CONTROL_SCENE_MODE_DISABLED:
                    msg = "DISABLED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_FACE_PRIORITY:
                    msg = "FACE_PRIORITY";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_ACTION:
                    msg = "ACTION";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_PORTRAIT:
                    msg = "PORTRAIT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_LANDSCAPE:
                    msg = "LANDSCAPE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_NIGHT:
                    msg = "NIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_NIGHT_PORTRAIT:
                    msg = "NIGHT_PORTRAIT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_THEATRE:
                    msg = "THEATRE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_BEACH:
                    msg = "BEACH";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_SNOW:
                    msg = "SNOW";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_SUNSET:
                    msg = "SUNSET";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_STEADYPHOTO:
                    msg = "STEADYPHOTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_FIREWORKS:
                    msg = "FIREWORKS";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_SPORTS:
                    msg = "SPORTS";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_PARTY:
                    msg = "PARTY";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_CANDLELIGHT:
                    msg = "CANDLELIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_BARCODE:
                    msg = "BARCODE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_VIDEO_STABILIZATION_MODE: {
            switch (value) {
                case ANDROID_CONTROL_VIDEO_STABILIZATION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_VIDEO_STABILIZATION_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_AVAILABLE_ANTIBANDING_MODES: {
            break;
        }
        case ANDROID_CONTROL_AE_AVAILABLE_MODES: {
            break;
        }
        case ANDROID_CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES: {
            break;
        }
        case ANDROID_CONTROL_AE_COMPENSATION_RANGE: {
            break;
        }
        case ANDROID_CONTROL_AE_COMPENSATION_STEP: {
            break;
        }
        case ANDROID_CONTROL_AF_AVAILABLE_MODES: {
            break;
        }
        case ANDROID_CONTROL_AVAILABLE_EFFECTS: {
            break;
        }
        case ANDROID_CONTROL_AVAILABLE_SCENE_MODES: {
            break;
        }
        case ANDROID_CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES: {
            break;
        }
        case ANDROID_CONTROL_AWB_AVAILABLE_MODES: {
            break;
        }
        case ANDROID_CONTROL_MAX_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_SCENE_MODE_OVERRIDES: {
            break;
        }
        case ANDROID_CONTROL_AE_PRECAPTURE_ID: {
            break;
        }
        case ANDROID_CONTROL_AE_STATE: {
            switch (value) {
                case ANDROID_CONTROL_AE_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_SEARCHING:
                    msg = "SEARCHING";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_CONVERGED:
                    msg = "CONVERGED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_LOCKED:
                    msg = "LOCKED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_FLASH_REQUIRED:
                    msg = "FLASH_REQUIRED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_PRECAPTURE:
                    msg = "PRECAPTURE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AF_STATE: {
            switch (value) {
                case ANDROID_CONTROL_AF_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_PASSIVE_SCAN:
                    msg = "PASSIVE_SCAN";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_PASSIVE_FOCUSED:
                    msg = "PASSIVE_FOCUSED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_ACTIVE_SCAN:
                    msg = "ACTIVE_SCAN";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_FOCUSED_LOCKED:
                    msg = "FOCUSED_LOCKED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_NOT_FOCUSED_LOCKED:
                    msg = "NOT_FOCUSED_LOCKED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_PASSIVE_UNFOCUSED:
                    msg = "PASSIVE_UNFOCUSED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AF_TRIGGER_ID: {
            break;
        }
        case ANDROID_CONTROL_AWB_STATE: {
            switch (value) {
                case ANDROID_CONTROL_AWB_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_STATE_SEARCHING:
                    msg = "SEARCHING";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_STATE_CONVERGED:
                    msg = "CONVERGED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_STATE_LOCKED:
                    msg = "LOCKED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_DEMOSAIC_MODE: {
            switch (value) {
                case ANDROID_DEMOSAIC_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_DEMOSAIC_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_EDGE_MODE: {
            switch (value) {
                case ANDROID_EDGE_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_EDGE_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_EDGE_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_EDGE_STRENGTH: {
            break;
        }

        case ANDROID_FLASH_FIRING_POWER: {
            break;
        }
        case ANDROID_FLASH_FIRING_TIME: {
            break;
        }
        case ANDROID_FLASH_MODE: {
            switch (value) {
                case ANDROID_FLASH_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_FLASH_MODE_SINGLE:
                    msg = "SINGLE";
                    ret = 0;
                    break;
                case ANDROID_FLASH_MODE_TORCH:
                    msg = "TORCH";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_FLASH_COLOR_TEMPERATURE: {
            break;
        }
        case ANDROID_FLASH_MAX_ENERGY: {
            break;
        }
        case ANDROID_FLASH_STATE: {
            switch (value) {
                case ANDROID_FLASH_STATE_UNAVAILABLE:
                    msg = "UNAVAILABLE";
                    ret = 0;
                    break;
                case ANDROID_FLASH_STATE_CHARGING:
                    msg = "CHARGING";
                    ret = 0;
                    break;
                case ANDROID_FLASH_STATE_READY:
                    msg = "READY";
                    ret = 0;
                    break;
                case ANDROID_FLASH_STATE_FIRED:
                    msg = "FIRED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_FLASH_INFO_AVAILABLE: {
            switch (value) {
                case ANDROID_FLASH_INFO_AVAILABLE_FALSE:
                    msg = "FALSE";
                    ret = 0;
                    break;
                case ANDROID_FLASH_INFO_AVAILABLE_TRUE:
                    msg = "TRUE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_FLASH_INFO_CHARGE_DURATION: {
            break;
        }

        case ANDROID_HOT_PIXEL_MODE: {
            switch (value) {
                case ANDROID_HOT_PIXEL_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_HOT_PIXEL_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_HOT_PIXEL_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES: {
            break;
        }

        case ANDROID_JPEG_GPS_COORDINATES: {
            break;
        }
        case ANDROID_JPEG_GPS_PROCESSING_METHOD: {
            break;
        }
        case ANDROID_JPEG_GPS_TIMESTAMP: {
            break;
        }
        case ANDROID_JPEG_ORIENTATION: {
            break;
        }
        case ANDROID_JPEG_QUALITY: {
            break;
        }
        case ANDROID_JPEG_THUMBNAIL_QUALITY: {
            break;
        }
        case ANDROID_JPEG_THUMBNAIL_SIZE: {
            break;
        }
        case ANDROID_JPEG_AVAILABLE_THUMBNAIL_SIZES: {
            break;
        }
        case ANDROID_JPEG_MAX_SIZE: {
            break;
        }
        case ANDROID_JPEG_SIZE: {
            break;
        }

        case ANDROID_LENS_APERTURE: {
            break;
        }
        case ANDROID_LENS_FILTER_DENSITY: {
            break;
        }
        case ANDROID_LENS_FOCAL_LENGTH: {
            break;
        }
        case ANDROID_LENS_FOCUS_DISTANCE: {
            break;
        }
        case ANDROID_LENS_OPTICAL_STABILIZATION_MODE: {
            switch (value) {
                case ANDROID_LENS_OPTICAL_STABILIZATION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_LENS_OPTICAL_STABILIZATION_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_LENS_FACING: {
            switch (value) {
                case ANDROID_LENS_FACING_FRONT:
                    msg = "FRONT";
                    ret = 0;
                    break;
                case ANDROID_LENS_FACING_BACK:
                    msg = "BACK";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_LENS_OPTICAL_AXIS_ANGLE: {
            break;
        }
        case ANDROID_LENS_POSITION: {
            break;
        }
        case ANDROID_LENS_FOCUS_RANGE: {
            break;
        }
        case ANDROID_LENS_STATE: {
            switch (value) {
                case ANDROID_LENS_STATE_STATIONARY:
                    msg = "STATIONARY";
                    ret = 0;
                    break;
                case ANDROID_LENS_STATE_MOVING:
                    msg = "MOVING";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_LENS_INFO_AVAILABLE_APERTURES: {
            break;
        }
        case ANDROID_LENS_INFO_AVAILABLE_FILTER_DENSITIES: {
            break;
        }
        case ANDROID_LENS_INFO_AVAILABLE_FOCAL_LENGTHS: {
            break;
        }
        case ANDROID_LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION: {
            break;
        }
        case ANDROID_LENS_INFO_HYPERFOCAL_DISTANCE: {
            break;
        }
        case ANDROID_LENS_INFO_MINIMUM_FOCUS_DISTANCE: {
            break;
        }
        case ANDROID_LENS_INFO_SHADING_MAP_SIZE: {
            break;
        }
        case ANDROID_LENS_INFO_FOCUS_DISTANCE_CALIBRATION: {
            switch (value) {
                case ANDROID_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_UNCALIBRATED:
                    msg = "UNCALIBRATED";
                    ret = 0;
                    break;
                case ANDROID_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_APPROXIMATE:
                    msg = "APPROXIMATE";
                    ret = 0;
                    break;
                case ANDROID_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_CALIBRATED:
                    msg = "CALIBRATED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_NOISE_REDUCTION_MODE: {
            switch (value) {
                case ANDROID_NOISE_REDUCTION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_NOISE_REDUCTION_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_NOISE_REDUCTION_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_NOISE_REDUCTION_STRENGTH: {
            break;
        }

        case ANDROID_QUIRKS_METERING_CROP_REGION: {
            break;
        }
        case ANDROID_QUIRKS_TRIGGER_AF_WITH_AUTO: {
            break;
        }
        case ANDROID_QUIRKS_USE_ZSL_FORMAT: {
            break;
        }
        case ANDROID_QUIRKS_USE_PARTIAL_RESULT: {
            break;
        }
        case ANDROID_QUIRKS_PARTIAL_RESULT: {
            switch (value) {
                case ANDROID_QUIRKS_PARTIAL_RESULT_FINAL:
                    msg = "FINAL";
                    ret = 0;
                    break;
                case ANDROID_QUIRKS_PARTIAL_RESULT_PARTIAL:
                    msg = "PARTIAL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_REQUEST_FRAME_COUNT: {
            break;
        }
        case ANDROID_REQUEST_ID: {
            break;
        }
        case ANDROID_REQUEST_INPUT_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_METADATA_MODE: {
            switch (value) {
                case ANDROID_REQUEST_METADATA_MODE_NONE:
                    msg = "NONE";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_METADATA_MODE_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_REQUEST_OUTPUT_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_TYPE: {
            switch (value) {
                case ANDROID_REQUEST_TYPE_CAPTURE:
                    msg = "CAPTURE";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_TYPE_REPROCESS:
                    msg = "REPROCESS";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_REQUEST_MAX_NUM_OUTPUT_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_MAX_NUM_REPROCESS_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_MAX_NUM_INPUT_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_PIPELINE_DEPTH: {
            break;
        }
        case ANDROID_REQUEST_PIPELINE_MAX_DEPTH: {
            break;
        }
        case ANDROID_REQUEST_PARTIAL_RESULT_COUNT: {
            break;
        }
        case ANDROID_REQUEST_AVAILABLE_CAPABILITIES: {
            switch (value) {
                case ANDROID_REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE:
                    msg = "BACKWARD_COMPATIBLE";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_AVAILABLE_CAPABILITIES_OPTIONAL:
                    msg = "OPTIONAL";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_AVAILABLE_CAPABILITIES_MANUAL_SENSOR:
                    msg = "MANUAL_SENSOR";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_AVAILABLE_CAPABILITIES_GCAM:
                    msg = "GCAM";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_AVAILABLE_CAPABILITIES_ZSL:
                    msg = "ZSL";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_AVAILABLE_CAPABILITIES_DNG:
                    msg = "DNG";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_REQUEST_AVAILABLE_REQUEST_KEYS: {
            break;
        }
        case ANDROID_REQUEST_AVAILABLE_RESULT_KEYS: {
            break;
        }
        case ANDROID_REQUEST_AVAILABLE_CHARACTERISTICS_KEYS: {
            break;
        }

        case ANDROID_SCALER_CROP_REGION: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_FORMATS: {
            switch (value) {
                case ANDROID_SCALER_AVAILABLE_FORMATS_RAW16:
                    msg = "RAW16";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_RAW_OPAQUE:
                    msg = "RAW_OPAQUE";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_YV12:
                    msg = "YV12";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_YCrCb_420_SP:
                    msg = "YCrCb_420_SP";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_IMPLEMENTATION_DEFINED:
                    msg = "IMPLEMENTATION_DEFINED";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_YCbCr_420_888:
                    msg = "YCbCr_420_888";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_BLOB:
                    msg = "BLOB";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SCALER_AVAILABLE_JPEG_MIN_DURATIONS: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_JPEG_SIZES: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_MAX_DIGITAL_ZOOM: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_PROCESSED_MIN_DURATIONS: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_PROCESSED_SIZES: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_RAW_MIN_DURATIONS: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_RAW_SIZES: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_STREAM_CONFIGURATIONS: {
            switch (value) {
                case ANDROID_SCALER_AVAILABLE_STREAM_CONFIGURATIONS_OUTPUT:
                    msg = "OUTPUT";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_STREAM_CONFIGURATIONS_INPUT:
                    msg = "INPUT";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SCALER_AVAILABLE_MIN_FRAME_DURATIONS: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_STALL_DURATIONS: {
            break;
        }

        case ANDROID_SENSOR_EXPOSURE_TIME: {
            break;
        }
        case ANDROID_SENSOR_FRAME_DURATION: {
            break;
        }
        case ANDROID_SENSOR_SENSITIVITY: {
            break;
        }
        case ANDROID_SENSOR_BASE_GAIN_FACTOR: {
            break;
        }
        case ANDROID_SENSOR_BLACK_LEVEL_PATTERN: {
            break;
        }
        case ANDROID_SENSOR_MAX_ANALOG_SENSITIVITY: {
            break;
        }
        case ANDROID_SENSOR_ORIENTATION: {
            break;
        }
        case ANDROID_SENSOR_PROFILE_HUE_SAT_MAP_DIMENSIONS: {
            break;
        }
        case ANDROID_SENSOR_TIMESTAMP: {
            break;
        }
        case ANDROID_SENSOR_TEMPERATURE: {
            break;
        }
        case ANDROID_SENSOR_REFERENCE_ILLUMINANT: {
            switch (value) {
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_DAYLIGHT:
                    msg = "DAYLIGHT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_FLUORESCENT:
                    msg = "FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_TUNGSTEN:
                    msg = "TUNGSTEN";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_FLASH:
                    msg = "FLASH";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_FINE_WEATHER:
                    msg = "FINE_WEATHER";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_CLOUDY_WEATHER:
                    msg = "CLOUDY_WEATHER";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_SHADE:
                    msg = "SHADE";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_DAYLIGHT_FLUORESCENT:
                    msg = "DAYLIGHT_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_DAY_WHITE_FLUORESCENT:
                    msg = "DAY_WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_COOL_WHITE_FLUORESCENT:
                    msg = "COOL_WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_WHITE_FLUORESCENT:
                    msg = "WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_STANDARD_A:
                    msg = "STANDARD_A";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_STANDARD_B:
                    msg = "STANDARD_B";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_STANDARD_C:
                    msg = "STANDARD_C";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_D55:
                    msg = "D55";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_D65:
                    msg = "D65";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_D75:
                    msg = "D75";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_D50:
                    msg = "D50";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT_ISO_STUDIO_TUNGSTEN:
                    msg = "ISO_STUDIO_TUNGSTEN";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SENSOR_CALIBRATION_TRANSFORM: {
            break;
        }
        case ANDROID_SENSOR_COLOR_TRANSFORM: {
            break;
        }
        case ANDROID_SENSOR_FORWARD_MATRIX: {
            break;
        }
        case ANDROID_SENSOR_NEUTRAL_COLOR_POINT: {
            break;
        }
        case ANDROID_SENSOR_PROFILE_HUE_SAT_MAP: {
            break;
        }
        case ANDROID_SENSOR_PROFILE_TONE_CURVE: {
            break;
        }
        case ANDROID_SENSOR_GREEN_SPLIT: {
            break;
        }
        case ANDROID_SENSOR_TEST_PATTERN_DATA: {
            break;
        }
        case ANDROID_SENSOR_TEST_PATTERN_MODE: {
            switch (value) {
                case ANDROID_SENSOR_TEST_PATTERN_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_TEST_PATTERN_MODE_SOLID_COLOR:
                    msg = "SOLID_COLOR";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_TEST_PATTERN_MODE_COLOR_BARS:
                    msg = "COLOR_BARS";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_TEST_PATTERN_MODE_COLOR_BARS_FADE_TO_GRAY:
                    msg = "COLOR_BARS_FADE_TO_GRAY";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_TEST_PATTERN_MODE_PN9:
                    msg = "PN9";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_TEST_PATTERN_MODE_CUSTOM1:
                    msg = "CUSTOM1";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SENSOR_AVAILABLE_TEST_PATTERN_MODES: {
            break;
        }

        case ANDROID_SENSOR_INFO_ACTIVE_ARRAY_SIZE: {
            break;
        }
        case ANDROID_SENSOR_INFO_SENSITIVITY_RANGE: {
            break;
        }
        case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT: {
            switch (value) {
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGGB:
                    msg = "RGGB";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GRBG:
                    msg = "GRBG";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GBRG:
                    msg = "GBRG";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_BGGR:
                    msg = "BGGR";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGB:
                    msg = "RGB";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SENSOR_INFO_EXPOSURE_TIME_RANGE: {
            break;
        }
        case ANDROID_SENSOR_INFO_MAX_FRAME_DURATION: {
            break;
        }
        case ANDROID_SENSOR_INFO_PHYSICAL_SIZE: {
            break;
        }
        case ANDROID_SENSOR_INFO_PIXEL_ARRAY_SIZE: {
            break;
        }
        case ANDROID_SENSOR_INFO_WHITE_LEVEL: {
            break;
        }

        case ANDROID_SHADING_MODE: {
            switch (value) {
                case ANDROID_SHADING_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_SHADING_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_SHADING_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SHADING_STRENGTH: {
            break;
        }

        case ANDROID_STATISTICS_FACE_DETECT_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_FACE_DETECT_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_FACE_DETECT_MODE_SIMPLE:
                    msg = "SIMPLE";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_FACE_DETECT_MODE_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_HISTOGRAM_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_HISTOGRAM_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_HISTOGRAM_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_SHARPNESS_MAP_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_SHARPNESS_MAP_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_SHARPNESS_MAP_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_HOT_PIXEL_MAP_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_HOT_PIXEL_MAP_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_HOT_PIXEL_MAP_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_FACE_IDS: {
            break;
        }
        case ANDROID_STATISTICS_FACE_LANDMARKS: {
            break;
        }
        case ANDROID_STATISTICS_FACE_RECTANGLES: {
            break;
        }
        case ANDROID_STATISTICS_FACE_SCORES: {
            break;
        }
        case ANDROID_STATISTICS_HISTOGRAM: {
            break;
        }
        case ANDROID_STATISTICS_SHARPNESS_MAP: {
            break;
        }
        case ANDROID_STATISTICS_LENS_SHADING_MAP: {
            break;
        }
        case ANDROID_STATISTICS_PREDICTED_COLOR_GAINS: {
            break;
        }
        case ANDROID_STATISTICS_PREDICTED_COLOR_TRANSFORM: {
            break;
        }
        case ANDROID_STATISTICS_SCENE_FLICKER: {
            switch (value) {
                case ANDROID_STATISTICS_SCENE_FLICKER_NONE:
                    msg = "NONE";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_SCENE_FLICKER_50HZ:
                    msg = "50HZ";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_SCENE_FLICKER_60HZ:
                    msg = "60HZ";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_HOT_PIXEL_MAP: {
            break;
        }
        case ANDROID_STATISTICS_LENS_SHADING_MAP_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_LENS_SHADING_MAP_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_LENS_SHADING_MAP_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES: {
            break;
        }
        case ANDROID_STATISTICS_INFO_HISTOGRAM_BUCKET_COUNT: {
            break;
        }
        case ANDROID_STATISTICS_INFO_MAX_FACE_COUNT: {
            break;
        }
        case ANDROID_STATISTICS_INFO_MAX_HISTOGRAM_COUNT: {
            break;
        }
        case ANDROID_STATISTICS_INFO_MAX_SHARPNESS_MAP_VALUE: {
            break;
        }
        case ANDROID_STATISTICS_INFO_SHARPNESS_MAP_SIZE: {
            break;
        }
        case ANDROID_STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES: {
            break;
        }

        case ANDROID_TONEMAP_CURVE_BLUE: {
            break;
        }
        case ANDROID_TONEMAP_CURVE_GREEN: {
            break;
        }
        case ANDROID_TONEMAP_CURVE_RED: {
            break;
        }
        case ANDROID_TONEMAP_MODE: {
            switch (value) {
                case ANDROID_TONEMAP_MODE_CONTRAST_CURVE:
                    msg = "CONTRAST_CURVE";
                    ret = 0;
                    break;
                case ANDROID_TONEMAP_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_TONEMAP_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_TONEMAP_MAX_CURVE_POINTS: {
            break;
        }

        case ANDROID_LED_TRANSMIT: {
            switch (value) {
                case ANDROID_LED_TRANSMIT_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_LED_TRANSMIT_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_LED_AVAILABLE_LEDS: {
            switch (value) {
                case ANDROID_LED_AVAILABLE_LEDS_TRANSMIT:
                    msg = "TRANSMIT";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_INFO_SUPPORTED_HARDWARE_LEVEL: {
            switch (value) {
                case ANDROID_INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED:
                    msg = "LIMITED";
                    ret = 0;
                    break;
                case ANDROID_INFO_SUPPORTED_HARDWARE_LEVEL_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_BLACK_LEVEL_LOCK: {
            switch (value) {
                case ANDROID_BLACK_LEVEL_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_BLACK_LEVEL_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_SYNC_FRAME_NUMBER: {
            switch (value) {
                case ANDROID_SYNC_FRAME_NUMBER_CONVERGING:
                    msg = "CONVERGING";
                    ret = 0;
                    break;
                case ANDROID_SYNC_FRAME_NUMBER_UNKNOWN:
                    msg = "UNKNOWN";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SYNC_MAX_LATENCY: {
            switch (value) {
                case ANDROID_SYNC_MAX_LATENCY_PER_FRAME_CONTROL:
                    msg = "PER_FRAME_CONTROL";
                    ret = 0;
                    break;
                case ANDROID_SYNC_MAX_LATENCY_UNKNOWN:
                    msg = "UNKNOWN";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

    }

    strncpy(dst, msg, size - 1);
    dst[size - 1] = '\0';

    return ret;
}


#define CAMERA_METADATA_ENUM_STRING_MAX_SIZE 24
