{ nixpkgs ? import <nixpkgs> {} }:
let
  pkgs = nixpkgs.pkgs;
  eggs = import ./eggs.nix {
    inherit pkgs;
    stdenv = pkgs.stdenv;
  };
in pkgs.stdenv.mkDerivation {
  name = "movelist";
  version = "0.0.1";

  buildInputs = [
    pkgs.chicken
  ] ++ (with eggs; [
    matchable mini-kanren
  ]);

  src = ./.;

  buildPhase = ''
    csc -static -O3 -o movelist movelist.scm
  '';

  installPhase = ''
    mkdir -p $out/bin/
    cp movelist $out/bin/
  '';
}
