import os

from rpython.rlib.rfile import create_fdopen_rfile

from cammylib.parser import parse

jelly_path = os.environ["JELLY_PATH"]

def jellify(sexp):
    """
    Optimize a Cammy expression.
    """

    rin, win = os.pipe()
    rout, wout = os.pipe()
    # NB: We must close all four pipe FDs in both processes.
    pid = os.fork()
    if pid:
        os.close(rin)
        with create_fdopen_rfile(win, mode="w") as handle:
            handle.write(sexp.asStr())
        os.close(wout)
        with create_fdopen_rfile(rout, mode="r") as handle:
            # NB: jelly doesn't return a trail.
            return parse(handle.read())[0]
    else:
        os.dup2(rin, 0)
        os.dup2(wout, 1)
        os.close(rin)
        os.close(win)
        os.close(rout)
        os.close(wout)
        os.execv(jelly_path, ["jelly"])
