from ctypes import util

ctypes_is_patched = False

def patch_ctypes_for_ffi():
    """
    Monkey-patch the stdlib so that ctypes uses the generic name for libc
    instead of a full path. This is required to make rffi work.

    This code was borrowed from Typhon.

    NOT_RPYTHON
    """

    global ctypes_is_patched
    if ctypes_is_patched:
        return
    ctypes_is_patched = True

    fl = util.find_library
    def patched_find_library(name):
        if name == "c":
            return "libc.so.6"
        else:
            return fl(name)
    util.find_library = patched_find_library
