/*
 * $Id: Array.h,v 1.4 2007-08-18 08:52:18 maya Exp $
 */

#ifndef _YCL_ARRAY_H_
#define _YCL_ARRAY_H_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <YCL/common.h>

#include <YCL/Object.h>

namespace yebisuya {

// zǗNX
template<class TYPE>
class Array : public Object {
private:
	// z̎
	TYPE*const array;
	// Zq͎Ȃ
	void operator=(Array&);
public:
	// z̒
	const int length;
	// RXgN^
	Array(int length):array(new TYPE[length]), length(length) {
	}
	Array(const TYPE source[], int length):array(new TYPE[length]), length(length) {
		copyFrom(source);
	}
	Array(Array* source):array(new TYPE[source->length]), length(source->length) {
		copyFrom(source);
	}
protected:
	virtual ~Array() {
		delete[] array;
	}
public:
	// zvfZq(p)
	TYPE& operator[](int index) {
		return array[index];
	}
	// zvfZq(QƗp)
	TYPE operator[](int index)const {
		return array[index];
	}
	void copyFrom(const TYPE source[]) {
		for (int i = 0; i < length; i++) {
			array[i] = source[i];
		}
	}
	void copyFrom(Array* source) {
		copy(source->array[i]);
	}
	void copyTo(TYPE distination[])const {
		for (int i = 0; i < length; i++) {
			distination[i] = array[i];
		}
	}
	void copyTo(Array* distination)const {
		copyTo(distination->array[i]);
	}
};

}

#endif//_YCL_ARRAY_H_
