#define		STRICT
static char *Registry_id = 
	"@(#)Copyright (C) NTT-IT 1998  -- registry.cpp --  Ver1.00b1";
/* ==========================================================================
	Project Name		: Universal Library
	Outline				: Registory Function
	Create				: 1998-02-17(Tue)
	Update				: 
	Copyright			: S.Hayakawa				NTT-IT
	Reference			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
#include	"registry.h"


/* ==========================================================================
	Function Name	: (HKEY) RegCreate()
	Outline			: w肵WXgL[쐬i܂̓I[vj
	Arguments		: HKEY		hCurrentKey		(in)	݂̃I[vL[
					: LPCTSTR	lpszKeyName		(in)	I[vTuL[
					: 									O
	Return Value	: 	I[v܂͍쐬ꂽL[̃nh
					: s	NULL
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
HKEY RegCreate(HKEY hCurrentKey, LPCTSTR lpszKeyName)
{
	long	lError;
	HKEY	hkResult;
	DWORD	dwDisposition;

	lError = ::RegCreateKeyEx(hCurrentKey,
							lpszKeyName,
							0,
							NULL,
							REG_OPTION_NON_VOLATILE,
							KEY_ALL_ACCESS,
							NULL,
							&hkResult,
							&dwDisposition);
	if (lError != ERROR_SUCCESS) {
		::SetLastError(lError);
		return (HKEY) INVALID_HANDLE_VALUE;
	}

	return hkResult;
}

/* ==========================================================================
	Function Name	: (HKEY) RegOpen()
	Outline			: w肵WXgL[I[v
	Arguments		: HKEY		hCurrentKey		(in)	݂̃I[vL[
					: LPCTSTR	lpszKeyName		(in)	I[vTuL[
					: 									O
	Return Value	: 	I[v܂͍쐬ꂽL[̃nh
					: s	NULL
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
HKEY RegOpen(HKEY hCurrentKey, LPCTSTR lpszKeyName)
{
	long	lError;
	HKEY	hkResult;

	lError = ::RegOpenKeyEx(hCurrentKey,
							lpszKeyName,
							0,
							KEY_ALL_ACCESS,
							&hkResult);
	if (lError != ERROR_SUCCESS) {
		::SetLastError(lError);
		return (HKEY) INVALID_HANDLE_VALUE;
	}

	return hkResult;
}

/* ==========================================================================
	Function Name	: (BOOL) RegClose()
	Outline			: w肵WXgL[N[Y
	Arguments		: HKEY		hKey			(in)	N[YL[̃nh
	Return Value	: 	TRUE
					: s	FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL RegClose(HKEY hKey)
{
	long	lError;

	lError = ::RegCloseKey(hKey);
	if (lError != ERROR_SUCCESS) {
		::SetLastError(lError);
		return FALSE;
	}

	return TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) RegSetStr()
	Outline			: WXgL[̒lɕ
	Arguments		: HKEY		hKey			(in)	lݒ肷L[̃nh
					: LPCTSTR	lpszValueName	(in)	ݒ肷l
					: char		*buf			(in)	lf[^
	Return Value	: 	TRUE
					: s	FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL RegSetStr(HKEY hKey, LPCTSTR lpszValueName, TCHAR *buf)
{
	long	lError;

	lError = ::RegSetValueEx(hKey,
							lpszValueName,
							0,
							REG_SZ,
							(CONST BYTE *) buf,
							(::lstrlen(buf) + 1) * sizeof(TCHAR));
	if (lError != ERROR_SUCCESS) {
		::SetLastError(lError);
		return FALSE;
	}

	return TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) RegGetStr()
	Outline			: WXgL[̒l當ǂݍ
	Arguments		: HKEY		hKey			(in)		lݒ肷L[
					: 										nh
					: LPCTSTR	lpszValueName	(in)		ݒ肷l
					: char		*buf			(out)		lf[^i[
					: 										obt@
					: DWORD		dwSize			(in/out)	
	Return Value	: 	TRUE
					: s	FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL RegGetStr(HKEY hKey, LPCTSTR lpszValueName, TCHAR *buf, DWORD dwSize)
{
	LONG	lError;
	DWORD	dwWriteSize;
	DWORD	dwType = REG_SZ;

	dwWriteSize = dwSize * sizeof(TCHAR);

	lError = ::RegQueryValueEx(hKey, lpszValueName, 0, &dwType, (LPBYTE) buf, &dwWriteSize);
	if (lError != ERROR_SUCCESS) {
		::SetLastError(lError);
		return FALSE;
	}

	buf[dwSize - 1] = '\0';

	return TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) RegSetDword()
	Outline			: WXgL[̒l DWORD
	Arguments		: HKEY		hKey			(in)	lݒ肷L[̃nh
					: LPCTSTR	lpszValueName	(in)	ݒ肷l
					: DWORD		dwValue			(in)	lf[^
	Return Value	: 	TRUE
					: s	FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL RegSetDword(HKEY hKey, LPCTSTR lpszValueName, DWORD dwValue)
{
	long	lError;

	lError = ::RegSetValueEx(hKey,
							lpszValueName,
							0,
							REG_DWORD,
							(CONST BYTE *) &dwValue,
							sizeof(DWORD));
	if (lError != ERROR_SUCCESS) {
		::SetLastError(lError);
		return FALSE;
	}

	return TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) RegGetDword()
	Outline			: WXgL[̒l DWORDǂݍ
	Arguments		: HKEY		hKey			(in)	lݒ肷L[̃nh
					: LPCTSTR	lpszValueName	(in)	ݒ肷l
					: DWORD		*dwValue		(out)	lf[^
	Return Value	: 	TRUE
					: s	FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL RegGetDword(HKEY hKey, LPCTSTR lpszValueName, DWORD *dwValue)
{
	long	lError;
	DWORD	dwType = REG_DWORD;
	DWORD	dwSize = sizeof(DWORD);

	lError = ::RegQueryValueEx(hKey,
								lpszValueName,
								0,
								&dwType,
								(LPBYTE) dwValue,
								&dwSize);
	if (lError != ERROR_SUCCESS) {
		::SetLastError(lError);
		return FALSE;
	}

	return TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) RegSetBinary()
	Outline			: WXgL[̒l BINARYǂݍ
	Arguments		: HKEY		hKey			(in)	lݒ肷L[̃nh
					: LPCTSTR	lpszValueName	(in)	ݒ肷l
					: void		*buf			(out)	lf[^
	Return Value	: 	TRUE
					: s	FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL RegSetBinary(HKEY hKey, LPCTSTR lpszValueName, void *buf, DWORD dwSize)
{
	long	lError;
	DWORD	dwWriteSize;

	dwWriteSize = dwSize * sizeof(TCHAR);

	if ((lError = ::RegSetValueEx(hKey,
								lpszValueName,
								0,
								REG_BINARY,
								(CONST BYTE *) buf,
								dwWriteSize)) != ERROR_SUCCESS) {
		::SetLastError(lError);
		return FALSE;
	}

	return TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) RegGetBinary()
	Outline			: WXgL[̒l BINARYǂݍ
	Arguments		: HKEY		hKey			(in)	lݒ肷L[̃nh
					: LPCTSTR	lpszValueName	(in)	ݒ肷l
					: int		*buf			(out)	lf[^
	Return Value	: 	TRUE
					: s	FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
RegGetBinary(HKEY hKey, LPCTSTR lpszValueName, void *buf, LPDWORD lpdwSize)
{
	long	lError;
	DWORD	dwType = REG_BINARY;
	DWORD	dwWriteSize;

	dwWriteSize = *lpdwSize * sizeof(TCHAR);

	if ((lError = ::RegQueryValueEx(hKey,
									lpszValueName,
									NULL,
									&dwType,
									(LPBYTE) buf,
									&dwWriteSize)) != ERROR_SUCCESS) {
		::SetLastError(lError);
		return FALSE;
	}

	return TRUE;
}
