#define		STRICT
static char *WinMisc_id = 
	"@(#)Copyright (C) NTT-IT 1998-2002  -- winmisc.cpp --  Ver1.00b2";
/* ==========================================================================
	Project Name		: Universal Library
	Outline				: WinMisc Function
	Create				: 1998-02-20(Wed)
	Update				: 2002-09-25(Wed)
	Copyright			: S.Hayakawa				NTT-IT
	Reference			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
#include	"winmisc.h"


/* ==========================================================================
	Function Name	: (void) SetDlgPos()
	Outline			: _CAÖʒuړ
	Arguments		: HWND		hWnd	(in)	_CAÕEChEnh
					: int		pos		(in)	ړꏊl
	Return Value	: Ȃ
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
void SetDlgPos(HWND hWnd, int pos)
{
	int		x;
	int		y;
	RECT	rect;

	::GetWindowRect(hWnd, &rect);

	int	cx		= ::GetSystemMetrics(SM_CXFULLSCREEN);
	int	cy		= ::GetSystemMetrics(SM_CYFULLSCREEN);
	int	xsize	= rect.right - rect.left;
	int	ysize	= rect.bottom - rect.top;

	switch (pos) {
	case POSITION_LEFTTOP:
		x = 0;
		y = 0;
		break;
	case POSITION_LEFTBOTTOM:
		x = 0;
		y = cy - ysize;
		break;
	case POSITION_RIGHTTOP:
		x = cx - xsize;
		y = 0;
		break;
	case POSITION_RIGHTBOTTOM:
		x = cx - xsize;
		y = cy - ysize;
		break;
	case POSITION_CENTER:
		x = (cx - xsize) / 2;
		y = (cy - ysize) / 2;
		break;
	case POSITION_OUTSIDE:
		x = cx;
		y = cy;
		break;
	}

	::MoveWindow(hWnd, x, y, xsize, ysize, TRUE);
}

/* ==========================================================================
	Function Name	: (BOOL) EnableItem()
	Outline			: _CAOACeL^ɂ
	Arguments		: HWND		hWnd		(in)	_CAÕnh
					: int		idControl	(in)	_CAOACe ID
					: BOOL		flag
	Return Value	:  TRUE
					: s FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL EnableItem(HWND hWnd, int idControl, BOOL flag)
{
	HWND	hWndItem;

	if ((hWndItem = ::GetDlgItem(hWnd, idControl)) == NULL)
		return FALSE;

	return ::EnableWindow(hWndItem, flag);
}

/* ==========================================================================
	Function Name	: (void) EncodePassword()
	Outline			: pX[hGR[h(?)B
	Arguments		: char		cPassword		(in)	ϊ镶
					: int		cEncodePassword	(out)	ϊꂽ
	Return Value	: Ȃ
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
void EncodePassword(TCHAR *cPassword, TCHAR *cEncodePassword)
{
	DWORD	dwCnt;
	DWORD	dwPasswordLength = ::lstrlen(cPassword);

	for (dwCnt = 0; dwCnt < dwPasswordLength; dwCnt++)
		cEncodePassword[dwPasswordLength - 1 - dwCnt] = cPassword[dwCnt] ^ 0xff;

	cEncodePassword[dwPasswordLength] = '\0';
}

/* ==========================================================================
	Function Name	: (void) GetTime()
	Outline			: \킷擾B
	Arguments		: char		cTimeStr		(out)	\킷
	Return Value	: Ȃ
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
void GetTime(TCHAR *cTimeStr)
{
	time_t		tTime;

	time(&tTime);
	::wsprintf(cTimeStr, _T("%s"), _tctime(&tTime));
	cTimeStr[::lstrlen(cTimeStr) - 1] = '\0';
}

/* ==========================================================================
	Function Name	: (void) GetTimeEx()
	Outline			: \킷擾B
	Arguments		: LPTSTR	lpszTimeStr		(out)	\킷
	Return Value	: Ȃ
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
void GetTimeEx(LPTSTR lpszTimeStr)
{
	TCHAR		cWeek[MAX_PATH];
	SYSTEMTIME	LocalTime;

	::GetLocalTime(&LocalTime);

	switch(LocalTime.wDayOfWeek) {
	case 0:
		lstrcpy(cWeek, _T("j"));
		break;
	case 1:
		lstrcpy(cWeek, _T("j"));
		break;
	case 2:
		lstrcpy(cWeek, _T("Ηj"));
		break;
	case 3:
		lstrcpy(cWeek, _T("j"));
		break;
	case 4:
		lstrcpy(cWeek, _T("ؗj"));
		break;
	case 5:
		lstrcpy(cWeek, _T("j"));
		break;
	case 6:
		lstrcpy(cWeek, _T("yj"));
		break;
	}

	::wsprintf(lpszTimeStr, _T("%uN %u%u%s %u%u%ub%u"),
							LocalTime.wYear,
							LocalTime.wMonth,
							LocalTime.wDay,
							cWeek,
							LocalTime.wHour,
							LocalTime.wMinute,
							LocalTime.wSecond,
							LocalTime.wMilliseconds);
}

/* ==========================================================================
	Function Name	: (BOOL) SaveFileDlg()
	Outline			: uOw肵ĕۑv_CAOJAw肳ꂽt@C
					: pXw肳ꂽACeɑ
	Arguments		: HWND		hWnd		(in)	eEChẼnh
					: UINT		editCtl		(in)	ACe ID
					: char		*title		(in)	EChE^Cg
					: char		*filter		(in)	\t@C̃tB^
					: char		*defaultDir	(in)	ftHg̃pX
	Return Value	:  TRUE
					: s FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL SaveFileDlg(HWND hWnd, UINT editCtl, TCHAR *title, TCHAR *filter, TCHAR *defaultDir)
{
	TCHAR			*szDirName;
	TCHAR			szFile[MAX_PATH] = _T("");
	TCHAR			szPath[MAX_PATH];
	OPENFILENAME	ofn;

	szDirName	= (TCHAR *) malloc(MAX_PATH);

	if (editCtl == 0xffffffff) {
		::GetDlgItemText(hWnd, editCtl, szDirName, MAX_PATH);
		::lstrcpy(szDirName, defaultDir);
	}

	if (*szDirName == '"')
		szDirName++;
	if (szDirName[::lstrlen(szDirName) - 1] == '"')
		szDirName[::lstrlen(szDirName) - 1] = '\0';

	TCHAR *ptr = _tcsrchr(szDirName, '\\');
	if (ptr == NULL) {
		::lstrcpy(szFile, szDirName);
		if (defaultDir != NULL && *szDirName == 0)
			::lstrcpy(szDirName, defaultDir);
	} else {
		*ptr = 0;
		::lstrcpy(szFile, ptr + 1);
	}

	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= hWnd;
	ofn.lpstrFilter		= filter;
	ofn.nFilterIndex	= 1;
	ofn.lpstrFile		= szFile;
	ofn.nMaxFile		= sizeof(szFile);
	ofn.lpstrTitle		= title;
	ofn.lpstrInitialDir	= szDirName;
	ofn.Flags			= OFN_HIDEREADONLY;

	if (::GetSaveFileName(&ofn) == FALSE) {
		free(szDirName);
		return	FALSE;
	}

	::lstrcpy(szPath, ofn.lpstrFile);

	::SetDlgItemText(hWnd, editCtl, szPath);
	::lstrcpy(defaultDir, szPath);

	free(szDirName);

	return	TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) OpenFileDlg()
	Outline			: ut@CJv_CAOJAw肳ꂽt@C
					: pXw肳ꂽACeɑ
	Arguments		: HWND		hWnd		(in)	eEChẼnh
					: UINT		editCtl		(in)	ACe ID
					: char		*title		(in)	EChE^Cg
					: char		*filter		(in)	\t@C̃tB^
					: char		*defaultDir	(in)	ftHg̃pX
	Return Value	:  TRUE
					: s FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL OpenFileDlg(HWND hWnd, UINT editCtl, TCHAR *title, TCHAR *filter, TCHAR *defaultDir)
{
	TCHAR			*szDirName;
	TCHAR			szFile[MAX_PATH] = _T("");
	TCHAR			szPath[MAX_PATH];
	OPENFILENAME	ofn;

	szDirName	= (TCHAR *) malloc(MAX_PATH);

	if (editCtl != 0xffffffff) {
		::GetDlgItemText(hWnd, editCtl, szDirName, MAX_PATH);
		::lstrcpy(szDirName, defaultDir);
	}

	if (*szDirName == '"')
		szDirName++;
	if (szDirName[::lstrlen(szDirName) - 1] == '"')
		szDirName[::lstrlen(szDirName) - 1] = '\0';

	TCHAR *ptr = _tcsrchr(szDirName, '\\');
	if (ptr == NULL) {
		::lstrcpy(szFile, szDirName);
		if (defaultDir != NULL && *szDirName == 0)
			::lstrcpy(szDirName, defaultDir);
	} else {
		*ptr = 0;
		::lstrcpy(szFile, ptr + 1);
	}

	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= hWnd;
	ofn.lpstrFilter		= filter;
	ofn.nFilterIndex	= 1;
	ofn.lpstrFile		= szFile;
	ofn.nMaxFile		= sizeof(szFile);
	ofn.lpstrTitle		= title;
	ofn.lpstrInitialDir	= szDirName;
	ofn.Flags			= OFN_HIDEREADONLY | OFN_NODEREFERENCELINKS;

	if (::GetOpenFileName(&ofn) == FALSE) {
		free(szDirName);
		return	FALSE;
	}

	::lstrcpy(szPath, ofn.lpstrFile);

	::SetDlgItemText(hWnd, editCtl, szPath);
	::lstrcpy(defaultDir, szPath);

	free(szDirName);

	return	TRUE;
}

/* ==========================================================================
	Function Name	: (BOOL) BrowseForFolder()
	Outline			: tH_QƂ_CAOJB
	Arguments		: HWND		hWnd		(in)		eEChẼnh
					: char		*szTitle	(in)		EChE^Cg
					: char		*szPath		(in/out)	pX
	Return Value	:  TRUE
					: s FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL BrowseForFolder(HWND hWnd, TCHAR *szTitle, TCHAR *szPath)
{
	BOOL			bRet = TRUE;
	LPMALLOC		pMalloc;
	BROWSEINFO		bi;
	LPCITEMIDLIST	itemDList;

	bi.pszDisplayName	= (TCHAR *) malloc(MAX_PATH);
	bi.lpszTitle		= (TCHAR *) malloc(MAX_PATH);

	bi.hwndOwner	= NULL;
	bi.pidlRoot		= NULL;
	::lstrcpy((TCHAR *) bi.lpszTitle, szTitle);
	bi.ulFlags		= 0;
	bi.lpfn			= BrowseCallbackProc;
	bi.lParam		= (LPARAM) szPath;
	bi.iImage		= NULL;

	if ((itemDList = ::SHBrowseForFolder(&bi)) == NULL) {
		bRet = FALSE;	
		goto END;
	}

	if (::SHGetPathFromIDList(itemDList, szPath) == FALSE) {
		bRet = FALSE;
		::MessageBox(hWnd, _T("w肳ꂽpX͖łB"), szTitle, MB_ICONSTOP | MB_OK);
		goto END;
	}

END:
	if (SUCCEEDED(::SHGetMalloc(&pMalloc)))
		pMalloc->Free((void *) itemDList);
	free(bi.pszDisplayName);
	free((void *) bi.lpszTitle);

	return bRet;
}

/* ==========================================================================
	Function Name	: (int CALLBACK) BrowseCallbackProc()
	Outline			: BrowseForFolder()̃R[obN֐B
	Arguments		: HWND		hWnd		(in)	eEChẼnh
					: UINT		uMsg		(in)	EChE^Cg
					: LPARAM	lParam		(in)	LPARAM
					: LPARAM	lpData		(in)	BROWSEINFO  lParam
	Return Value	: 
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
int CALLBACK BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
    switch (uMsg) {
    case BFFM_INITIALIZED:
		::SendMessage(hWnd, BFFM_SETSELECTION, TRUE, lpData);
		break;
    case BFFM_SELCHANGED:
		break;
    }

    return 0;
}

/* ==========================================================================
	Function Name	: (BOOL) GetModulePath()
	Outline			: ̊֐sW[̃pX擾B
	Arguments		: char		szPath		(out)	W[̃pX
					: DWORD		dwMaxPath	(in)	szPath̑傫
	Return Value	:  TRUE
					: s FALSE
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
BOOL GetModulePath(TCHAR *szPath, DWORD dwMaxPath)
{
	TCHAR	*pt;

	if (::GetModuleFileName(NULL, szPath, dwMaxPath) == FALSE)
		return FALSE;

	pt	= _tcsrchr(szPath, '\\');
	*pt	= '\0';

	return TRUE;
}

/* ==========================================================================
	Function Name	: (UINT) GetResourceType()
	Outline			: w肳ꂽpX̃hCu擾
	Arguments		: LPCTSTR	lpszPath	(in)	hCum肽pX
	Return Value	: \[X^Cv
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
UINT GetResourceType(LPCTSTR lpszPath)
{
	UINT	ret;
	TCHAR	szCurrentPath[MAX_PATH];

	if (::GetCurrentDirectory(MAX_PATH, szCurrentPath) == 0)
		return 0;

	if (::SetCurrentDirectory(lpszPath) == FALSE)
		return 0;

	ret = ::GetDriveType(NULL);

	::SetCurrentDirectory(szCurrentPath);

	return ret;
}

/* ==========================================================================
	Function Name	: (char *) pathTok()
	Outline			: pXp strtok
	Arguments		: char		*str		(in)	g[N͂pX
					: char		*separator	(in)	g[N
	Return Value	:  ؂o
					: s NULL
	Reference		: 
	Renewal			: 
	Notes			: 
	Attention		: 
	Up Date			: 
   ======1=========2=========3=========4=========5=========6=========7======= */
TCHAR *PathTok(TCHAR *str, TCHAR *separator)
{
	static TCHAR	*sv_str;

	if (str != NULL)
		sv_str = str;
	else if (sv_str != NULL)
		str = sv_str;
	else
		return	NULL;

	while (*str != '\0' && _tcschr(separator, *str) != NULL)
		str++;

 	if (*str == '\"') {
		for (sv_str = ++str; *sv_str != '\0' && *sv_str != '\"'; sv_str++) 
			;
		*sv_str++ = '\0';
	} else {
		for (sv_str=str ; *sv_str != '\0'; sv_str++) {
			if (_tcschr(separator, *sv_str) != NULL) {
				*sv_str++ = '\0';
				break;
			}
		}
	}
	if (sv_str != str)
		return	str;
	else
		return	sv_str = NULL;
}

TCHAR *lstrstri(TCHAR *s1, TCHAR *s2)
{
	DWORD	dwLen1= ::lstrlen(s1);
	DWORD	dwLen2= ::lstrlen(s2);

	for (DWORD dwCnt = 0; dwCnt <= dwLen1; dwCnt++) {
		// VS2005ŃrhG[ƂȂ邽 dwCnt2 錾ǉ (2006.2.18 yutaka)
		DWORD dwCnt2;
		for (dwCnt2 = 0; dwCnt2 <= dwLen2; dwCnt2++)
			if (tolower(s1[dwCnt + dwCnt2]) != tolower(s2[dwCnt2]))
				break;
		if (dwCnt2 > dwLen2)
			return s1 + dwCnt;
	}

	return NULL;
}

BOOL SetForceForegroundWindow(HWND hWnd)
{
#ifndef SPI_GETFOREGROUNDLOCKTIMEOUT
#define SPI_GETFOREGROUNDLOCKTIMEOUT 0x2000
#define SPI_SETFOREGROUNDLOCKTIMEOUT 0x2001
#endif
	DWORD	foreId, targId, svTmOut;

	foreId = ::GetWindowThreadProcessId(::GetForegroundWindow(), NULL);
	targId = ::GetWindowThreadProcessId(hWnd, NULL);
	::AttachThreadInput(targId, foreId, TRUE);
	::SystemParametersInfo(SPI_GETFOREGROUNDLOCKTIMEOUT, 0, (void *)&svTmOut, 0);
	::SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, 0, 0);
	BOOL	ret = ::SetForegroundWindow(hWnd);
	::SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, (void *)svTmOut, 0);
	::AttachThreadInput(targId, foreId, FALSE);

	return	ret;
}

