
/* Drop Tables */

DROP TABLE IF EXISTS DEPARTMENT_PERSON;
DROP TABLE IF EXISTS DEPARTMENT;
DROP TABLE IF EXISTS PERSON;
DROP TABLE IF EXISTS COLUMN_SETTING;
DROP TABLE IF EXISTS COLUMN_MASTER;
DROP TABLE IF EXISTS HOLIDAY;
DROP TABLE IF EXISTS ACCOUNT_STRUCTURE;
DROP TABLE IF EXISTS PARTNER_PART;
DROP TABLE IF EXISTS ACCOUNT_PART;
DROP TABLE IF EXISTS PART;
DROP TABLE IF EXISTS BUDGET;
DROP TABLE IF EXISTS ACCOUNT;
DROP TABLE IF EXISTS DEALING_SCHEDULE;
DROP TABLE IF EXISTS JOURNAL;
DROP TABLE IF EXISTS DEALING;
DROP TABLE IF EXISTS PARTNER;




/* Create Tables */

CREATE TABLE DEPARTMENT
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	DEPARTMENT_NUMBER VARCHAR,
	-- editable
	NAME VARCHAR NOT NULL,
	-- editable,person
	PERSON VARCHAR,
	-- editable
	POSTAL_CODE CHAR(8),
	-- editable
	ADDRESS VARCHAR,
	-- editable
	PHONE_NUMBER VARCHAR,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE DEPARTMENT_PERSON
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- hidden
	LEFT_IDENTIFICATION INT NOT NULL,
	-- hidden
	RIGHT_IDENTIFICATION INT NOT NULL,
	-- hidden
	STRUCT_ORDER INT,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE PERSON
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- editable
	PERSON_NUMBER VARCHAR NOT NULL,
	-- editable
	PASSWORD VARCHAR,
	-- editable
	NAME VARCHAR NOT NULL,
	-- editable
	POSTAL_CODE CHAR(8),
	-- editable
	ADDRESS VARCHAR,
	-- editable
	PHONE_NUMBER VARCHAR,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE COLUMN_MASTER
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	TABLE_VIEW_NAME VARCHAR NOT NULL,
	TABLE_ID VARCHAR NOT NULL,
	COLUMN_VIEW_NAME VARCHAR NOT NULL,
	COLUMN_ID VARCHAR NOT NULL,
	COLUMN_TYPE VARCHAR NOT NULL,
	COLUMN_LENGTH INT,
	COLUMN_DISPLAY BOOLEAN DEFAULT 'true',
	COLUMN_EDITABLE BOOLEAN DEFAULT 'false',
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE HOLIDAY
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- editable
	NAME VARCHAR,
	-- editable
	TARGET_DATE VARCHAR,
	-- editable
	APPLICATION_START_DATE DATE,
	-- editable
	APPLICATION_FINISH_DATE DATE,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE ACCOUNT_STRUCTURE
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- hidden
	UPPER_IDENTIFICATION INT NOT NULL,
	-- hidden
	LOWER_IDENTIFICATION INT NOT NULL,
	-- hidden
	STRUCT_ORDER INT,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE PART
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	PART_NUMBER VARCHAR,
	-- editable
	NAME VARCHAR NOT NULL,
	-- editable
	TRADE_NAME VARCHAR,
	-- editable
	UNIT VARCHAR,
	-- editable
	PRICE INT,
	AMOUNT INT,
	-- editable
	TAX_INCLUSIVE BOOLEAN NOT NULL,
	-- editable
	PAY_PER BOOLEAN NOT NULL,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE BUDGET
(
	IDENTIFICATION SERIAL NOT NULL,
	ACCOUNT_NUMBER VARCHAR NOT NULL,
	DEPARTMENT_NUMBER VARCHAR,
	START_DATE DATE,
	FINISH_DATE DATE,
	AMOUNT INT,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE PARTNER_PART
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- hidden
	LEFT_IDENTIFICATION INT NOT NULL,
	-- hidden
	RIGHT_IDENTIFICATION INT NOT NULL,
	-- hidden
	STRUCT_ORDER INT,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE ACCOUNT_PART
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- hidden
	LEFT_IDENTIFICATION INT NOT NULL,
	-- hidden
	RIGHT_IDENTIFICATION INT NOT NULL,
	-- hidden
	STRUCT_ORDER INT,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE ACCOUNT
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	ACCOUNT_NUMBER VARCHAR NOT NULL,
	-- editable
	NAME VARCHAR NOT NULL,
	-- editable
	AMOUNT INT DEFAULT 0 NOT NULL,
	-- editable
	CONSUMPTION_TAX_RATE INT DEFAULT 8.0 NOT NULL,
	-- hidden
	ACCOUNT_TYPE VARCHAR NOT NULL,
	-- hidden
	DEBIT_CREDIT_TYPE VARCHAR NOT NULL,
	-- hidden
	BP_TYPE VARCHAR NOT NULL,
	-- hidden
	TOP_ACCOUNT BOOLEAN DEFAULT 'false' NOT NULL,
	-- hidden
	HAS_ACCOUNT BOOLEAN DEFAULT 'false' NOT NULL,
	DEPARTMENT_NUMBER VARCHAR,
	-- editable
	DISPLAY BOOLEAN DEFAULT 'true' NOT NULL,
	-- hidden
	SYSTEM_FLAG BOOLEAN DEFAULT 'false' NOT NULL,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE DEALING_SCHEDULE
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- editable
	APPLICATION_START_DATE DATE,
	-- editable
	APPLICATION_FINISH_DATE DATE,
	CREDIT_ACCOUNT_NUMBER VARCHAR,
	DEBIT_ACCOUNT_NUMBER VARCHAR,
	PART_NUMBER VARCHAR,
	-- editable
	PRICE INT,
	-- editable
	QUANTITY DOUBLE PRECISION,
	-- editable
	AMOUNT INT,
	PARTNER_NUMBER VARCHAR,
	-- editable
	DUE_DATE INT,
	-- editable
	HOLIDAY_CORRESPONDENCE INT,
	-- editable
	NEXT_DUE_DATE DATE,
	-- editable
	PAYMENT_MONTH INT,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE DEALING
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- editable
	DEALING_DATE DATE NOT NULL,
	-- editable
	DEALING_TIME TIME,
	PARTNER_NUMBER VARCHAR,
	-- editable
	PERSON VARCHAR,
	-- hidden
	TEMPLATE_FLAG BOOLEAN DEFAULT 'false' NOT NULL,
	DEPARTMENT_NUMBER VARCHAR,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE COLUMN_SETTING
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- hidden
	SUPER_IDENTIFICATION INT NOT NULL,
	-- editable
	PERSON_NUMBER VARCHAR,
	-- editable
	DISPLAY BOOLEAN,
	-- hidden
	STRUCT_ORDER INT,
	WITDH INT,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE JOURNAL
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	-- hidden
	SUPER_IDENTIFICATION INT NOT NULL,
	-- hidden
	DEBIT_CREDIT_TYPE VARCHAR NOT NULL,
	ACCOUNT_NUMBER VARCHAR NOT NULL,
	ACCOUNT_NAME VARCHAR,
	PART_NUMBER VARCHAR,
	-- editable
	PART_NAME VARCHAR,
	-- editable
	TRADE_NAME VARCHAR,
	-- editable
	PRICE INT DEFAULT 0 NOT NULL,
	-- editable
	QUANTITY DOUBLE PRECISION DEFAULT 1 NOT NULL,
	-- editable
	UNIT VARCHAR,
	-- editable
	DISCOUNT INT DEFAULT 0 NOT NULL,
	-- editable
	AMOUNT INT DEFAULT 0 NOT NULL,
	-- hidden
	STRUCT_ORDER INT,
	-- hidden
	TEMPLATE_FLAG BOOLEAN DEFAULT 'false' NOT NULL,
	DEPARTMENT_NUMBER VARCHAR,
	CREATE_DATE TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;


CREATE TABLE PARTNER
(
	-- hidden
	IDENTIFICATION SERIAL NOT NULL,
	PARTNER_NUMBER VARCHAR NOT NULL UNIQUE,
	-- editable
	NAME VARCHAR NOT NULL,
	-- editable
	NAME_KANA VARCHAR,
	-- editable
	CATEGORY VARCHAR,
	-- editable
	POSTAL_CODE CHAR(8),
	-- editable
	ADDRESS VARCHAR,
	-- editable
	PHONE_NUMBER VARCHAR,
	DEPARTMENT_NUMBER VARCHAR,
	CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	CREATE_PERSON VARCHAR,
	MODIFY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
	-- person
	MODIFY_PERSON VARCHAR,
	PRIMARY KEY (IDENTIFICATION)
) WITHOUT OIDS;



/* Create Foreign Keys */

ALTER TABLE DEPARTMENT_PERSON
	ADD FOREIGN KEY (LEFT_IDENTIFICATION)
	REFERENCES DEPARTMENT (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE DEPARTMENT_PERSON
	ADD FOREIGN KEY (RIGHT_IDENTIFICATION)
	REFERENCES PERSON (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE COLUMN_SETTING
	ADD FOREIGN KEY (SUPER_IDENTIFICATION)
	REFERENCES COLUMN_MASTER (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE PARTNER_PART
	ADD FOREIGN KEY (RIGHT_IDENTIFICATION)
	REFERENCES PART (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE ACCOUNT_PART
	ADD FOREIGN KEY (RIGHT_IDENTIFICATION)
	REFERENCES PART (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE ACCOUNT_STRUCTURE
	ADD FOREIGN KEY (UPPER_IDENTIFICATION)
	REFERENCES ACCOUNT (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE ACCOUNT_STRUCTURE
	ADD FOREIGN KEY (LOWER_IDENTIFICATION)
	REFERENCES ACCOUNT (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE ACCOUNT_PART
	ADD FOREIGN KEY (LEFT_IDENTIFICATION)
	REFERENCES ACCOUNT (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE JOURNAL
	ADD CONSTRAINT A FOREIGN KEY (SUPER_IDENTIFICATION)
	REFERENCES DEALING (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE PARTNER_PART
	ADD FOREIGN KEY (LEFT_IDENTIFICATION)
	REFERENCES PARTNER (IDENTIFICATION)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;



/* Comments */

COMMENT ON COLUMN DEPARTMENT.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN DEPARTMENT.NAME IS 'editable';
COMMENT ON COLUMN DEPARTMENT.PERSON IS 'editable,person';
COMMENT ON COLUMN DEPARTMENT.POSTAL_CODE IS 'editable';
COMMENT ON COLUMN DEPARTMENT.ADDRESS IS 'editable';
COMMENT ON COLUMN DEPARTMENT.PHONE_NUMBER IS 'editable';
COMMENT ON COLUMN DEPARTMENT.CREATE_PERSON IS 'person';
COMMENT ON COLUMN DEPARTMENT.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN DEPARTMENT_PERSON.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN DEPARTMENT_PERSON.LEFT_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN DEPARTMENT_PERSON.RIGHT_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN DEPARTMENT_PERSON.STRUCT_ORDER IS 'hidden';
COMMENT ON COLUMN DEPARTMENT_PERSON.CREATE_PERSON IS 'person';
COMMENT ON COLUMN DEPARTMENT_PERSON.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN PERSON.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN PERSON.PERSON_NUMBER IS 'editable';
COMMENT ON COLUMN PERSON.PASSWORD IS 'editable';
COMMENT ON COLUMN PERSON.NAME IS 'editable';
COMMENT ON COLUMN PERSON.POSTAL_CODE IS 'editable';
COMMENT ON COLUMN PERSON.ADDRESS IS 'editable';
COMMENT ON COLUMN PERSON.PHONE_NUMBER IS 'editable';
COMMENT ON COLUMN PERSON.CREATE_PERSON IS 'person';
COMMENT ON COLUMN PERSON.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN COLUMN_MASTER.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN COLUMN_MASTER.CREATE_PERSON IS 'person';
COMMENT ON COLUMN COLUMN_MASTER.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN HOLIDAY.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN HOLIDAY.NAME IS 'editable';
COMMENT ON COLUMN HOLIDAY.TARGET_DATE IS 'editable';
COMMENT ON COLUMN HOLIDAY.APPLICATION_START_DATE IS 'editable';
COMMENT ON COLUMN HOLIDAY.APPLICATION_FINISH_DATE IS 'editable';
COMMENT ON COLUMN HOLIDAY.CREATE_PERSON IS 'person';
COMMENT ON COLUMN HOLIDAY.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN ACCOUNT_STRUCTURE.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN ACCOUNT_STRUCTURE.UPPER_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN ACCOUNT_STRUCTURE.LOWER_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN ACCOUNT_STRUCTURE.STRUCT_ORDER IS 'hidden';
COMMENT ON COLUMN ACCOUNT_STRUCTURE.CREATE_PERSON IS 'person';
COMMENT ON COLUMN ACCOUNT_STRUCTURE.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN PART.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN PART.NAME IS 'editable';
COMMENT ON COLUMN PART.TRADE_NAME IS 'editable';
COMMENT ON COLUMN PART.UNIT IS 'editable';
COMMENT ON COLUMN PART.PRICE IS 'editable';
COMMENT ON COLUMN PART.TAX_INCLUSIVE IS 'editable';
COMMENT ON COLUMN PART.PAY_PER IS 'editable';
COMMENT ON COLUMN PART.CREATE_PERSON IS 'person';
COMMENT ON COLUMN PART.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN BUDGET.CREATE_PERSON IS 'person';
COMMENT ON COLUMN BUDGET.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN PARTNER_PART.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN PARTNER_PART.LEFT_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN PARTNER_PART.RIGHT_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN PARTNER_PART.STRUCT_ORDER IS 'hidden';
COMMENT ON COLUMN PARTNER_PART.CREATE_PERSON IS 'person';
COMMENT ON COLUMN PARTNER_PART.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN ACCOUNT_PART.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN ACCOUNT_PART.LEFT_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN ACCOUNT_PART.RIGHT_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN ACCOUNT_PART.STRUCT_ORDER IS 'hidden';
COMMENT ON COLUMN ACCOUNT_PART.CREATE_PERSON IS 'person';
COMMENT ON COLUMN ACCOUNT_PART.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN ACCOUNT.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN ACCOUNT.NAME IS 'editable';
COMMENT ON COLUMN ACCOUNT.AMOUNT IS 'editable';
COMMENT ON COLUMN ACCOUNT.CONSUMPTION_TAX_RATE IS 'editable';
COMMENT ON COLUMN ACCOUNT.ACCOUNT_TYPE IS 'hidden';
COMMENT ON COLUMN ACCOUNT.DEBIT_CREDIT_TYPE IS 'hidden';
COMMENT ON COLUMN ACCOUNT.BP_TYPE IS 'hidden';
COMMENT ON COLUMN ACCOUNT.TOP_ACCOUNT IS 'hidden';
COMMENT ON COLUMN ACCOUNT.HAS_ACCOUNT IS 'hidden';
COMMENT ON COLUMN ACCOUNT.DISPLAY IS 'editable';
COMMENT ON COLUMN ACCOUNT.SYSTEM_FLAG IS 'hidden';
COMMENT ON COLUMN ACCOUNT.CREATE_PERSON IS 'person';
COMMENT ON COLUMN ACCOUNT.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN DEALING_SCHEDULE.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN DEALING_SCHEDULE.APPLICATION_START_DATE IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.APPLICATION_FINISH_DATE IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.PRICE IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.QUANTITY IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.AMOUNT IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.DUE_DATE IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.HOLIDAY_CORRESPONDENCE IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.NEXT_DUE_DATE IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.PAYMENT_MONTH IS 'editable';
COMMENT ON COLUMN DEALING_SCHEDULE.CREATE_PERSON IS 'person';
COMMENT ON COLUMN DEALING_SCHEDULE.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN DEALING.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN DEALING.DEALING_DATE IS 'editable';
COMMENT ON COLUMN DEALING.DEALING_TIME IS 'editable';
COMMENT ON COLUMN DEALING.PERSON IS 'editable';
COMMENT ON COLUMN DEALING.TEMPLATE_FLAG IS 'hidden';
COMMENT ON COLUMN DEALING.CREATE_PERSON IS 'person';
COMMENT ON COLUMN DEALING.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN COLUMN_SETTING.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN COLUMN_SETTING.SUPER_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN COLUMN_SETTING.PERSON_NUMBER IS 'editable';
COMMENT ON COLUMN COLUMN_SETTING.DISPLAY IS 'editable';
COMMENT ON COLUMN COLUMN_SETTING.STRUCT_ORDER IS 'hidden';
COMMENT ON COLUMN COLUMN_SETTING.CREATE_PERSON IS 'person';
COMMENT ON COLUMN COLUMN_SETTING.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN JOURNAL.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN JOURNAL.SUPER_IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN JOURNAL.DEBIT_CREDIT_TYPE IS 'hidden';
COMMENT ON COLUMN JOURNAL.PART_NAME IS 'editable';
COMMENT ON COLUMN JOURNAL.TRADE_NAME IS 'editable';
COMMENT ON COLUMN JOURNAL.PRICE IS 'editable';
COMMENT ON COLUMN JOURNAL.QUANTITY IS 'editable';
COMMENT ON COLUMN JOURNAL.UNIT IS 'editable';
COMMENT ON COLUMN JOURNAL.DISCOUNT IS 'editable';
COMMENT ON COLUMN JOURNAL.AMOUNT IS 'editable';
COMMENT ON COLUMN JOURNAL.STRUCT_ORDER IS 'hidden';
COMMENT ON COLUMN JOURNAL.TEMPLATE_FLAG IS 'hidden';
COMMENT ON COLUMN JOURNAL.CREATE_PERSON IS 'person';
COMMENT ON COLUMN JOURNAL.MODIFY_PERSON IS 'person';
COMMENT ON COLUMN PARTNER.IDENTIFICATION IS 'hidden';
COMMENT ON COLUMN PARTNER.NAME IS 'editable';
COMMENT ON COLUMN PARTNER.NAME_KANA IS 'editable';
COMMENT ON COLUMN PARTNER.CATEGORY IS 'editable';
COMMENT ON COLUMN PARTNER.POSTAL_CODE IS 'editable';
COMMENT ON COLUMN PARTNER.ADDRESS IS 'editable';
COMMENT ON COLUMN PARTNER.PHONE_NUMBER IS 'editable';
COMMENT ON COLUMN PARTNER.CREATE_PERSON IS 'person';
COMMENT ON COLUMN PARTNER.MODIFY_PERSON IS 'person';



