package objectModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import model.Entity;
import model.NavigationItem;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Account extends Entity {

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public Account(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		super(db, keys,values, "ACCOUNT");
	}

	/**
	 *
	 * @return
	 */
	public String number() {
		return m_properties.get("ACCOUNT_NUMBER");
	}

	/**
	 *
	 * @param number
	 */
	public void number(String number) {
		m_properties.put("ACCOUNT_NUMBER", number);
	}

	/**
	 *
	 * @return
	 */
	public String hasAccount() {
		return m_properties.get("HAS_ACCOUNT");
	}

	/**
	 *
	 * @param account
	 * @param userid
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public AccountStructure appendChild(Account account) throws SQLException, ClassNotFoundException, IOException {

		ClassAccountStructure clsAccountStructure = new ClassAccountStructure(m_db);

		AccountStructure accountStructure = clsAccountStructure.create(this, account);

		setProperty("HAS_ACCOUNT", "true");

		return accountStructure;
	}

	/**
	 *
	 * @param account
	 * @param userid
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public AccountPart setAssociation(Part part, String userid) throws SQLException, ClassNotFoundException, IOException {

		ClassAccountPart clsAccountPart = new ClassAccountPart(m_db);

		AccountPart accountPart = clsAccountPart.create(this, part);

		return accountPart;
	}

	/**
	 *
	 * @param account
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigateChild(String level, ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"ACCOUNT_STRUCTURE", "ACCOUNT"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.UPPER_IDENTIFICATION = ? AND T1.LOWER_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate(level, strbTableNames, condition.toString(), inSortParams);
		return objects;
	}

	/**
	 *
	 * @param account
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigateParent(String level) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"ACCOUNT_STRUCTURE", "ACCOUNT"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.LOWER_IDENTIFICATION = ? AND T1.UPPER_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate(level, strbTableNames, condition.toString() , null);
		return objects;
	}

	/**
	 *
	 * @param account
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigatePart(ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"ACCOUNT_PART", "PART"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.LEFT_IDENTIFICATION = ? AND T1.RIGHT_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate("", strbTableNames, condition.toString(), inSortParams);
		return objects;
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public int delete() throws SQLException, ClassNotFoundException, IOException {

		int result = 0;

		//システム項目は削除不可
		String system_flag = "";
		system_flag = getProperty("SYSTEM_FLAG");
		if ( system_flag.equals("TRUE") ) {
			return -1;
		}

		//下位勘定科目がある場合は削除不可
		boolean hasAccount = Boolean.valueOf(getProperty("HAS_ACCOUNT"));
		if ( hasAccount ) {
			return -1;
		}

		//下位勘定科目削除
		ArrayList<NavigationItem> navigationChildItems = navigateChild("multi", null);
		Iterator<NavigationItem> itrNavigationChildItem = navigationChildItems.iterator();
		while (itrNavigationChildItem.hasNext()) {
			NavigationItem navigationItem = itrNavigationChildItem.next();

			//構成削除
			AccountStructure accountStructure = (AccountStructure) navigationItem.relation;
			result = accountStructure.delete();
			if ( result < 0 ) {
				return result;
			}

			//子勘定科目削除
			Account childAccount = (Account) navigationItem.destination;
			childAccount.delete();
			if ( result < 0 ) {
				return result;
			}
		}

		ArrayList<NavigationItem> navigationParentItems = navigateParent("single");
		Iterator<NavigationItem> itrNavigationParentItem = navigationParentItems.iterator();
		while (itrNavigationParentItem.hasNext()) {
			NavigationItem navigationItem = itrNavigationParentItem.next();

			//構成削除
			AccountStructure accountStructure = (AccountStructure) navigationItem.relation;
			result = accountStructure.delete();
			if ( result < 0 ) {
				return result;
			}

			//親勘定科目シングル展開
			Account parentAccount = (Account) navigationItem.destination;
			ArrayList<NavigationItem> navigationChildItems2 = parentAccount.navigateChild("single", null);
			if (navigationChildItems2.size() == 0) {
				parentAccount.setProperty("HAS_ACCOUNT", "false");
			}
		}

		//account_part削除
		String deleteCondition = "";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		deleteCondition = "left_identification = ?";
		conditionTypes.clear();
		conditionTypes.add("int");
		conditionValues.clear();
		conditionValues.add(identification());
		result = m_db.delete("ACCOUNT_PART", deleteCondition, conditionTypes, conditionValues);
		if ( result < 0 ) {
			return result;
		}

		//自身の削除
		result = super.delete();
		if ( result < 0 ) {
			return result;
		}

		return result;
	}

}
