package model;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import objectModel.AccountStructure;

import common.DBAccessWrapper;


/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassRelation extends ClassModelObject {

	/**
	 *
	 */
	public ClassRelation() {
	}

	/**
	 *
	 * @param db
	 */
	public ClassRelation(DBAccessWrapper db, String tableName) {
		super(db, tableName);
	}

	/**
	 *
	 * @param upper_identification
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	protected long getMaxStructOrder(String identificationName, String identificationValue) throws SQLException, ClassNotFoundException {

		String condition = "";
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		condition = identificationName + " = ?";
		conditionValues.add(identificationValue);

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("MAX(STRUCT_ORDER) AS STRUCT_ORDER");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionValues);
		ArrayList<AccountStructure> objects = new ArrayList<AccountStructure>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			AccountStructure account = new AccountStructure(m_db, selectParams, row);
			objects.add(account);
		}

		long lngStructOrder = 0;
		String strStructOrder = rows.get(0).get(0);
		if ( strStructOrder != null ) {
			lngStructOrder = Integer.parseInt(strStructOrder);
		}

		return lngStructOrder;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	protected String create(ArrayList<String> insertParams, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException, IOException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");
		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertValues, selectParams);
		return rows.get(0).get(0);
	}
}
