/**
 *
 */
package control;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.DecoratedEntity;
import model.Entity;
import model.NavigationItem;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import systemModel.ClassColumnMaster;
import systemModel.ClassDepartment;
import systemModel.ColumnMaster;
import systemModel.Department;
import systemModel.Person;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import common.DBAccessWrapper;
import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class DepartmentManager extends ChokomaroHttpServlet {

	/**
	 *
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doGet(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_navigate = request.getParameter("navigate");
		if ( in_navigate == null ) {
			String in_simple_search_prop_name = request.getParameter("simple_search_prop_name");
			if ( in_simple_search_prop_name == null ) {
				// XML作成
				DocumentBuilder documentBuilder = null;
				try {
					documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

					Document document = documentBuilder.newDocument();

					Element elem_rows = document.createElement("rows");
					document.appendChild(elem_rows);

					// XML出力
					TransformerFactory tf = TransformerFactoryImpl.newInstance();
					tf.setAttribute(TransformerFactoryImpl.INDENT_NUMBER, "2");

					Transformer transformer = tf.newTransformer();
					transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
					transformer.setOutputProperty(OutputKeys.INDENT, "yes");
					transformer.setOutputProperty(OutputKeys.METHOD, "xml");

					StringWriter writer = new StringWriter();
					StreamResult result = new StreamResult(writer);

					DOMSource source = new DOMSource(document);
					transformer.transform(source, result);

					response.getWriter().println(writer.toString());
				} catch (ParserConfigurationException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				} catch (TransformerException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
			}
			else {
				simpleSearch(request, response);
			}
		}
		else if ( in_navigate.equals("part")) {
			navigatePerson(request, response);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void simpleSearch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		//jqgridパラメータ
		//http://localhost:8080/chokomaro/departmentmanager?simple_search_condition=*&_search=false&nd=1397348047107&rows=100&page=1&sidx=%E5%90%8D%E7%A7%B0&sord=asc

		String in_search = request.getParameter("_search");
		if ( in_search == null ) {
			in_search = "";
		}

		String in_nd = request.getParameter("nd");
		if ( in_nd == null ) {
			in_nd = "";
		}

		String in_rows = request.getParameter("rows");
		if ( in_rows == null ) {
			in_rows = "";
		}

		String in_page = request.getParameter("page");
		if ( in_page == null ) {
			in_page = "";
		}

		String in_sidx = request.getParameter("sidx");
		if ( in_sidx == null ) {
			in_sidx = "";
		}

		String in_sord = request.getParameter("sord");
		if ( in_sord == null ) {
			in_sord = "";
		}

		//jqgrid追加パラメータ
		String in_simple_search_prop_name = request.getParameter("simple_search_prop_name");
		if ( in_simple_search_prop_name == null ) {
			String messageString = "パラメータ（simple_search_prop_name）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String in_simple_search_oper = request.getParameter("simple_search_oper");
		if ( in_simple_search_oper == null ) {
			String messageString = "パラメータ（simple_search_oper）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String in_simple_search_condition = request.getParameter("simple_search_condition");
		if ( in_simple_search_condition == null ) {
			String messageString = "パラメータ（simple_search_condition）が設定されていません。";
			logger.info(messageString);
			return;
		}

		String[] columns = null;
		String in_columns = request.getParameter("columns");
		if(in_columns != null) {
			columns = in_columns.split(",");
		}

		String conditionMaster = "";
		String conditionSetting = "";
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		conditionMaster = "self.TABLE_ID = ?";
		conditionSetting = "self.PERSON_NUMBER = ?";
		conditionValues.clear();
		conditionValues.add("DEPARTMENT");
		conditionValues.add(in_userid);

		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);

		try {

			db.startTransaction();
			ClassColumnMaster clsColumnMaster = new ClassColumnMaster(db);
			ArrayList<DecoratedEntity> objects = clsColumnMaster.selectWithColumnSetting(conditionMaster, conditionSetting, conditionValues);

			//ソートインデックスの置換
			if ( !in_sidx.isEmpty() ) {
				Iterator<DecoratedEntity> itrColumns = objects.iterator();
				while (itrColumns.hasNext()) {
					DecoratedEntity decoratedEntity = itrColumns.next();

					ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
					//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

					String columnViewVame = columnMaster.getProperty("COLUMN_VIEW_NAME");
					if ( columnViewVame.equals(in_sidx) ) {
						in_sidx = columnMaster.getProperty("COLUMN_ID");
						break;
					}
				}
			}

			ArrayList<Department> departmentsAll = new ArrayList<Department>();
			String[] in_simple_search_conditions = null;
			in_simple_search_conditions = in_simple_search_condition.split("\\|");
			for (int ii = 0; ii < in_simple_search_conditions.length; ++ii) {

				String simple_search_prop_name = "";
				String simple_search_oper = "";
				String simple_search_condition = in_simple_search_conditions[ii];

				if (in_simple_search_oper.equals("simple_search_oper1")) {
					if ( simple_search_condition.contains("*") ) {
						simple_search_prop_name = in_simple_search_prop_name;
						simple_search_oper = "LIKE";
						simple_search_condition = simple_search_condition.replaceAll("\\*", "%");
					}
					else {
						simple_search_prop_name = in_simple_search_prop_name;
						simple_search_oper = "=";
					}
				}
				else if (in_simple_search_oper.equals("simple_search_oper2")) {
					if ( simple_search_condition.contains("*") ) {
						simple_search_prop_name = "NOT " + in_simple_search_prop_name;
						simple_search_oper = "LIKE";
						simple_search_condition = simple_search_condition.replaceAll("\\*", "%");
					}
					else {
						simple_search_prop_name = in_simple_search_prop_name;
						simple_search_oper = "!=";
					}
				}
				else if (in_simple_search_oper.equals("simple_search_oper3")) {
					simple_search_prop_name = in_simple_search_prop_name;
					simple_search_oper = "LIKE";
					simple_search_condition += "%";
				}
				else if (in_simple_search_oper.equals("simple_search_oper4")) {
					simple_search_prop_name = in_simple_search_prop_name;
					simple_search_oper = "LIKE";
					simple_search_condition = "%" + in_simple_search_condition;
				}
				else if (in_simple_search_oper.equals("simple_search_oper5")) {
					simple_search_prop_name = in_simple_search_prop_name;
					simple_search_oper = "LIKE";
					simple_search_condition = "%" + in_simple_search_condition + "%";
				}
				else if (in_simple_search_oper.equals("simple_search_oper6")) {
					simple_search_prop_name = "NOT " + in_simple_search_prop_name;
					simple_search_oper = "LIKE";
					simple_search_condition = "%" + in_simple_search_condition + "%";
				}

				String condition = "";
				condition = simple_search_prop_name;
				condition += " ";
				condition += simple_search_oper;
				condition += " ?";
				if ( !in_sidx.isEmpty() ) {
					condition += " ORDER BY ";
					condition += in_sidx;
					condition += " ";
					condition += in_sord;
				}
				conditionValues.clear();
				conditionValues.add(simple_search_condition);

				ArrayList<Department> departments;
				ClassDepartment clsDepartment = new ClassDepartment(db);
				departments = clsDepartment.select(condition, conditionValues);
				if ( departments.size() > 0 ) {
					departmentsAll.addAll(departments);
				}
			}

			// XML作成
			DocumentBuilder documentBuilder = null;
			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.newDocument();

			Element elem_rows = document.createElement("rows");
			document.appendChild(elem_rows);

			for ( int ii = 0; ii < departmentsAll.size(); ++ii ) {
				createXml(document, elem_rows, departmentsAll.get(ii), objects, columns);
			}

			db.commit();

			// XML出力
			TransformerFactory tf = TransformerFactoryImpl.newInstance();
			tf.setAttribute(TransformerFactoryImpl.INDENT_NUMBER, "2");

			Transformer transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);

			DOMSource source = new DOMSource(document);
			transformer.transform(source, result);

			response.getWriter().println(writer.toString());

		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		}

		logger.finest("END/NORMAL");
	}


	/**
	 *
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void navigatePerson(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		//jqgridパラメータ
		//http://localhost:8080/chokomaro/accountmanager?identificaton=3&_search=false&nd=1397348047107&rows=100&page=1&sidx=%E5%90%8D%E7%A7%B0&sord=asc

		String in_search = request.getParameter("_search");
		if ( in_search == null ) {
			in_search = "";
		}

		String in_nd = request.getParameter("nd");
		if ( in_nd == null ) {
			in_nd = "";
		}

		String in_rows = request.getParameter("rows");
		if ( in_rows == null ) {
			in_rows = "";
		}

		String in_page = request.getParameter("page");
		if ( in_page == null ) {
			in_page = "";
		}

		String in_sidx = request.getParameter("sidx");
		if ( in_sidx == null ) {
			in_sidx = "";
		}

		String in_sord = request.getParameter("sord");
		if ( in_sord == null ) {
			in_sord = "";
		}

		//jqgrid追加パラメータ
		String in_identification = request.getParameter("identification");

		String conditionMaster = "";
		String conditionSetting = "";
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		conditionMaster = "self.TABLE_ID = ?";
		conditionSetting = "self.PERSON_NUMBER = ?";
		conditionValues.clear();
		conditionValues.add("PART");
		conditionValues.add(in_userid);

		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);

		try {

			db.startTransaction();
			ClassColumnMaster clsColumnMaster = new ClassColumnMaster(db);
			ArrayList<DecoratedEntity> objects = clsColumnMaster.selectWithColumnSetting(conditionMaster, conditionSetting, conditionValues);

			//ソートインデックスの置換
			if ( !in_sidx.isEmpty() ) {
				Iterator<DecoratedEntity> itrColumns = objects.iterator();
				while (itrColumns.hasNext()) {
					DecoratedEntity decoratedEntity = itrColumns.next();

					ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
					//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

					String columnViewVame = columnMaster.getProperty("COLUMN_VIEW_NAME");
					if ( columnViewVame.equals(in_sidx) ) {
						in_sidx = columnMaster.getProperty("COLUMN_ID");
						break;
					}
				}
			}

			Department department = null;
			if ( in_identification != null ) {
				String condition = "";
				condition = "IDENTIFICATION = ?";
				conditionValues.clear();
				conditionValues.add(in_identification);

				ArrayList<Department> departments;
				ClassDepartment clsdepartment = new ClassDepartment(db);
				departments = clsdepartment.select(condition, conditionValues);

				if ( departments.size() > 0 ) {
					department = departments.get(0);
				}
			}

			// XML作成
			DocumentBuilder documentBuilder = null;
			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.newDocument();

			Element elem_rows = document.createElement("rows");
			document.appendChild(elem_rows);

			if ( department != null ) {

				ArrayList<String> sortOrders = null;
				if (!in_sidx.isEmpty()) {
					sortOrders = new ArrayList<String>();
					String sortOrder = "PART.";
					sortOrder += in_sidx;
					sortOrder += " ";
					sortOrder += in_sord;
					sortOrders.add(sortOrder);
				}

				ArrayList<NavigationItem> navigationItems = department.navigatePerson(sortOrders);

				Iterator<NavigationItem> itrNavigationItem = navigationItems.iterator();
				while (itrNavigationItem.hasNext()) {

					NavigationItem navigationItem = itrNavigationItem.next();
					//department srcdepartment = (department) navigationItem.source;
					Person dstPerson = (Person) navigationItem.destination;

					createXml(document, elem_rows, dstPerson, objects, null);
				}
			}

			db.commit();

			// XML出力
			TransformerFactory tf = TransformerFactoryImpl.newInstance();
			tf.setAttribute(TransformerFactoryImpl.INDENT_NUMBER, "2");

			Transformer transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);

			DOMSource source = new DOMSource(document);
			transformer.transform(source, result);

			response.getWriter().println(writer.toString());

		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		} catch (TransformerException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
			return;
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param document
	 * @param elem_rows
	 * @param account
	 * @param objects
	 * @param columns
	 * @param treeGrid
	 * @throws IOException
	 */
	private void createXml(Document document, Element elem_rows, Entity entity, ArrayList<DecoratedEntity> objects, String[] columns) throws IOException {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		Element elem_row = null;
		Element elem_cell = null;

		String identification = entity.identification();
		elem_row = document.createElement("row");
		elem_row.setAttribute("id", identification);
		elem_rows.appendChild(elem_row);

		String cellString = "";
		Iterator<DecoratedEntity> itrColumns = objects.iterator();
		while (itrColumns.hasNext()) {
			DecoratedEntity decoratedEntity = itrColumns.next();

			ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
			//ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

			if ( columns != null ) {
				boolean isSkip = true;
				for (int ii = 0; ii < columns.length; ++ii) {
					String columnId1 = columns[ii];
					String columnId2 = columnMaster.getProperty("COLUMN_ID");
					if ( columnId1.equals(columnId2) ) {
						isSkip = false;
						break;
					}
				}
				if ( isSkip ) {
					continue;
				}
			}

			String columnId = columnMaster.getProperty("COLUMN_ID");
			cellString = entity.getProperty(columnId);
			if ( cellString == null ) {
				cellString = "";
			}
			elem_cell = document.createElement("cell");
			elem_cell.appendChild(document.createTextNode(cellString));
			elem_row.appendChild(elem_cell);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doPost(request, response);

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			logger.info("セッションがありません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			logger.info("セッションにユーザIDが設定されていません。ログイン画面を表示します。");
			String path = "./jsp/login.jsp";
			RequestDispatcher rd = request.getRequestDispatcher(path);
			rd.forward(request, response);
			return;
		}

		String in_oper = request.getParameter("oper");
		if ( in_oper == null ) {
			String messageString = "パラメータ（oper）が設定されていません。";
			logger.info(messageString);
			return;
		}

		if ( in_oper.equals("add") ) {
			buildDepartment(request, response, in_userid);
		}
		else if ( in_oper.equals("edit") ) {
			modifyDepartment(request, response, in_userid);
		}
		else if ( in_oper.equals("del") ) {
			deleteDepartment(request, response, in_userid);
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void buildDepartment(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		ArrayList<String> insertParams = new ArrayList<String>();
		ArrayList<Object> insertValues  = new ArrayList<Object>();

		insertParams.clear();
		insertValues.clear();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects("DEPARTMENT");
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			boolean columnEditable = Boolean.valueOf(metaColumn.getProperty("EDITABLE"));
			if ( columnEditable ) {
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String in_insertParam = request.getParameter(columnId);
				if ( in_insertParam == null || in_insertParam.isEmpty() ) {
					boolean columnNotNull = Boolean.valueOf(metaColumn.getProperty("COLUMN_NOT_NULL"));
					if ( columnNotNull ) {
						String messageString = "パラメータ（";
						messageString += columnId;
						messageString += "）が設定されていません。";
						logger.info(messageString);
						return;
					}
				}
				else {
					insertParams.add(columnId);
					insertValues.add(in_insertParam);
				}
			}
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassDepartment clsDepartment = new ClassDepartment(db);

			//取引先コード最大値取得
			String prefix = "DP";
			String condition = "";
			ArrayList<String> selectParams = new ArrayList<String>();
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			selectParams.clear();
			selectParams.add("MAX(DEPARTMENT_NUMBER) AS DEPARTMENT_NUMBER");
			condition = "DEPARTMENT_NUMBER LIKE ?";
			conditionValues.clear();
			conditionValues.add(prefix + "%");

			int intMaxOfdepartmentNumber = 0;
			ArrayList<ArrayList<String>> maxValues = clsDepartment.select(selectParams, condition, conditionValues);
			String strMaxOfAccountNumber = maxValues.get(0).get(0);
			if ( strMaxOfAccountNumber != null) {
				String strMaxOfAccountNumberBody = strMaxOfAccountNumber.substring(prefix.length(), strMaxOfAccountNumber.length());
				intMaxOfdepartmentNumber = Integer.parseInt(strMaxOfAccountNumberBody);
			}
			++intMaxOfdepartmentNumber;
			strMaxOfAccountNumber = String.format("%s%07d", prefix, intMaxOfdepartmentNumber);

			//追加パラメータ設定
			insertParams.add("DEPARTMENT_NUMBER");
			insertValues.add(strMaxOfAccountNumber);

			Department newDepartment = clsDepartment.create(insertParams, insertValues);

			db.commit();

			String delimiter = "";
			StringBuffer responseText = new StringBuffer();
			for (int ii = 0; ii < metaColumns.size(); ++ii) {
				MetaColumn metaColumn = metaColumns.get(ii);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String value = newDepartment.getProperty(columnId);
				responseText.append(delimiter);
				responseText.append(columnId);
				responseText.append("=");
				responseText.append(value);
				delimiter = ",";
			}

			//登録結果出力
			response.getWriter().write(responseText.toString());

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public void modifyDepartment(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		ArrayList<String> updateParams = new ArrayList<String>();
		ArrayList<Object> updateValues  = new ArrayList<Object>();

		updateParams.clear();
		updateValues.clear();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects("DEPARTMENT");
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			boolean columnEditable = Boolean.valueOf(metaColumn.getProperty("EDITABLE"));
			if ( columnEditable ) {
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String in_updateParam = request.getParameter(columnId);
				if ( in_updateParam != null && !in_updateParam.isEmpty() ) {
					updateParams.add(columnId);
					updateValues.add(in_updateParam);
				}
			}
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);

			ArrayList<Department> departments1;
			ClassDepartment clsdepartment = new ClassDepartment(db);
			departments1 = clsdepartment.select(condition, conditionValues);
			if ( departments1.size() == 0 ) {
				db.rollback();

				String messageString = "取引先の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			Department department1 = departments1.get(0);

			int result = clsdepartment.update(updateParams, updateValues, condition, conditionValues);
			if ( result < 0 ) {
				db.rollback();

				String messageString = "取引先の更新に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			ArrayList<Department> departments2 = clsdepartment.select(condition, conditionValues);
			if ( departments2.size() == 0 ) {
				db.rollback();

				String messageString = "取引先の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				return;
			}

			Department department2 = departments2.get(0);

			db.commit();

			String delimiter = "";
			StringBuffer responseText = new StringBuffer();
			for (int ii = 0; ii < metaColumns.size(); ++ii) {
				MetaColumn metaColumn = metaColumns.get(ii);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				String value1 = department1.getProperty(columnId);
				String value2 = department2.getProperty(columnId);
				if ( !value1.equals(value2) ) {
					responseText.append(delimiter);
					responseText.append(columnId);
					responseText.append("=");
					responseText.append(value2);
					delimiter = ",";
				}
			}

			//登録結果出力
			response.getWriter().write(responseText.toString());

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 * @throws IOException
	 */
	public void deleteDepartment(HttpServletRequest request, HttpServletResponse response, String userid) {

		Environment env = Environment.getEnvironment();
		Logger logger = env.getLogger();
		logger.finest("START");

		String in_identification = request.getParameter("IDENTIFICATION");
		if ( in_identification == null ) {
			String messageString = "パラメータ（IDENTIFICATION）が設定されていません。";
			logger.info(messageString);
			return;
		}

		DBAccessWrapper db = new DBAccessWrapper(env, userid);

		try {

			db.startTransaction();

			ClassDepartment clsDepartment = new ClassDepartment(db);
			String condition = "";
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			condition = "IDENTIFICATION = ?";
			conditionValues.clear();
			conditionValues.add(in_identification);

			ArrayList<Department> departments;
			departments = clsDepartment.select(condition, conditionValues);
			if ( departments.size() == 0 ) {
				db.rollback();

				String messageString = "取引先の検索に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			Department department;
			department = departments.get(0);
			int result = department.delete();

			if ( result < 0 ) {
				db.rollback();

				String messageString = "取引先の削除に失敗しました。ID:" + in_identification;
				logger.warning(messageString);
				response.getWriter().write(messageString);
				return;
			}

			db.commit();

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();

			String msg = e.getLocalizedMessage();
			logger.severe(msg);
			logger.finest("END/ERROR");
		}

		logger.finest("END/NORMAL");
	}
}
