package system;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassHoliday extends ClassModelObject{

	/**
	 *
	 */
	public ClassHoliday() {
		this.m_tableName = "HOLIDAY";
	}

	/**
	 *
	 * @param db
	 */
	public ClassHoliday(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "HOLIDAY";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Holiday> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("NAME");
		selectParams.add("TARGET_DATE");
		selectParams.add("APPLICATION_START_DATE");
		selectParams.add("APPLICATION_FINISH_DATE");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Holiday> objects = new ArrayList<Holiday>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Holiday object = new Holiday(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
