package system;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassDepartment extends ClassModelObject{

	/**
	 *
	 */
	public ClassDepartment() {
		this.m_tableName = "DEPARTMENT";
	}

	/**
	 *
	 * @param db
	 */
	public ClassDepartment(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "DEPARTMENT";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Department> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("DEPARTMENT_NUMBER");
		selectParams.add("NAME");
		selectParams.add("PERSON");
		selectParams.add("POSTAL_CODE");
		selectParams.add("ADDRESS");
		selectParams.add("PHONE_NUMBER");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Department> objects = new ArrayList<Department>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Department object = new Department(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
