package system;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;
import common.DecoratedEntity;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassColumnMaster extends ClassModelObject{

	/**
	 *
	 */
	public ClassColumnMaster() {
		this.m_tableName = "COLUMN_MASTER";
	}

	/**
	 *
	 * @param db
	 */
	public ClassColumnMaster(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "COLUMN_MASTER";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<ColumnMaster> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("TABLE_ID");
		selectParams.add("COLUMN_ID");
		selectParams.add("COLUMN_VIEW_NAME");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<ColumnMaster> objects = new ArrayList<ColumnMaster>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			ColumnMaster object = new ColumnMaster(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<DecoratedEntity> selectWithColumnSetting(String masterCondition, String settingCondition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		String strbTableName = "COLUMN_MASTER T1, COLUMN_SETTING T2";

		ArrayList<String> selectParams1 = new ArrayList<String>();
		selectParams1.clear();
		selectParams1.add("IDENTIFICATION");
		selectParams1.add("TABLE_ID");
		selectParams1.add("COLUMN_ID");
		selectParams1.add("COLUMN_VIEW_NAME");
		selectParams1.add("CREATE_DATE");
		selectParams1.add("CREATE_PERSON");
		selectParams1.add("MODIFY_DATE");
		selectParams1.add("MODIFY_PERSON");

		ArrayList<String> selectParams2 = new ArrayList<String>();
		selectParams2.clear();
		selectParams2.add("IDENTIFICATION");
		selectParams2.add("SUPER_IDENTIFICATION");
		selectParams2.add("USER_NUMBER");
		selectParams2.add("DISPLAY");
		selectParams2.add("STRUCT_ORDER");
		selectParams2.add("WITDH");
		selectParams2.add("CREATE_DATE");
		selectParams2.add("CREATE_PERSON");
		selectParams2.add("MODIFY_DATE");
		selectParams2.add("MODIFY_PERSON");

		ArrayList<String> selectParams = new ArrayList<String>();
		for (int ii = 0; ii < selectParams1.size(); ++ii) {
			String selectParam = selectParams1.get(ii);
			selectParam = "T1." + selectParam + " AS COLUMN_MASTER_" + selectParam;
			selectParams.add(selectParam);
		}
		for (int ii = 0; ii < selectParams2.size(); ++ii) {
			String selectParam = selectParams2.get(ii);
			selectParam = "T2." + selectParam + " AS COLUMN_SETTINGl_" + selectParam;
			selectParams.add(selectParam);
		}

		StringBuilder condition = new StringBuilder();

		condition.append("T1.IDENTIFICATION = T2.SUPER_IDENTIFICATION");
		if(!masterCondition.isEmpty()) {
			masterCondition = masterCondition.toUpperCase();
			masterCondition = masterCondition.replaceAll("SELF", "T1");
			condition.append(" AND ");
			condition.append(" ( ");
			condition.append(masterCondition);
			condition.append(" ) ");
		}

		if(!settingCondition.isEmpty()) {
			settingCondition = settingCondition.toUpperCase();
			settingCondition = settingCondition.replaceAll("SELF", "T2");
			condition.append(" AND ");
			condition.append(" ( ");
			condition.append(settingCondition);
			condition.append(" ) ");
		}

		ArrayList<String> sortParams = new ArrayList<String>();
		sortParams.add("T2.STRUCT_ORDER");

		ArrayList<ArrayList<String>> rows = m_db.selectWithOrderBy(selectParams, strbTableName, condition.toString(), conditionTypes, conditionValues, sortParams);
		ArrayList<DecoratedEntity> objects = new ArrayList<DecoratedEntity>();
		for (int ii = 0; ii < rows.size(); ++ii) {

			ArrayList<String> row = rows.get(ii);
			ArrayList<String> row1 = new ArrayList<String>();
			ArrayList<String> row2 = new ArrayList<String>();

			int index = 0;
			for (int jj = 0; jj < selectParams1.size(); ++jj, ++index) {
				row1.add(row.get(index));
			}
			for (int jj = 0; jj < selectParams2.size(); ++jj, ++index) {
				row2.add(row.get(index));
			}

			DecoratedEntity decoEntity = new DecoratedEntity();
			ColumnMaster object1 = new ColumnMaster(m_db, selectParams1, row1);
			ColumnSetting object2 = new ColumnSetting(m_db, selectParams2, row2);

			decoEntity.originator = object1;
			decoEntity.decorator = object2;
			objects.add(decoEntity);
		}

		return objects;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ColumnMaster create(ArrayList<String> insertParams, ArrayList<String> insertTypes, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertTypes, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identificaton);

		ArrayList<ColumnMaster> objects;
		objects = select(condition, conditionTypes, conditionValues);

		return objects.get(0);
	}
}
