package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassDealing extends ClassModelObject{

	/**
	 *
	 */
	public ClassDealing() {
		this.m_tableName = "DEALING";
	}

	/**
	 *
	 * @param db
	 */
	public ClassDealing(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "DEALING";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Dealing> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("DEALING_DATE");
		selectParams.add("DEALING_TIME");
		selectParams.add("PARTNER_NUMBER");
		selectParams.add("LIFECYCLE_STATE");
		selectParams.add("TEMPLATE_FLAG");
		selectParams.add("DEPARTMENT_NUMBER");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Dealing> objects = new ArrayList<Dealing>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Dealing object = new Dealing(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
