package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassBudget extends ClassModelObject{

	/**
	 *
	 */
	public ClassBudget() {
		this.m_tableName = "BUDGET";
	}

	/**
	 *
	 * @param db
	 */
	public ClassBudget(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "BUDGET";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Budget> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("BUDGET_NUMBER");
		selectParams.add("DEPARTMENT_NUMBER");
		selectParams.add("START_DATE");
		selectParams.add("FINISH_DATE");
		selectParams.add("AMOUNT");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Budget> objects = new ArrayList<Budget>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Budget object = new Budget(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
