package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassAccountPart  extends ClassModelObject {

	/**
	 *
	 */
	public ClassAccountPart() {
		this.m_tableName = "ACCOUNT_PART";
	}

	/**
	 *
	 * @param db
	 */
	public ClassAccountPart(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "ACCOUNT_PART";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<AccountPart> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("LEFT_IDENTIFICATION");
		selectParams.add("RIGHT_IDENTIFICATION");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<AccountPart> objects = new ArrayList<AccountPart>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			AccountPart object = new AccountPart(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public AccountPart create(ArrayList<String> insertParams, ArrayList<String> insertTypes, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertTypes, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identificaton);

		ArrayList<AccountPart> objects;
		objects = select(condition, conditionTypes, conditionValues);
		return objects.get(0);
	}
}
