package common;

import java.util.ArrayList;
import java.util.HashMap;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ModelObject {

	/**
	 *
	 */
	protected DBAccessWrapper m_db;

	/**
	 *
	 */
	protected HashMap<String, String> properties;

	/**
	 *
	 */
	public ModelObject() {
		this.m_db = null;
	}

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public ModelObject(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		this.m_db = db;
		this.properties = new HashMap<String, String>();
		for( int ii = 0; ii < keys.size(); ++ii ) {
			String key = keys.get(ii);
			int pos = key.indexOf(" AS ");
			if ( pos >= 0) {
				key = key.substring(pos + 4, key.length());
			}
			String value = values.get(ii);
			properties.put(key, value);
		}
	}

	/**
	 *
	 * @return
	 */
	public String identification() {
		return properties.get("IDENTIFICATION");
	}

	/**
	 *
	 * @return
	 */
	public String getProperties(String name) {
		String value;
		name = name.toUpperCase();
		value = properties.get(name);
		if ( value == null ) {
			value = "";
		}
		return value;
	}
}
