/**
 *
 */
package common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Environment {

	/**
	 *
	 */
	static Environment m_env = null;

	/**
	 *
	 */
	private ArrayList<String> pathList = null;

	/**
	 *
	 */
	private Properties properties;

	/**
	 *
	 */
	private Environment() {
		pathList = new ArrayList<String>();
	}

	/**
	 *
	 * @return
	 */
	public static Environment getEnvironment() {
		if ( m_env == null ) {
			m_env = new Environment();
		}
		return m_env;
	}

	/**
	 *
	 * @param path
	 * @return
	 */
	public int init(String path) {

		FileInputStream fis = null;
		InputStreamReader isr = null;

		try {

			if ( pathList.indexOf(path) < 0 ) {
				fis = new FileInputStream(path);
				isr = new InputStreamReader(fis, Charset.defaultCharset());
				properties = new Properties();
				properties.load(isr);
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return -1;
		} catch (IOException e) {
			e.printStackTrace();
			return -1;
		} finally {
			try {
				if (isr != null) {
					isr.close();
				}
				if (fis != null) {
					fis.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
				return -1;
			}
		}

		pathList.add(path);

		return 0;
	}

	/**
	 *
	 * @param key
	 * @return
	 */
	public String getParam(String key) {
		return properties.getProperty(key);
	}
}
