package common;

import java.sql.SQLException;
import java.util.ArrayList;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassModelObject {

	/**
	 *
	 */
	protected DBAccessWrapper m_db;
	protected String m_tableName;

	/**
	 *
	 */
	public ClassModelObject() {
		this.m_db = null;
		this.m_tableName = "";
	}

	/**
	 *
	 * @param db
	 */
	public ClassModelObject(DBAccessWrapper db) {
		this.m_db = db;
		this.m_tableName = "";
	}

	/**
	 *
	 * @param selectParams
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	protected ArrayList<ArrayList<String>> select(ArrayList<String> selectParams, String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {
		return m_db.select(selectParams, m_tableName, condition, conditionTypes, conditionValues);
	}

	/**
	 *
	 * @param selectParams
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @param sortParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	protected ArrayList<ArrayList<String>> selectWithOrderBy(ArrayList<String> selectParams, String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues, ArrayList<String> sortParams) throws SQLException, ClassNotFoundException {
		return m_db.selectWithGroupBy(selectParams, m_tableName, condition, conditionTypes, conditionValues, sortParams);
	}

	/**
	 *
	 * @param selectParams
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @param groupParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	protected ArrayList<ArrayList<String>> selectWithGroupBy(ArrayList<String> selectParams, String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues, ArrayList<String> groupParams) throws SQLException, ClassNotFoundException {
		return m_db.selectWithGroupBy(selectParams, m_tableName, condition, conditionTypes, conditionValues, groupParams);
	}

	/**
	 *
	 * @param selectParams
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @param groupParams
	 * @param sortParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	protected ArrayList<ArrayList<String>> selectWithGroupByAndOrderBy(ArrayList<String> selectParams, String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues, ArrayList<String> groupParams, ArrayList<String> sortParams) throws SQLException, ClassNotFoundException {
		return m_db.selectWithGroupByAndOrderBy(selectParams, m_tableName, condition, conditionTypes, conditionValues, groupParams, sortParams);
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @param selectParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	protected ArrayList<ArrayList<String>> insert(ArrayList<String> insertParams, ArrayList<String> insertTypes, ArrayList<Object> insertValues, ArrayList<String> selectParams) throws SQLException, ClassNotFoundException {
		return m_db.insert(m_tableName, insertParams, insertTypes, insertValues, selectParams);
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 */
	public int truncate() throws SQLException {
		int result;
		result = m_db.truncate(m_tableName);
		return result;
	}
}
