package cerot.memo.server;

import java.util.LinkedHashMap;
import java.util.Map;

import cerot.memo.client.entity.TextEntry;
import cerot.memo.client.service.MemoService;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class MemoServiceImpl extends RemoteServiceServlet implements
		MemoService {
	private Map<String, TextEntry> contents = new LinkedHashMap<String, TextEntry>();

	public MemoServiceImpl() {
		String id;
		id = createText("テスト１");
		updateText(id, "本文１");

		id = createText("テスト２");
		updateText(id, "本文２");

		id = createText("テスト３");
		updateText(id, "本文３");

		id = createText("テスト４");
		updateText(id, "本文４");
	}

	@Override
	public TextEntry getTextEntry(String id) {
		return contents.get(id);
	}

	@Override
	public TextEntry[] getTitleList() {
		return contents.values().toArray(new TextEntry[contents.size()]);
	}

	@Override
	public String createText(String title) {
		String id = "file" + contents.size();

		TextEntry entry = new TextEntry();
		entry.id = id;
		entry.title = title;
		contents.put(id, entry);

		return id;
	}

	@Override
	public void updateText(String id, String content) {
		TextEntry entry = contents.get(id);
		entry.id = id;
		entry.content = content;
	}

	@Override
	public void updateTitle(String id, String title) {
		contents.get(id).title = title;
	}

	@Override
	public TextEntry getMessage() {
		TextEntry entry = new TextEntry();
		entry.id = "cero-t";
		entry.title = "cero-tからのメッセージ";
		entry.content = "家でコード書いてる？";
		return entry;
	}
}
