package cerot.memo.client.ui;

import cerot.memo.client.Memo;
import cerot.memo.client.entity.TextEntry;
import cerot.memo.client.service.MemoServiceAsync;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;

public class MenuTree extends Tree implements SelectionHandler<TreeItem> {
	private Memo memo;
	private MemoServiceAsync memoService;

	public MenuTree(Memo memo, MemoServiceAsync memoService) {
		this.memo = memo;
		this.memoService = memoService;
		this.addSelectionHandler(this);
	}

	@Override
	public void onSelection(SelectionEvent<TreeItem> event) {
		TreeItem item = event.getSelectedItem();
		memo.textBox.setText(item.getText());
		memo.hidden.setValue(item.getTitle());

		memo.textBox.setText(item.getText());

		AsyncCallback<TextEntry> callback = new AsyncCallback<TextEntry>() {
			@Override
			public void onSuccess(TextEntry result) {
				memo.textArea.setText(result.content);
				memo.textArea.setEnabled(true);
			}

			@Override
			public void onFailure(Throwable caught) {
				memo.textArea.setText("エラー");
			}
		};

		if (item.getTitle().equals("cero-t")) {
			memoService.getMessage(callback);
			return;
		}

		memoService.getTextEntry(item.getTitle(), callback);
	}
}
