package cerot.memo.client;

import cerot.memo.client.entity.TextEntry;
import cerot.memo.client.service.MemoService;
import cerot.memo.client.service.MemoServiceAsync;
import cerot.memo.client.ui.MenuTree;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;

public class Memo implements EntryPoint {
	private final MemoServiceAsync memoService = GWT.create(MemoService.class);

	public Tree tree;
	public TextBox textBox;
	public Hidden hidden;
	public RichTextArea textArea;

	public void onModuleLoad() {
		// ヘッダ
		HTML header = new HTML("This is a header.");

		// 左メニュー
		DockLayoutPanel leftPanel = new DockLayoutPanel(Unit.EM);

		Label label = new Label("新しいテキストを作る");
		leftPanel.addNorth(label, 2);

		tree = new MenuTree(this, memoService);
		leftPanel.add(tree);

		// メインコンテンツ
		DockLayoutPanel mainPanel = new DockLayoutPanel(Unit.EM);

		textBox = new TextBox();
		textBox.setWidth("50%");
		textBox.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent event) {
				tree.getSelectedItem().setText(textBox.getText());
				memoService.updateTitle(hidden.getValue(), textBox.getText(),
						new AsyncCallback<Void>() {
							@Override
							public void onSuccess(Void result) {

							}

							@Override
							public void onFailure(Throwable caught) {

							}
						});
			}
		});
		mainPanel.addNorth(textBox, 2);

		hidden = new Hidden();
		mainPanel.addNorth(hidden, 0);

		textArea = new RichTextArea();
		textArea.setWidth("100%");
		textArea.setHeight("100%");

		textArea.addMouseWheelHandler(new MouseWheelHandler() {
			@Override
			public void onMouseWheel(MouseWheelEvent event) {
				textArea.getFormatter().selectAll();
			}
		});
		
		textArea.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
//				textBox.setText("" + textArea.getOffsetHeight() + ":"
//						+ event.getNativeEvent().getClientY() + "/"
//						+ event.getNativeEvent().getScreenX() + ":"
//						+ event.getNativeEvent().getScreenY());
			}
		});

		// textArea.addChangeHandler(new ChangeHandler() {
		// @Override
		// public void onChange(ChangeEvent event) {
		// memoService.updateText(hidden.getValue(), textArea.getText(),
		// new AsyncCallback<Void>() {
		// @Override
		// public void onSuccess(Void result) {
		//
		// }
		//
		// @Override
		// public void onFailure(Throwable caught) {
		//
		// }
		// });
		// }
		// });
		mainPanel.add(textArea);

		// レイアウト
		DockLayoutPanel panel = new DockLayoutPanel(Unit.EM);
		panel.addNorth(header, 2);
		panel.addWest(leftPanel, 15);
		panel.add(mainPanel);
		panel.setSize("100%", "100%");
		RootPanel.get("rootContainer").add(panel);

		// 初期ローディング
		memoService.getTitleList(new AsyncCallback<TextEntry[]>() {
			@Override
			public void onSuccess(TextEntry[] result) {
				for (TextEntry entry : result) {
					TreeItem item = new TreeItem(entry.title);
					item.setTitle(entry.id);
					tree.addItem(item);
				}
				TreeItem treeItem = new TreeItem("cero-tからのメッセージ");
				treeItem.setTitle("cero-t");
				tree.addItem(treeItem);
			}

			@Override
			public void onFailure(Throwable caught) {
				tree.addItem("エラー");
			}
		});
	}
}
