﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: IWebBrowserControls.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

namespace Bis5Products.SharpWebBrowser {
    /// <summary>SharpWebBrowserで使用するWebBrowserコントロールに必要な機能を実装します。</summary>
    public interface IWebBrowserControl : ISWBModules {
        /// <summary>履歴に前のページが存在する場合、前のページに戻るアクションを実施します。</summary>
        void GoBack();
        /// <summary>履歴に次のページが存在する場合、次のページに進むアクションを実施します。</summary>
        void GoForward();
        /// <summary>WebBrowserで表示しているページの更新を確認し、必要に応じてページを再読み込みします。</summary>
        void Refresh();
        /// <summary>WebBrowserを指定したURIへナビゲートさせます。</summary>
        /// <param name="uri">URI(Uniformed Resource Identifier)を表す文字列。</param>
        void Navigate(string uri);
        /// <summary>WebBrowserを指定したURIへナビゲートさせます。</summary>
        /// <param name="uri">URI(Uniformed Resource Identifier)を表す<seealso cref="System.Uri"/>オブジェクト。</param>
        void Navigate(System.Uri uri);
        /// <summary>WebBrowserで表示しているページを既定のプリンタで印刷します。</summary>
        void Print();
        /// <summary>WebBrowserで読み込もうとしているページの読み込みとアニメーションを中止します。</summary>
        void Stop();
        /// <summary>ページ設定ダイアログを表示します。</summary>
        void ShowPageSetupDialog();
        /// <summary>印刷ダイアログを表示します。</summary>
        void ShowPrintDialog();
        /// <summary>印刷プレビューダイアログを表示します。</summary>
        void ShowPrintPreviewDialog();
        /// <summary>WebBrowserで表示しているページのプロパティを表示します。</summary>
        void ShowPagePropertyDialog();
        /// <summary>名前をつけて保存ダイアログを表示します。</summary>
        void ShowSaveAsDialog();
        /// <summary>WebBrowser固有のエンジンの設定ダイアログを呼び出します。</summary>
        void CallEngineOption();
        /// <summary>WebBrowser固有のエンジンの設定ダイアログを呼び出します。</summary>
        /// <param name="cmgr">SharpWebBrowserの設定を保持しているConfigurationManagerモジュール</param>
        void CallEngineOption(IConfMgr cmgr);
        /// <summary>ホームページに指定されているページにナビゲートします。</summary>
        void GoHome();
    }
}