#pragma once

/*
	Digital Differential Analyzerɂ`揈 8bit
*/

#include <math.h>
#include <algorithm>
#include "buffer2d.h"
#include "arrayutil.h"

#include "ILineDrawer.h"

namespace gl
{

template <typename NumericT>
class LineDrawer8_DDA : public IBufferLineDrawer<NumericT, uint8_t>
{
protected:
	Buffer2D<uint8_t>*	pBuff_;		//!< `
	
	inline
	void blend(
		uint8_t* p,
		uint8_t v
		)
	{
		uint8_t old = *p;
		if (old != 0xff) {
			uint16_t nv = old + v;
			*p = (nv >= 255) ? 255 : nv;
		}
	}

public:
	LineDrawer8_DDA()
		:
		pBuff_(0)
	{
	}

	void SetBuffer(Buffer2D<uint8_t>* pBuff)
	{
		if (pBuff != NULL) {
			pBuff_ = pBuff;
		}
	}
	
	virtual
	void DrawVerticalLine(uint8_t col, NumericT x, NumericT y1, NumericT y2)
	{
	}

	void DrawLine(
		uint8_t intensity,
		NumericT x1, NumericT y1,
		NumericT x2, NumericT y2
		)
	{
		NumericT width = abs(x2 - x1);
		NumericT height = abs(y2 - y1);
		if (width + height == NumericT(0))
			return;
		const int lineOffset = pBuff_->GetLineOffset();
		if (height <= width) {
			if (x2 < x1) {
				std::swap(x1, x2);
				std::swap(y1, y2);
			}
			NumericT a = (y2 - y1) / width;
			NumericT x = x1;
			NumericT y = y1;
			uint8_t* ptr = pBuff_->GetPixelPtr(x, y);
			size_t previy = ToInt(y);
			size_t loopCnt = ToInt(width) + 2;
			while (--loopCnt) {
				y += a;
				blend(ptr, intensity);
				OffsetPtr(ptr, sizeof(uint8_t) + (ToInt(y) - previy) * lineOffset);
				previy = ToInt(y);
			}
		}else {
			if (y2 < y1) {
				std::swap(x1, x2);
				std::swap(y1, y2);
			}
			NumericT a = (x2 - x1) / height;
			NumericT y = y1;
			NumericT x = x1;
			uint8_t* ptr = pBuff_->GetPixelPtr(x, y);
			size_t previx = ToInt(x);
			size_t loopCnt = ToInt(height) + 2;
			while (--loopCnt) {
				x += a;
				blend(ptr, intensity);
				OffsetPtr(ptr, lineOffset + (ToInt(x) - previx));
				previx = ToInt(x);
			}
		}
	}
	
};

}	// namespace gl

