
// color quantization program by berupon

#include "stdafx.h"

#include <vector>
#include <limits>

#include "ImageIO/ImageIO.h"
#include "ImageIO/File.h"

#include "scolorq.h"

// http://proglab.aki.gs/mediaproc/colors.html

size_t call_count = 0;

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc != 1+3) {
		puts("Usage: color_quantizer <source image.bmp> <output image.bmp> <desired palette size>\n");
		return -1;
	}
	
	int num_colors = _ttoi(argv[3]);
	if (num_colors <= 1 || num_colors > 256) {
		printf("Number of colors must be at least 2 and no more than 256.\n");
		return -1;
	}
	
	ImageInfo imageInfo;
	FILE* f = _tfopen(argv[1], _T("rb"));
	if (!f) {
		puts("failed to open file\n");
		return 0;
	}
	File file(f);
	if (!ReadImageInfo(file, imageInfo)) {
		puts("failed to open image\n");
		return 0;
	}
	if (
		imageInfo.bitsPerSample != 8
		|| (imageInfo.samplesPerPixel != 3 && imageInfo.samplesPerPixel != 4)
	) {
		puts("unsupported image file format.\n");
		return 0;
	}
	size_t lineBytes = imageInfo.samplesPerPixel * imageInfo.width;
	if (lineBytes % 4) {
		lineBytes += 4 - (lineBytes % 4);
	}
	std::vector<uint8_t> buff(lineBytes * imageInfo.height);
	ReadImage(file, imageInfo, &buff[0], lineBytes, 0);
	fclose(f);
	uint8_t* p = &buff[0];
	
	size_t width = imageInfo.width;
	size_t height = imageInfo.height;
	Image image(width, height);
	Color* pLine = image.pBuff_;
	uint8_t* pSrcLine = p;

	double gamma = 1.0;
	double lut[256];
	lut[0] = 0.0;
	lut[255] = 1.0;
	for (size_t i=1; i<255; ++i) {
		lut[i] = pow(i/255.0, 1.0/gamma);
	}
	for (size_t y=0; y<height; ++y) {
		for (size_t x=0; x<width; ++x) {
			const uint8_t* pPixel = pSrcLine + x * 3;
			double r = lut[ pPixel[0] ];
			double g = lut[ pPixel[1] ];
			double b = lut[ pPixel[2] ];
			pLine[x] = Color(r,g,b,0.0);
		}
		pLine += width;
		pSrcLine += lineBytes;
	}
	std::vector<uint8_t> buff_quantized(width * height);
	Array2D<uint8_t> quantized_image(width, height, &buff_quantized[0]);
	Color palette[256];
	

	DWORD started = ::timeGetTime();
	
	if (!scolorq(image, quantized_image, palette, num_colors)) {
		return -1;
	}
	
	DWORD timeTaken = ::timeGetTime() - started;
	printf("time taken : %d ms, call count : %d\n", timeTaken, call_count);

	{
		FILE* out = _tfopen(argv[2], _T("wb"));
		if (out == NULL) {
			printf("Could not open output file '%s'.\n", argv[2]);
			return -1;
		}
		File file(out);
		uint8_t bytePalettes[256][3];
		for (size_t i=0; i<num_colors; ++i) {
			Color col = palette[i];
			bytePalettes[i][0] = (unsigned char)(pow(col[0], gamma) * 255.0);
			bytePalettes[i][1] = (unsigned char)(pow(col[1], gamma) * 255.0);
			bytePalettes[i][2] = (unsigned char)(pow(col[2], gamma) * 255.0);
		}
		std::vector<uint8_t> bytes(imageInfo.width * imageInfo.height * 3);
		uint8_t* pLine = &bytes[0];
		for (int y=0; y<height; y++) {
			for (int x=0; x<width; x++) {
				const uint8_t idx = quantized_image[y][x];
				const uint8_t* pal = bytePalettes[idx];
				*pLine++ = pal[0];
				*pLine++ = pal[1];
				*pLine++ = pal[2];
			}
		}
		WriteImage(file, imageInfo, &bytes[0], imageInfo.width * 3);
		fclose(out);
	}

	return 0;
}

