#pragma once

#include <intrin.h>

// http://www2.kobe-u.ac.jp/~lerl2/l_cc_p_10.1.008/doc/main_cls/mergedProjects/intref_cls/

struct Color4d;

struct Color4f
{
	__m128 v;
	
	Color4f() {
		;
	}
	
	Color4f(const Color4f& c) {
		v = c.v;
	}
	
	Color4f(float r, float g, float b, float a) {
		v = _mm_set_ps(r,g,b,a);
	}
	
	Color4f& operator = (const Color4f& rhs) {
		v = rhs.v;
		return *this;
	}

	Color4f& operator = (const Color4d& rhs);
	
	Color4f direct_product(const Color4f& rhs) const {
		Color4f result;
#if 1
		result.v = _mm_mul_ps(v, rhs.v);
#else
		for (int i=0; i<3; i++) {
			result[i] = (*this)[i] * rhs[i];
		}
#endif
		return result;
	}

	float dot_product(const Color4f& rhs) {
// http://www.icnet.ne.jp/~nsystem/simd_tobira/dpps.html
		float result = 0;
		for (int i=0; i<3; i++) {
			result += (*this)[i] * rhs[i];
		}
		return result;
	}

	Color4f& operator += (const Color4f& rhs) {
		v = _mm_add_ps(v, rhs.v);
		return *this;
	}
	
	Color4f operator + (const Color4f& rhs) {
		Color4f result(*this);
		result += rhs;
		return result;
	}

	Color4f& operator -= (const Color4f& rhs) {
		v = _mm_sub_ps(v, rhs.v);
		return *this;
	}

	Color4f operator - (const Color4f& rhs) {
		Color4f result(*this);
		result -= rhs;
		return result;
	}
	
	Color4f& operator *= (const Color4f& rhs) {
		v = _mm_mul_ps(v, rhs.v);
		return *this;
	}

	Color4f operator * (const Color4f& rhs) {
		Color4f result(*this);
		result *= rhs;
		return result;
	}

	Color4f& operator *= (float scalar) {
		__m128 s = _mm_set1_ps(scalar);
		v = _mm_mul_ps(v, s);
		return *this;
	}

	Color4f operator * (float scalar) {
		Color4f result(*this);
		result *= scalar;
		return result;
	}

	float& operator[] (int idx) {
		return v.m128_f32[3-idx];
	}
	const float& operator[] (int idx) const {
		return v.m128_f32[3-idx];
	}

	float norm_squared() {
		float result = 0;
		for (int i=0; i<3; i++) {
			result += (*this)[i] * (*this)[i];
		}
		return result;
	}

	void zero() {
		v = _mm_setzero_ps();
	}
};

inline Color4f operator * (float scalar, const Color4f& c) {
	Color4f tmp = c;
	return tmp * scalar;
}

