#pragma once

#include <intrin.h>

struct Color4d
{
	__m128d v[2];
	
	Color4d() {
		;
	}
	
	Color4d(const Color4d& c) {
		*this = c;
	}
	
	Color4d(double r, double g, double b, double a) {
		v[0] = _mm_setr_pd(r,g);
		v[1] = _mm_setr_pd(b,a);
	}
	
	Color4d& operator = (const Color4d& rhs) {
		v[0] = rhs.v[0];
		v[1] = rhs.v[1];
		return *this;
	}

	Color4d direct_product(const Color4d& rhs) const {
		Color4d result;
#if 1
		result.v[0] = _mm_mul_pd(v[0], rhs.v[0]);
		result.v[1] = _mm_mul_pd(v[1], rhs.v[1]);
#else
		for (int i=0; i<3; i++) {
			result[i] = (*this)[i] * rhs[i];
		}
#endif
		return result;
	}

	double dot_product(const Color4d& rhs) {
// http://www.icnet.ne.jp/~nsystem/simd_tobira/dpps.html
#if 1
		Color4d result = (*this) * rhs;
		__m128d v = _mm_add_pd(result.v[0], result.v[1]);
		v = _mm_hadd_pd(v, v);
		return v.m128d_f64[0];
#else
		double result = 0;
		for (int i=0; i<3; i++) {
			result += (*this)[i] * rhs[i];
		}
		return result;
#endif
	}

	Color4d& operator += (const Color4d& rhs) {
		v[0] = _mm_add_pd(v[0], rhs.v[0]);
		v[1] = _mm_add_pd(v[1], rhs.v[1]);
		return *this;
	}

/*
	Color4d& operator += (const Color4f& rhs) {
		v[0] = _mm_add_pd(v[0], _mm_cvtps_pd(rhs.v));
		v[1] = _mm_add_pd(v[1], _mm_cvtps_pd(_mm_movehl_ps(rhs.v, rhs.v)));
		return *this;
	}
*/

	Color4d operator + (const Color4d& rhs) {
		return Color4d(*this) += rhs;
	}

	Color4d& operator -= (const Color4d& rhs) {
		v[0] = _mm_sub_pd(v[0], rhs.v[0]);
		v[1] = _mm_sub_pd(v[1], rhs.v[1]);
		return *this;
	}

	Color4d operator - (const Color4d& rhs) {
		return Color4d(*this) -= rhs;
	}
	
	Color4d& operator *= (const Color4d& rhs) {
		v[0] = _mm_mul_pd(v[0], rhs.v[0]);
		v[1] = _mm_mul_pd(v[1], rhs.v[1]);
		return *this;
	}

	Color4d operator * (const Color4d& rhs) {
		return Color4d(*this) *= rhs;
	}

	Color4d& operator *= (double scalar) {
		__m128d s = _mm_set1_pd(scalar);
		v[0] = _mm_mul_pd(v[0], s);
		v[1] = _mm_mul_pd(v[1], s);
		return *this;
	}

	Color4d operator * (double scalar) {
		return Color4d(*this) *= scalar;
	}
	
	double& operator[] (int idx) {
		return ((double*)&v)[idx];
	}
	const double& operator[] (int idx) const {
		return ((double*)&v)[idx];
	}
	
	double norm_squared() {
#if 1
		__m128d t = _mm_add_pd(
			_mm_mul_pd(v[0], v[0]),
			_mm_mul_pd(v[1], v[1])
			);
		t = _mm_hadd_pd(t, t);
		return t.m128d_f64[0];
#else
		double result = 0;
		for (int i=0; i<3; i++) {
			result += (*this)[i] * (*this)[i];
		}
		return result;
#endif
	}
	
	void zero() {
		v[0] = _mm_setzero_pd();
		v[1] = _mm_setzero_pd();
	}
};

inline Color4d operator * (double scalar, const Color4d& c) {
	return Color4d(c) *= scalar;
}

inline Color4d operator * (const Color4d& c, double scalar) {
	return Color4d(c) *= scalar;
}

