#pragma once

#include <immintrin.h>

struct Color4d
{
	__m256d v;
	
	Color4d() {
		;
	}
	
	Color4d(const Color4d& c) {
		*this = c;
	}
	
	Color4d(double r, double g, double b, double a) {
		v = _mm256_setr_pd(r,g,b,a);
	}
	
	Color4d& operator = (const Color4d& rhs) {
		v = rhs.v;
		return *this;
	}

	Color4d direct_product(const Color4d& rhs) const {
		Color4d result;
		result.v = _mm256_mul_pd(v, rhs.v);
		return result;
	}

	double dot_product(const Color4d& rhs) {
// http://www.icnet.ne.jp/~nsystem/simd_tobira/dpps.html
		__m256d s = _mm256_mul_pd(this->v, rhs.v);
		__m128d s1 = _mm256_extractf128_pd(s, 0);
		__m128d s2 = _mm256_extractf128_pd(s, 1);
		__m128d as = _mm_add_pd(s1, s2);
		as = _mm_hadd_pd(as, as);
		return as.m128d_f64[0];
	}

	Color4d& operator += (const Color4d& rhs) {
		v = _mm256_add_pd(v, rhs.v);
		return *this;
	}

	Color4d operator + (const Color4d& rhs) {
		return Color4d(*this) += rhs;
	}

	Color4d& operator -= (const Color4d& rhs) {
		v = _mm256_sub_pd(v, rhs.v);
		return *this;
	}

	Color4d operator - (const Color4d& rhs) {
		return Color4d(*this) -= rhs;
	}
	
	Color4d& operator *= (const Color4d& rhs) {
		v = _mm256_mul_pd(v, rhs.v);
		return *this;
	}

	Color4d operator * (const Color4d& rhs) {
		return Color4d(*this) *= rhs;
	}

	Color4d& operator *= (double scalar) {
		__m256d s = _mm256_set1_pd(scalar);
		v = _mm256_mul_pd(v, s);
		return *this;
	}

	Color4d operator * (double scalar) {
		return Color4d(*this) *= scalar;
	}
	
	double& operator[] (int idx) {
		return ((double*)&v)[idx];
	}
	const double& operator[] (int idx) const {
		return ((double*)&v)[idx];
	}
	
	double norm_squared() {
#if 1
		__m256d s = _mm256_mul_pd(v, v);
		__m128d s1 = _mm256_extractf128_pd(s, 0);
		__m128d s2 = _mm256_extractf128_pd(s, 1);
		__m128d as = _mm_add_pd(s1, s2);
		as = _mm_hadd_pd(as, as);
		return as.m128d_f64[0];
#else
		double result = 0;
		for (int i=0; i<3; i++) {
			result += (*this)[i] * (*this)[i];
		}
		return result;
#endif
	}
	
	void zero() {
		v = _mm256_setzero_pd();
	}
};

inline Color4d operator * (double scalar, const Color4d& c) {
	return Color4d(c) *= scalar;
}

inline Color4d operator * (const Color4d& c, double scalar) {
	return Color4d(c) *= scalar;
}

