#include "stdafx.h"

#include "element.h"
#include "arrayutil.h"

namespace {

size_t s_nEventEntries;
MG::Element::EventListenerEntry s_eventEntries[128];

} // anonymous namespace

namespace MG {

// static
Element* Element::s_pCapture_ = 0;

Element::Element(size_t nMaxEvents)
{
	eventEntries_.buff_ = &s_eventEntries[s_nEventEntries];
	eventEntries_.maxLength_ = nMaxEvents;
	s_nEventEntries += nMaxEvents;
	assert(s_nEventEntries < countof(s_eventEntries));
	
	pParent_ = 0;
	needsToDraw_ = false;
	pBG_ = 0;
	pEventListenerParam_ = 0;
}

// virtual
void Element::Draw(int16_t offsetX, int16_t offsetY, IRenderer& renderer)
{
	Rectangle r = rect_;
	r.x += offsetX;
	r.y += offsetY;
	
	if (pBG_) {
		pBG_->Draw(r, renderer);
	}
}

// virtual
bool Element::HitTest(int16_t x, int16_t y) const
{
	return rect_.Contains(x, y);
}

void Element::AddEventListener(int type, const EventListener& listener)
{
	EventListenerEntry entry;
	entry.type = type;
	entry.listener = listener;
	eventEntries_.push_back(entry);
}

void Element::RemoveEventListener(int type, const EventListener& listener)
{
	for (size_t i=0; i<eventEntries_.length_; ++i) {
		EventListenerEntry& entry = eventEntries_[i];
		if (entry.type == type && entry.listener == listener) {
			entry.type = 0;
			entry.listener = 0;
			break;
		}
	}
}

void Element::fireEventListener(const Event& e)
{
	for (size_t i=0; i<eventEntries_.length_; ++i) {
		EventListenerEntry& entry = eventEntries_[i];
		if (entry.type == e.type) {
			entry.listener(pEventListenerParam_, e);
		}
	}
}

// virtual
void Element::OnMouseDown(int16_t x, int16_t y)
{
	Event e;
	e.target = this;
	e.type = EventType_MouseDown;
	e.x = x;
	e.y = y;
	fireEventListener(e);
}

// virtual
void Element::OnMouseUp(int16_t x, int16_t y)
{
	Event e;
	e.target = this;
	e.type = EventType_MouseUp;
	e.x = x;
	e.y = y;
	fireEventListener(e);
}

// virtual
void Element::OnMouseMove(int16_t x, int16_t y)
{
	Event e;
	e.target = this;
	e.type = EventType_MouseMove;
	e.x = x;
	e.y = y;
	fireEventListener(e);
}

} // namespace MG
