#pragma once

#include "renderer.h"
#include "element.h"

namespace MG {

class Button
	:
	public Element
{
public:
	Button(size_t nMaxEvents);
	
	void Draw(int16_t offsetX, int16_t offsetY, IRenderer& renderer);
	bool HitTest(int16_t x, int16_t y) const;
	void OnMouseDown(int16_t x, int16_t y);
	void OnMouseUp(int16_t x, int16_t y);
	void OnClick(int16_t x, int16_t y);
	
	IBackground* pBGPressed_;
	
	enum EventType {
		EventType_Click = __super::EventType_End,
		
		EventType_End,
	};
	
protected:
	bool isPressed_;
	
};

} // anonymous MG
